/*
 * Decompiled with CFR 0.152.
 */
package com.example.mightyrtp.managers;

import com.example.mightyrtp.MightyRTP;
import java.io.File;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class MessageManager {
    private final MightyRTP plugin;
    private FileConfiguration messagesConfig;
    private File messagesFile;

    public MessageManager(MightyRTP plugin) {
        this.plugin = plugin;
    }

    public void loadMessages() {
        this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!this.messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
    }

    public void reloadMessages() {
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
    }

    public boolean areTitlesEnabled() {
        return this.plugin.getConfigManager().areTitlesEnabled();
    }

    public void showTitle(Player player) {
        if (!this.areTitlesEnabled()) {
            return;
        }
        String titleText = this.messagesConfig.getString("title.text", "<green>Teleporting to the wild...</green>");
        String subtitleText = this.messagesConfig.getString("subtitle.text", "<aqua>Good luck out there!</aqua>");
        String formattedTitle = this.parseColorTagsToLegacy(titleText);
        String formattedSubtitle = this.parseColorTagsToLegacy(subtitleText);
        player.sendTitle(formattedTitle, formattedSubtitle, 10, 40, 10);
    }

    public String parseColorTagsToLegacy(String text) {
        return text.replace("<black>", "\u00a70").replace("</black>", "").replace("<dark_blue>", "\u00a71").replace("</dark_blue>", "").replace("<dark_green>", "\u00a72").replace("</dark_green>", "").replace("<dark_aqua>", "\u00a73").replace("</dark_aqua>", "").replace("<dark_red>", "\u00a74").replace("</dark_red>", "").replace("<dark_purple>", "\u00a75").replace("</dark_purple>", "").replace("<gold>", "\u00a76").replace("</gold>", "").replace("<gray>", "\u00a77").replace("</gray>", "").replace("<dark_gray>", "\u00a78").replace("</dark_gray>", "").replace("<blue>", "\u00a79").replace("</blue>", "").replace("<green>", "\u00a7a").replace("</green>", "").replace("<aqua>", "\u00a7b").replace("</aqua>", "").replace("<red>", "\u00a7c").replace("</red>", "").replace("<light_purple>", "\u00a7d").replace("</light_purple>", "").replace("<yellow>", "\u00a7e").replace("</yellow>", "").replace("<white>", "\u00a7f").replace("</white>", "").replace("<reset>", "\u00a7r").replace("</reset>", "").replace("<bold>", "\u00a7l").replace("</bold>", "").replace("<italic>", "\u00a7o").replace("</italic>", "").replace("<underlined>", "\u00a7n").replace("</underlined>", "").replace("<strikethrough>", "\u00a7m").replace("</strikethrough>", "");
    }

    public String getMessage(String key) {
        return this.messagesConfig.getString("messages." + key, "&cMessage not found: " + key);
    }

    public void sendMessage(Player player, String key) {
        String message = this.getMessage(key);
        String formattedMessage = this.parseColorTagsToLegacy(message);
        player.sendMessage(formattedMessage);
    }
}

