/*
 * Decompiled with CFR 0.152.
 */
package com.example.mightyrtp.commands;

import com.example.mightyrtp.MightyRTP;
import com.example.mightyrtp.managers.ConfigManager;
import com.example.mightyrtp.managers.CooldownManager;
import com.example.mightyrtp.managers.MessageManager;
import com.example.mightyrtp.utils.TeleportUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RTPCommand
implements CommandExecutor {
    private final MightyRTP plugin;
    private final ConfigManager configManager;
    private final MessageManager messageManager;
    private final CooldownManager cooldownManager;
    private final TeleportUtils teleportUtils;

    public RTPCommand(MightyRTP plugin) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
        this.messageManager = plugin.getMessageManager();
        this.cooldownManager = plugin.getCooldownManager();
        this.teleportUtils = new TeleportUtils(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String formattedMessage;
        String message;
        Player targetPlayer;
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("mightyrtp.rtp")) {
            this.messageManager.sendMessage(player, "no-permission");
            return true;
        }
        if (args.length > 0) {
            if (!player.hasPermission("mightyrtp.rtp.other")) {
                this.messageManager.sendMessage(player, "no-permission");
                return true;
            }
            Player foundPlayer = Bukkit.getPlayer((String)args[0]);
            if (foundPlayer == null) {
                String message2 = this.messageManager.getMessage("player-not-found").replace("{player}", args[0]);
                String formattedMessage2 = this.messageManager.parseColorTagsToLegacy(message2);
                player.sendMessage(formattedMessage2);
                return true;
            }
            targetPlayer = foundPlayer;
        } else {
            targetPlayer = player;
        }
        if (!this.cooldownManager.canUseCommand(targetPlayer)) {
            long timeUntilReset = this.cooldownManager.getTimeUntilReset(targetPlayer);
            int minutes = (int)(timeUntilReset / 60000L);
            int seconds = (int)(timeUntilReset % 60000L / 1000L);
            String timeString = minutes > 0 ? minutes + " minutes " + seconds + " seconds" : seconds + " seconds";
            String messageKey = "cooldown-exceeded";
            String message3 = this.messageManager.getMessage(messageKey).replace("{time}", timeString);
            String formattedMessage3 = this.messageManager.parseColorTagsToLegacy(message3);
            player.sendMessage(formattedMessage3);
            return true;
        }
        if (targetPlayer.hasPermission("mightyrtp.bypass")) {
            message = this.messageManager.getMessage("bypass-active");
            formattedMessage = this.messageManager.parseColorTagsToLegacy(message);
            player.sendMessage(formattedMessage);
        }
        if (this.configManager.isWorldBlacklisted(targetPlayer.getWorld().getName())) {
            this.messageManager.sendMessage(player, "world-blacklisted");
            return true;
        }
        this.messageManager.showTitle(targetPlayer);
        if (targetPlayer.equals((Object)player)) {
            this.messageManager.sendMessage(player, "teleporting");
        } else {
            message = this.messageManager.getMessage("teleporting-other").replace("{player}", targetPlayer.getName());
            formattedMessage = this.messageManager.parseColorTagsToLegacy(message);
            player.sendMessage(formattedMessage);
            this.messageManager.sendMessage(targetPlayer, "teleporting");
        }
        this.teleportUtils.findSafeLocationAsync(targetPlayer.getWorld(), targetPlayer.getLocation(), targetPlayer, result -> {
            if (result.isSuccess()) {
                targetPlayer.teleport(result.getLocation());
                if (targetPlayer.equals((Object)player)) {
                    this.messageManager.sendMessage(player, "teleported");
                } else {
                    String message = this.messageManager.getMessage("teleported-other").replace("{player}", targetPlayer.getName());
                    String formattedMessage = this.messageManager.parseColorTagsToLegacy(message);
                    player.sendMessage(formattedMessage);
                    this.messageManager.sendMessage(targetPlayer, "teleported");
                }
            } else if (result.isTimeout()) {
                if (targetPlayer.equals((Object)player)) {
                    this.messageManager.sendMessage(player, "search-timeout");
                } else {
                    String message = this.messageManager.getMessage("search-timeout");
                    String formattedMessage = this.messageManager.parseColorTagsToLegacy(message);
                    player.sendMessage(formattedMessage);
                    this.messageManager.sendMessage(targetPlayer, "search-timeout");
                }
            } else if (targetPlayer.equals((Object)player)) {
                this.messageManager.sendMessage(player, "no-safe-location");
            } else {
                String message = this.messageManager.getMessage("no-safe-location-other").replace("{player}", targetPlayer.getName());
                String formattedMessage = this.messageManager.parseColorTagsToLegacy(message);
                player.sendMessage(formattedMessage);
                this.messageManager.sendMessage(targetPlayer, "no-safe-location");
            }
        });
        return true;
    }
}

