/*
 * Decompiled with CFR 0.152.
 */
package com.example.mightyrtp.commands;

import com.example.mightyrtp.MightyRTP;
import com.example.mightyrtp.managers.ConfigManager;
import com.example.mightyrtp.managers.MessageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ReloadCommand
implements CommandExecutor {
    private final MightyRTP plugin;
    private final ConfigManager configManager;
    private final MessageManager messageManager;

    public ReloadCommand(MightyRTP plugin) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
        this.messageManager = plugin.getMessageManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("mightyrtp.reload")) {
            if (sender instanceof Player) {
                this.messageManager.sendMessage((Player)sender, "no-permission");
            } else {
                sender.sendMessage("You don't have permission to use this command!");
            }
            return true;
        }
        try {
            this.configManager.reloadConfig();
            this.messageManager.reloadMessages();
            if (sender instanceof Player) {
                this.messageManager.sendMessage((Player)sender, "reload-success");
            } else {
                sender.sendMessage("Configuration reloaded successfully!");
            }
            this.plugin.getLogger().info("Configuration reloaded by " + sender.getName());
        }
        catch (Exception e) {
            if (sender instanceof Player) {
                this.messageManager.sendMessage((Player)sender, "reload-failed");
            } else {
                sender.sendMessage("Failed to reload configuration!");
            }
            this.plugin.getLogger().severe("Failed to reload configuration: " + e.getMessage());
            e.printStackTrace();
        }
        return true;
    }
}

