/*
 * Decompiled with CFR 0.152.
 */
package com.example.mightyrtp.managers;

import com.example.mightyrtp.MightyRTP;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final MightyRTP plugin;
    private FileConfiguration config;

    public ConfigManager(MightyRTP plugin) {
        this.plugin = plugin;
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.config = this.plugin.getConfig();
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public List<String> getBlacklistedWorlds() {
        return this.config.getStringList("blacklisted-worlds");
    }

    public int getTeleportDistance() {
        return this.config.getInt("teleport-distance", 5000);
    }

    public int getMinDistanceFromSpawn() {
        return this.config.getInt("min-distance-from-spawn", 500);
    }

    public List<Material> getSafeBlocks() {
        List safeBlockNames = this.config.getStringList("safe-blocks");
        return safeBlockNames.stream().map(name -> {
            try {
                return Material.valueOf((String)name);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid material name in config: " + name);
                return null;
            }
        }).filter(material -> material != null).collect(Collectors.toList());
    }

    public List<Material> getUnsafeBlocks() {
        List unsafeBlockNames = this.config.getStringList("unsafe-blocks");
        return unsafeBlockNames.stream().map(name -> {
            try {
                return Material.valueOf((String)name);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid material name in config: " + name);
                return null;
            }
        }).filter(material -> material != null).collect(Collectors.toList());
    }

    public boolean isWorldBlacklisted(String worldName) {
        return this.getBlacklistedWorlds().contains(worldName);
    }

    public int getCooldownMaxUses() {
        return this.config.getInt("cooldown.max-uses", 10);
    }

    public int getCooldownTimeWindow() {
        return this.config.getInt("cooldown.time-window", 10);
    }

    public boolean isCooldownEnabled() {
        return this.config.getBoolean("cooldown.enabled", true);
    }

    public boolean areTitlesEnabled() {
        return this.config.getBoolean("titles.enabled", true);
    }

    public boolean isDebugEnabled() {
        return this.config.getBoolean("debug.enabled", false);
    }

    public int getDebugLogAttemptInterval() {
        return this.config.getInt("debug.log-attempt-interval", 10);
    }

    public boolean isAsyncTeleportSearchEnabled() {
        return this.config.getBoolean("performance.async-teleport-search", true);
    }

    public int getMaxSearchTimePerAttempt() {
        return this.config.getInt("performance.max-search-time-per-attempt", 50);
    }

    public int getSafetyStrictness() {
        return this.config.getInt("safety.strictness", 3);
    }

    public int getMaxAttempts() {
        return this.config.getInt("safety.max-attempts", 50);
    }
}

