/*
 * Decompiled with CFR 0.152.
 */
package com.example.mightyrtp.utils;

import org.bukkit.Location;

public class TeleportResult {
    private final Status status;
    private final Location location;
    private final String message;

    private TeleportResult(Status status, Location location, String message) {
        this.status = status;
        this.location = location;
        this.message = message;
    }

    public static TeleportResult success(Location location) {
        return new TeleportResult(Status.SUCCESS, location, null);
    }

    public static TeleportResult failure(String message) {
        return new TeleportResult(Status.FAILURE, null, message);
    }

    public static TeleportResult timeout(String message) {
        return new TeleportResult(Status.TIMEOUT, null, message);
    }

    public boolean isSuccess() {
        return this.status == Status.SUCCESS;
    }

    public boolean isTimeout() {
        return this.status == Status.TIMEOUT;
    }

    public boolean isFailure() {
        return this.status == Status.FAILURE;
    }

    public Location getLocation() {
        return this.location;
    }

    public String getMessage() {
        return this.message;
    }

    public Status getStatus() {
        return this.status;
    }

    public static enum Status {
        SUCCESS,
        FAILURE,
        TIMEOUT;

    }
}

