/*
 * Decompiled with CFR 0.152.
 */
package com.example.mightyrtp.utils;

import com.example.mightyrtp.MightyRTP;
import com.example.mightyrtp.managers.ConfigManager;
import com.example.mightyrtp.utils.TeleportResult;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TeleportUtils {
    private final MightyRTP plugin;
    private final ConfigManager configManager;
    private final Random random;

    public TeleportUtils(MightyRTP plugin) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
        this.random = new Random();
    }

    public void findSafeLocationAsync(final World world, final Location center, Player player, final Consumer<TeleportResult> callback) {
        new BukkitRunnable(){

            public void run() {
                final TeleportResult result = TeleportUtils.this.findSafeLocationSync(world, center);
                new BukkitRunnable(){

                    public void run() {
                        callback.accept(result);
                    }
                }.runTask((Plugin)TeleportUtils.this.plugin);
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    private TeleportResult findSafeLocationSync(World world, Location center) {
        Chunk chunk;
        double distanceFromSpawn;
        int z;
        int x;
        double distance;
        double angle;
        int attempt;
        if (world == null) {
            return TeleportResult.failure("World is null");
        }
        int maxAttempts = this.configManager.getMaxAttempts();
        int teleportDistance = this.configManager.getTeleportDistance();
        int minDistanceFromSpawn = this.configManager.getMinDistanceFromSpawn();
        boolean debugEnabled = this.configManager.isDebugEnabled();
        int debugLogInterval = this.configManager.getDebugLogAttemptInterval();
        int centerX = 0;
        int centerZ = 0;
        for (attempt = 1; attempt <= maxAttempts; ++attempt) {
            int highestY;
            block19: {
                angle = Math.random() * 2.0 * Math.PI;
                distance = Math.random() * (double)teleportDistance;
                x = centerX + (int)(Math.cos(angle) * distance);
                distanceFromSpawn = Math.sqrt(x * x + (z = centerZ + (int)(Math.sin(angle) * distance)) * z);
                if (distanceFromSpawn < (double)minDistanceFromSpawn) {
                    if (!debugEnabled || attempt % debugLogInterval != 0) continue;
                    this.plugin.getLogger().info("[MightyRTP] Attempt " + attempt + ": Location at x=" + x + ", z=" + z + " is too close to spawn, skipping...");
                    continue;
                }
                if (!world.isChunkLoaded(x >> 4, z >> 4)) {
                    if (debugEnabled && attempt % debugLogInterval == 0) {
                        this.plugin.getLogger().info("[MightyRTP] Attempt " + attempt + ": Chunk not loaded at x=" + x + ", z=" + z + ", attempting to load...");
                    }
                    try {
                        CompletableFuture chunkFuture = world.getChunkAtAsync(x >> 4, z >> 4, true);
                        chunk = (Chunk)chunkFuture.get(3L, TimeUnit.SECONDS);
                        if (chunk == null || !chunk.isLoaded()) {
                            if (!debugEnabled || attempt % debugLogInterval != 0) continue;
                            this.plugin.getLogger().info("[MightyRTP] Attempt " + attempt + ": Chunk load returned null or failed to load at x=" + x + ", z=" + z);
                            continue;
                        }
                        if (!debugEnabled || attempt % debugLogInterval != 0) break block19;
                        this.plugin.getLogger().info("[MightyRTP] Attempt " + attempt + ": Successfully loaded chunk at x=" + x + ", z=" + z);
                    }
                    catch (Exception e) {
                        if (!debugEnabled || attempt % debugLogInterval != 0) continue;
                        this.plugin.getLogger().info("[MightyRTP] Attempt " + attempt + ": Failed to load chunk at x=" + x + ", z=" + z + ": " + e.getMessage());
                        continue;
                    }
                }
            }
            if ((highestY = this.findHighestSolidBlockSmart(world, x, z)) == -1) {
                if (!debugEnabled || attempt % debugLogInterval != 0) continue;
                this.plugin.getLogger().info("[MightyRTP] Attempt " + attempt + ": No solid block found at x=" + x + ", z=" + z + ", skipping...");
                continue;
            }
            if (debugEnabled && attempt % debugLogInterval == 0) {
                this.plugin.getLogger().info("[MightyRTP] Attempt " + attempt + ": Checking location at x=" + x + ", z=" + z + ", y=" + highestY + "...");
            }
            if (!this.isLocationSafe(world, x, highestY, z, this.configManager.getSafeBlocks(), this.configManager.getUnsafeBlocks())) continue;
            if (debugEnabled) {
                this.plugin.getLogger().info("[MightyRTP] Found safe location at x=" + x + ", z=" + z + ", y=" + highestY + " after " + attempt + " attempts");
            }
            int adjustedY = highestY + 1;
            Location location = new Location(world, (double)x, (double)adjustedY, (double)z);
            return TeleportResult.success(location);
        }
        if (debugEnabled) {
            this.plugin.getLogger().info("[MightyRTP] Failed to find a safe location after " + maxAttempts + " attempts in world: " + world.getName());
        }
        if (debugEnabled) {
            this.plugin.getLogger().info("[MightyRTP] Trying aggressive fallback - loading chunks in smaller radius...");
        }
        for (attempt = 1; attempt <= 30; ++attempt) {
            int highestY;
            angle = Math.random() * 2.0 * Math.PI;
            distance = Math.random() * 1000.0;
            x = centerX + (int)(Math.cos(angle) * distance);
            distanceFromSpawn = Math.sqrt(x * x + (z = centerZ + (int)(Math.sin(angle) * distance)) * z);
            if (distanceFromSpawn < (double)minDistanceFromSpawn) continue;
            if (!world.isChunkLoaded(x >> 4, z >> 4)) {
                try {
                    CompletableFuture chunkFuture = world.getChunkAtAsync(x >> 4, z >> 4, true);
                    chunk = (Chunk)chunkFuture.get(2L, TimeUnit.SECONDS);
                    if (chunk == null) continue;
                    if (!chunk.isLoaded()) {
                    }
                }
                catch (Exception e) {}
                continue;
            }
            if ((highestY = this.findHighestSolidBlockSmart(world, x, z)) == -1 || !this.isLocationSafe(world, x, highestY, z, this.configManager.getSafeBlocks(), this.configManager.getUnsafeBlocks())) continue;
            if (debugEnabled) {
                this.plugin.getLogger().info("[MightyRTP] Found safe location in aggressive fallback at x=" + x + ", z=" + z + ", y=" + highestY);
            }
            int adjustedY = highestY + 1;
            Location location = new Location(world, (double)x, (double)adjustedY, (double)z);
            return TeleportResult.success(location);
        }
        return TeleportResult.failure("Could not find a safe location after " + maxAttempts + " attempts");
    }

    @Deprecated
    public TeleportResult findSafeLocation(World world, Location center) {
        return this.findSafeLocationSync(world, center);
    }

    private boolean isLocationSafe(World world, int x, int y, int z, List<Material> safeBlocks, List<Material> unsafeBlocks) {
        try {
            Block block = world.getBlockAt(x, y, z);
            Block blockAbove = world.getBlockAt(x, y + 1, z);
            Block blockBelow = world.getBlockAt(x, y - 1, z);
            if (unsafeBlocks.contains(blockBelow.getType())) {
                if (this.configManager.isDebugEnabled()) {
                    this.plugin.getLogger().info("Location rejected: Block below is explicitly unsafe - " + blockBelow.getType() + " at y=" + (y - 1));
                }
                return false;
            }
            int safetyStrictness = this.configManager.getSafetyStrictness();
            if (safetyStrictness <= 2) {
                Block blockAbove2;
                if (block.getType() == Material.AIR || block.getType().name().contains("LEAVES")) {
                    if (this.configManager.isDebugEnabled()) {
                        this.plugin.getLogger().info("Location rejected: Very strict mode - cannot teleport to air or leaves");
                    }
                    return false;
                }
                if (blockAbove.getType() != Material.AIR) {
                    if (this.configManager.isDebugEnabled()) {
                        this.plugin.getLogger().info("Location rejected: Very strict mode - not enough air space above");
                    }
                    return false;
                }
                if (y + 2 < world.getMaxHeight() && (blockAbove2 = world.getBlockAt(x, y + 2, z)).getType() != Material.AIR) {
                    if (this.configManager.isDebugEnabled()) {
                        this.plugin.getLogger().info("Location rejected: Very strict mode - not enough vertical space");
                    }
                    return false;
                }
            } else if (safetyStrictness >= 4) {
                if (block.getType() == Material.AIR) {
                    if (this.configManager.isDebugEnabled()) {
                        this.plugin.getLogger().info("Location rejected: Very lenient mode - cannot teleport to air");
                    }
                    return false;
                }
                if (blockAbove.getType() != Material.AIR) {
                    if (this.configManager.isDebugEnabled()) {
                        this.plugin.getLogger().info("Location rejected: Very lenient mode - not enough air space above");
                    }
                    return false;
                }
            } else {
                Block blockAbove2;
                if (block.getType() == Material.AIR) {
                    if (this.configManager.isDebugEnabled()) {
                        this.plugin.getLogger().info("Location rejected: Normal mode - cannot teleport to air");
                    }
                    return false;
                }
                if (blockAbove.getType() != Material.AIR) {
                    if (this.configManager.isDebugEnabled()) {
                        this.plugin.getLogger().info("Location rejected: Normal mode - not enough air space above");
                    }
                    return false;
                }
                if (y + 2 < world.getMaxHeight() && (blockAbove2 = world.getBlockAt(x, y + 2, z)).getType() != Material.AIR) {
                    if (this.configManager.isDebugEnabled()) {
                        this.plugin.getLogger().info("Location rejected: Normal mode - not enough vertical space");
                    }
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            if (this.configManager.isDebugEnabled()) {
                this.plugin.getLogger().info("Location rejected: Exception during safety check at x=" + x + ", z=" + z + ": " + e.getMessage());
            }
            return false;
        }
    }

    private int findHighestSolidBlockSmart(World world, int x, int z) {
        try {
            for (int y = 120; y >= 32; --y) {
                Block block = world.getBlockAt(x, y, z);
                if (block.getType() == Material.AIR || block.getType() == Material.CAVE_AIR || block.getType() == Material.VOID_AIR) continue;
                return y;
            }
            return -1;
        }
        catch (Exception e) {
            return -1;
        }
    }
}

