/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.api.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.fusion.api.texture.FusionTextureTypeRegistry;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.util.Pair;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

public abstract class FusionTextureMetadataProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private final Map<ResourceLocation, Pair<TextureType<Object>, Object>> metadata = new HashMap<ResourceLocation, Pair<TextureType<Object>, Object>>();
    private final String modName;
    private final DataGenerator generator;

    public FusionTextureMetadataProvider(String modid, DataGenerator generator) {
        this.modName = ModList.get().getModContainerById(modid).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse(modid);
        this.generator = generator;
    }

    public final void m_6865_(HashCache cache) throws IOException {
        this.generate();
        Path output = this.generator.m_123916_();
        for (Map.Entry<ResourceLocation, Pair<TextureType<Object>, Object>> entry : this.metadata.entrySet()) {
            ResourceLocation location = entry.getKey();
            Pair<TextureType<Object>, Object> metadata = entry.getValue();
            String extension = location.m_135815_().endsWith(".mcmeta") ? "" : (location.m_135815_().lastIndexOf(46) > location.m_135815_().lastIndexOf(47) ? ".mcmeta" : ".png.mcmeta");
            Path path = Path.of("assets", location.m_135827_(), "textures", location.m_135815_() + extension);
            JsonObject json = new JsonObject();
            json.add("fusion", (JsonElement)FusionTextureTypeRegistry.serializeTextureData(metadata.left(), metadata.right()));
            DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)json, (Path)output.resolve(path));
        }
    }

    protected abstract void generate();

    public final <T> void addTextureMetadata(ResourceLocation location, TextureType<T> textureType, T data) {
        Pair<TextureType<T>, T> previousValue = this.metadata.put(location, Pair.of(textureType, data));
        if (previousValue != null) {
            throw new RuntimeException("Duplicate texture metadata for '" + location + "'!");
        }
    }

    public String m_6055_() {
        return "Fusion Texture Metadata Provider: " + this.modName;
    }
}

