/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.entity.model;

import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.entity.VanillaModelLayerProperties;
import com.supermartijn642.fusion.entity.model.ModelTransformer;
import com.supermartijn642.fusion.entity.model.predicates.EntityModelPredicate;
import com.supermartijn642.fusion.util.Triple;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;

public class EntityLayerProperties {
    public static final RandomSource RANDOM = new SingleThreadedRandomSource(0L);
    private final ModelLayerLocation identifier;
    private final List<ModelOption> defaultModel;
    private final List<Pair<EntityModelPredicate, List<ModelOption>>> conditionals;

    public EntityLayerProperties(ModelLayerLocation identifier, List<ModelOption> defaultModel, List<Pair<EntityModelPredicate, List<ModelOption>>> conditionals) {
        this.identifier = identifier;
        this.defaultModel = defaultModel;
        this.conditionals = conditionals;
    }

    public ModelLayerLocation identifier() {
        return this.identifier;
    }

    public Triple<ModelPart, ResourceLocation, Float> chooseModel(Entity entity) {
        List<ModelOption> options = this.defaultModel;
        for (Pair<EntityModelPredicate, List<ModelOption>> conditional : this.conditionals) {
            if (!conditional.left().test(entity)) continue;
            options = conditional.right();
            break;
        }
        if (options.size() == 1 && (options.get((int)0).textures == null || options.get((int)0).textures.size() == 1)) {
            return Triple.of(options.get((int)0).model, options.get((int)0).textures == null ? null : options.get((int)0).textures.get(0), options.get((int)0).scaling);
        }
        RANDOM.setSeed(this.seed(entity.m_142081_()));
        double value = RANDOM.nextDouble();
        double sum = 0.0;
        ModelOption option = null;
        for (ModelOption o : options) {
            if (!((sum += o.weight) >= value)) continue;
            option = o;
            break;
        }
        if (option == null) {
            throw new AssertionError((Object)("Weights should add up to 1, yet no model was found for value '" + value + "'!"));
        }
        ResourceLocation texture = option.textures == null ? null : (option.textures.size() > 1 ? option.textures.get(RANDOM.nextInt(option.textures.size())) : option.textures.get(0));
        return Triple.of(option.model, texture, option.scaling);
    }

    private long seed(UUID uuid) {
        return uuid.getLeastSignificantBits() ^ uuid.getMostSignificantBits() ^ (long)this.identifier.m_171124_().hashCode();
    }

    public void gatherModels(Consumer<ModelPart> output) {
        for (ModelOption modelOption : this.defaultModel) {
            output.accept(modelOption.model);
        }
        for (Pair pair : this.conditionals) {
            for (ModelOption option : (List)pair.right()) {
                output.accept(option.model);
            }
        }
    }

    public EntityLayerProperties transformed(VanillaModelLayerProperties properties) {
        return new EntityLayerProperties(this.identifier, this.defaultModel.stream().map(o -> o.transformed(properties)).toList(), this.conditionals.stream().map(c -> c.mapRight(l -> l.stream().map(o -> o.transformed(properties)).toList())).toList());
    }

    public static class ModelOption {
        private final ModelPart model;
        private final boolean isVanillaModel;
        private final List<ResourceLocation> textures;
        private final double weight;
        private final Float scaling;

        public ModelOption(ModelPart model, boolean isVanillaModel, List<ResourceLocation> textures, double weight, Float scaling) {
            this.model = model;
            this.isVanillaModel = isVanillaModel;
            this.textures = textures;
            this.weight = weight;
            this.scaling = scaling;
        }

        public double weight() {
            return this.weight;
        }

        public ModelPart model() {
            return this.model;
        }

        public boolean isVanillaModel() {
            return this.isVanillaModel;
        }

        public List<ResourceLocation> textures() {
            return this.textures;
        }

        public Float scaling() {
            return this.scaling;
        }

        private ModelOption transformed(VanillaModelLayerProperties properties) {
            if (this.isVanillaModel) {
                return this;
            }
            ModelPart model = this.model;
            if (properties.getOffsetX() != 0.0f) {
                model = ModelTransformer.translateX(model, properties.getOffsetX());
            }
            if (properties.getOffsetY() != 0.0f) {
                model = ModelTransformer.translateY(model, properties.getOffsetY());
            }
            if (properties.getOffsetZ() != 0.0f) {
                model = ModelTransformer.translateZ(model, properties.getOffsetZ());
            }
            if (properties.shouldFlipX()) {
                model = ModelTransformer.flipX(model);
            }
            if (properties.shouldFlipY()) {
                model = ModelTransformer.flipY(model);
            }
            if (properties.shouldFlipZ()) {
                model = ModelTransformer.flipZ(model);
            }
            return new ModelOption(model, false, this.textures, this.weight, this.scaling);
        }
    }
}

