/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;

public class FusionMixinPlugin
implements IMixinConfigPlugin {
    private boolean isModernFixLoaded;
    private boolean isOptiFineLoaded;
    private boolean isEmbeddiumLoaded;
    private boolean isRubidiumLoaded;

    public void onLoad(String mixinPackage) {
        this.isModernFixLoaded = FusionMixinPlugin.isClassAvailable("org.embeddedt.modernfix.ModernFix");
        this.isOptiFineLoaded = FusionMixinPlugin.isClassAvailable("optifine.Installer");
        this.isEmbeddiumLoaded = FusionMixinPlugin.isClassAvailable("org.embeddedt.embeddium.api.eventbus.EmbeddiumEvent");
        this.isRubidiumLoaded = !this.isEmbeddiumLoaded && FusionMixinPlugin.isClassAvailable("me.jellysquid.mods.sodium.client.SodiumClientMod");
    }

    private static boolean isClassAvailable(String className) {
        try {
            MixinService.getService().getBytecodeProvider().getClassNode(className);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if ((this.isModernFixLoaded || this.isOptiFineLoaded) && mixinClassName.endsWith(".TextureAtlasMixin")) {
            return false;
        }
        if (this.isEmbeddiumLoaded && mixinClassName.endsWith(".ItemRendererMixin")) {
            return false;
        }
        return !this.isRubidiumLoaded || !mixinClassName.endsWith(".ItemRendererMixin");
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        ArrayList<String> mixins = new ArrayList<String>();
        if (this.isModernFixLoaded || this.isOptiFineLoaded) {
            mixins.add("modernfix.SimpleResourceMixin");
            mixins.add("modernfix.TextureAtlasMixinModernFix");
        }
        if (this.isEmbeddiumLoaded) {
            mixins.add("embeddium.BlockRendererMixinEmbeddium");
            mixins.add("embeddium.ItemRendererMixinEmbeddium");
        }
        if (this.isRubidiumLoaded) {
            mixins.add("rubidium.BlockRendererMixinRubidium");
            mixins.add("rubidium.ItemRendererMixinRubidium");
        }
        return mixins;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

