/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.supermartijn642.fusion.model.types.base.CustomRenderTypeBakedModel;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.WeightedBakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.IForgeBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WeightedBakedModel.class})
public class WeightedBakedModelMixin
implements IForgeBakedModel,
CustomRenderTypeBakedModel {
    @Final
    @Shadow
    private int f_119540_;
    @Final
    @Shadow
    private List<WeightedEntry.Wrapper<BakedModel>> f_119541_;
    @Unique
    private static final ConcurrentHashMap<Class<? extends IForgeBakedModel>, Boolean> MODELS_PRODUCING_DATA = new ConcurrentHashMap();
    @Unique
    private Set<RenderType> customBlockRenderTypes;
    @Unique
    private boolean fusion$innerModelProducesData;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void init(List<WeightedEntry.Wrapper<BakedModel>> models, CallbackInfo ci) {
        HashSet customBlockRenderTypes = new HashSet();
        this.f_119541_.stream().map(WeightedEntry.Wrapper::m_146310_).filter(CustomRenderTypeBakedModel.class::isInstance).map(CustomRenderTypeBakedModel.class::cast).map(CustomRenderTypeBakedModel::getBlockRenderTypes).forEach(customBlockRenderTypes::addAll);
        this.customBlockRenderTypes = Set.copyOf(customBlockRenderTypes);
        this.fusion$innerModelProducesData = this.f_119541_.stream().anyMatch(w -> w.m_146310_() != null && MODELS_PRODUCING_DATA.computeIfAbsent(((BakedModel)w.m_146310_()).getClass(), clz -> {
            try {
                Method method = clz.getMethod("getModelData", BlockAndTintGetter.class, BlockPos.class, BlockState.class, IModelData.class);
                return method.getDeclaringClass() != IForgeBakedModel.class;
            }
            catch (NoSuchMethodException e) {
                return true;
            }
        }) != false);
    }

    @NotNull
    public IModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull IModelData modelData) {
        if (state == null || !this.fusion$innerModelProducesData) {
            return modelData;
        }
        Random randomSource = new Random(state.m_60726_(pos));
        BakedModel model = WeightedRandom.m_146314_(this.f_119541_, (int)(Math.abs((int)randomSource.nextLong()) % this.f_119540_)).map(WeightedEntry.Wrapper::m_146310_).orElse(null);
        return model == null ? modelData : model.getModelData(level, pos, state, modelData);
    }

    @Override
    public Collection<RenderType> getBlockRenderTypes() {
        return this.customBlockRenderTypes;
    }
}

