/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.base;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.ModelBakingContext;
import com.supermartijn642.fusion.api.model.ModelType;
import com.supermartijn642.fusion.api.model.data.BaseModelData;
import com.supermartijn642.fusion.model.types.base.BaseBakedModel;
import com.supermartijn642.fusion.model.types.base.BaseModelDataImpl;
import com.supermartijn642.fusion.model.types.base.BaseModelElement;
import com.supermartijn642.fusion.model.types.base.BaseModelQuad;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.NamedRenderTypeManager;
import org.jetbrains.annotations.Nullable;

public class BaseModelType
implements ModelType<BaseModelData> {
    @Override
    public Collection<ResourceLocation> getModelDependencies(BaseModelData data) {
        return data.getParents();
    }

    @Override
    @Nullable
    public BlockModel getAsVanillaModel(BaseModelData data) {
        return data.getVanillaModel();
    }

    @Override
    public List<ResourceLocation> getParentModels(BaseModelData data) {
        return data.getParents();
    }

    @Override
    public BakedModel bake(ModelBakingContext context, BaseModelData data) {
        ((BaseModelDataImpl)data).validateParents(context);
        List<BaseModelQuad> quads = ((BaseModelDataImpl)data).bakeQuads(context);
        boolean ambientOcclusion = ((BaseModelDataImpl)data).findProperty(context, model -> model.f_111424_, true);
        boolean isGui3d = ((BaseModelDataImpl)data).findProperty(context, model -> model == ModelBakery.f_119232_ ? Boolean.valueOf(false) : null, true);
        boolean usesBlockLight = ((BaseModelDataImpl)data).findProperty(context, model -> model.f_111423_, BlockModel.GuiLight.SIDE).m_111526_();
        TextureAtlasSprite particleSprite = context.getTexture(((BaseModelDataImpl)data).findParticleSprite(context));
        ItemTransform transformThirdPersonLeftHand = ((BaseModelDataImpl)data).findProperty(context, model -> model.f_111425_.m_111810_(ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND) ? model.f_111425_.m_111808_(ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND) : null, ItemTransform.f_111754_);
        ItemTransform transformThirdPersonRightHand = ((BaseModelDataImpl)data).findProperty(context, model -> model.f_111425_.m_111810_(ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) ? model.f_111425_.m_111808_(ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) : null, ItemTransform.f_111754_);
        ItemTransform transformFirstPersonLeftHand = ((BaseModelDataImpl)data).findProperty(context, model -> model.f_111425_.m_111810_(ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND) ? model.f_111425_.m_111808_(ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND) : null, ItemTransform.f_111754_);
        ItemTransform transformFirstPersonRightHand = ((BaseModelDataImpl)data).findProperty(context, model -> model.f_111425_.m_111810_(ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) ? model.f_111425_.m_111808_(ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) : null, ItemTransform.f_111754_);
        ItemTransform transformHead = ((BaseModelDataImpl)data).findProperty(context, model -> model.f_111425_.m_111810_(ItemTransforms.TransformType.HEAD) ? model.f_111425_.m_111808_(ItemTransforms.TransformType.HEAD) : null, ItemTransform.f_111754_);
        ItemTransform transformGui = ((BaseModelDataImpl)data).findProperty(context, model -> model.f_111425_.m_111810_(ItemTransforms.TransformType.GUI) ? model.f_111425_.m_111808_(ItemTransforms.TransformType.GUI) : null, ItemTransform.f_111754_);
        ItemTransform transformGround = ((BaseModelDataImpl)data).findProperty(context, model -> model.f_111425_.m_111810_(ItemTransforms.TransformType.GROUND) ? model.f_111425_.m_111808_(ItemTransforms.TransformType.GROUND) : null, ItemTransform.f_111754_);
        ItemTransform transformFixed = ((BaseModelDataImpl)data).findProperty(context, model -> model.f_111425_.m_111810_(ItemTransforms.TransformType.FIXED) ? model.f_111425_.m_111808_(ItemTransforms.TransformType.FIXED) : null, ItemTransform.f_111754_);
        ItemTransforms itemTransforms = new ItemTransforms(transformThirdPersonLeftHand, transformThirdPersonRightHand, transformFirstPersonLeftHand, transformFirstPersonRightHand, transformHead, transformGui, transformGround, transformFixed);
        ItemOverrides itemOverrides = data.getVanillaModel().f_111426_.isEmpty() ? ItemOverrides.f_111734_ : new ItemOverrides(context.getModelBaker(), data.getVanillaModel(), data.getVanillaModel().f_111426_);
        RenderType forgeRenderType = NamedRenderTypeManager.get((ResourceLocation)data.getVanillaModel().customData.getRenderTypeHint()).block();
        return new BaseBakedModel(quads, ambientOcclusion, isGui3d, usesBlockLight, particleSprite, itemTransforms, itemOverrides, forgeRenderType);
    }

    @Override
    public BaseModelData deserialize(JsonObject json) throws JsonParseException {
        BlockModel model = (BlockModel)DefaultModelTypes.VANILLA.deserialize(json);
        if (json.has("parent") && json.has("parents")) {
            throw new JsonParseException("Model can only have either 'parent' or 'parents', not both!");
        }
        List<Object> parents = List.of();
        if (json.has("parent")) {
            if (!json.get("parent").isJsonPrimitive() || !json.get("parent").getAsJsonPrimitive().isString()) {
                throw new JsonParseException("Property 'parent' must be a string!");
            }
            String parent = json.get("parent").getAsString();
            if (!IdentifierUtil.isValidIdentifier(parent)) {
                throw new JsonParseException("Property 'parent' must be a valid identifier!");
            }
            parents = List.of(new ResourceLocation(parent));
        } else if (json.has("parents")) {
            if (!json.get("parents").isJsonArray()) {
                throw new JsonParseException("Property 'parents' must be an array!");
            }
            JsonArray parentArray = json.getAsJsonArray("parents");
            parents = new ArrayList(parentArray.size());
            for (JsonElement element : parentArray) {
                if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                    throw new JsonParseException("Array 'parents' must only contain strings!");
                }
                String parent = element.getAsString();
                if (!IdentifierUtil.isValidIdentifier(parent)) {
                    throw new JsonParseException("Array 'parents' must only contain valid identifiers, not '" + parent + "'!");
                }
                parents.add(new ResourceLocation(parent));
            }
            if (!parents.isEmpty()) {
                model.f_111419_ = (ResourceLocation)parents.get(0);
            }
        }
        ArrayList<BaseModelElement> elements = new ArrayList<BaseModelElement>(model.f_111422_.size());
        JsonArray elementsJson = json.getAsJsonArray("elements");
        for (int i = 0; i < model.f_111422_.size(); ++i) {
            BlockElement vanillaElement = (BlockElement)model.f_111422_.get(i);
            Integer lightEmission = null;
            JsonElement lightEmissionJson = elementsJson.get(i).getAsJsonObject().get("light_emission");
            if (lightEmissionJson != null) {
                if (!lightEmissionJson.isJsonPrimitive() || !lightEmissionJson.getAsJsonPrimitive().isNumber()) {
                    throw new JsonParseException("Element property 'light_emission' must be a number!");
                }
                lightEmission = lightEmissionJson.getAsInt();
                if (lightEmission < 0 || lightEmission > 15) {
                    throw new JsonParseException("Element property 'light_emission' must be between 0 and 15!");
                }
            }
            elements.add(new BaseModelElement(vanillaElement.f_111308_, vanillaElement.f_111309_, vanillaElement.f_111310_, vanillaElement.f_111311_, vanillaElement.f_111312_, lightEmission));
        }
        return new BaseModelDataImpl(model, parents, elements);
    }

    @Override
    public JsonObject serialize(BaseModelData value) {
        JsonObject json = DefaultModelTypes.VANILLA.serialize(value.getVanillaModel());
        if (value.getParents().size() > 1) {
            json.remove("parent");
            JsonArray parents = new JsonArray(value.getParents().size());
            value.getParents().forEach(p -> parents.add(p.toString()));
            json.add("parents", (JsonElement)parents);
        }
        for (int i = 0; i < ((BaseModelDataImpl)value).getElements().size(); ++i) {
            Integer lightEmission = ((BaseModelDataImpl)value).getElements().get((int)i).light_emission;
            if (lightEmission == null) continue;
            json.getAsJsonArray("elements").get(i).getAsJsonObject().addProperty("light_emission", (Number)lightEmission);
        }
        return json;
    }
}

