/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model;

import com.mojang.datafixers.util.Pair;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.GatherTexturesContext;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.api.model.SpriteIdentifier;
import com.supermartijn642.fusion.extensions.BlockModelExtension;
import com.supermartijn642.fusion.model.ModelBakingContextImpl;
import com.supermartijn642.fusion.model.ModelInstanceImpl;
import com.supermartijn642.fusion.model.ModelTypeRegistryImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;

public class FusionBlockModel
extends BlockModel {
    public static final IUnbakedModel DUMMY_MODEL = new IUnbakedModel(){

        public Collection<ResourceLocation> func_187965_e() {
            return Collections.emptyList();
        }

        public Collection<Material> func_225614_a_(Function<ResourceLocation, IUnbakedModel> function, Set<Pair<String, String>> set) {
            return Collections.emptyList();
        }

        @Nullable
        public IBakedModel func_225613_a_(ModelBakery modelBakery, Function<Material, TextureAtlasSprite> function, IModelTransform modelState, ResourceLocation resourceLocation) {
            return null;
        }
    };
    private final ModelInstance<?> model;
    private final BlockModel vanillaModel;
    private Collection<ResourceLocation> dependencies;

    public FusionBlockModel(ModelInstance<?> model) {
        super(null, Collections.emptyList(), Collections.emptyMap(), false, null, ItemCameraTransforms.field_178357_a, Collections.emptyList());
        this.model = model;
        this.vanillaModel = model.getAsVanillaModel();
    }

    public IBakedModel func_228813_a_(ModelBakery bakery, BlockModel someOtherModel, Function<Material, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ResourceLocation modelLocation, boolean gui3d) {
        ModelBakingContextImpl context = new ModelBakingContextImpl(bakery, spriteGetter, modelTransform, modelLocation);
        return this.model.bake(context);
    }

    public Collection<ResourceLocation> func_187965_e() {
        if (this.dependencies != null) {
            return this.dependencies;
        }
        try {
            this.dependencies = this.model.getModelDependencies();
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an exception whilst requesting dependencies from model type '" + ModelTypeRegistryImpl.getIdentifier(this.model.getModelType()) + "' for  '" + this.field_178317_b + "'!", e);
        }
        if (this.dependencies == null) {
            throw new RuntimeException("Model type '" + ModelTypeRegistryImpl.getIdentifier(this.model.getModelType()) + "' returned null when requesting dependencies '" + this.field_178317_b + "'!");
        }
        return this.dependencies;
    }

    public Collection<Material> func_225614_a_(Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> errors) {
        GatherTexturesContext context = identifier -> FusionBlockModel.getModelInstance((IUnbakedModel)modelGetter.apply(identifier));
        ArrayList materials = null;
        try {
            Collection<SpriteIdentifier> pairs = this.model.getTextureDependencies(context);
            if (pairs != null) {
                materials = (ArrayList)((Object)pairs.stream().map(SpriteIdentifier::toMaterial).collect(Collectors.toSet()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an exception whilst requesting texture dependencies from model type '" + ModelTypeRegistryImpl.getIdentifier(this.model.getModelType()) + "' for  '" + this.field_178317_b + "'!", e);
        }
        if (materials == null) {
            throw new RuntimeException("Model type '" + ModelTypeRegistryImpl.getIdentifier(this.model.getModelType()) + "' returned null when requesting texture dependencies for '" + this.field_178317_b + "'!");
        }
        Collection<ResourceLocation> dependencies = this.func_187965_e();
        if (!dependencies.isEmpty()) {
            materials = new ArrayList(materials);
            dependencies.forEach(location -> {
                IUnbakedModel model = (IUnbakedModel)modelGetter.apply((ResourceLocation)location);
                if (model == null) {
                    BlockModel.field_178313_f.warn("Could not find dependency model '{}' while loading model '{}'", location, (Object)this);
                }
            });
        }
        return materials;
    }

    public boolean hasVanillaModel() {
        return this.vanillaModel != null;
    }

    public BlockModel getVanillaModel() {
        return this.vanillaModel;
    }

    public static ModelInstance<?> getModelInstance(IUnbakedModel model) {
        if (model instanceof FusionBlockModel) {
            return ((FusionBlockModel)model).model;
        }
        if (model instanceof BlockModel) {
            ModelInstance<?> modelInstance = ((BlockModelExtension)model).getFusionModel();
            if (modelInstance == null) {
                modelInstance = new ModelInstanceImpl<BlockModel>(DefaultModelTypes.VANILLA, (BlockModel)model);
                ((BlockModelExtension)model).setFusionModel(modelInstance);
            }
            return modelInstance;
        }
        return new ModelInstanceImpl<IUnbakedModel>(DefaultModelTypes.UNKNOWN, model);
    }
}

