/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting;

import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;

public class SurroundingBlockCache {
    private final ILightReader level;
    private final BlockPos pos;
    private final BlockState[] states = new BlockState[27];

    public SurroundingBlockCache(ILightReader level, BlockPos pos, BlockState self) {
        this.level = level;
        this.pos = pos;
        this.states[13] = self;
    }

    public void fillAll() {
        for (int index = 0; index < 27; ++index) {
            if (this.states[index] != null) continue;
            int x = index % 3 - 1;
            int y = index % 9 / 3 - 1;
            int z = index / 9 - 1;
            this.states[index] = this.level.func_180495_p(this.pos.func_177982_a(x, y, z));
        }
    }

    public void setSelf(BlockState self) {
        this.states[13] = self;
    }

    public ILightReader getLevel() {
        return this.level;
    }

    public BlockPos getRealPos() {
        return this.pos;
    }

    public BlockState getCenter() {
        return this.states[13];
    }

    public BlockState getState(int x, int y, int z) {
        int index = x + 1 + (y + 1) * 3 + (z + 1) * 9;
        BlockState state = this.states[index];
        if (state == null) {
            state = this.states[index] = this.level.func_180495_p(this.pos.func_177982_a(x, y, z));
        }
        return state;
    }
}

