/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.texture;

import com.supermartijn642.fusion.api.texture.data.BaseTextureData;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.FoliageColors;
import net.minecraft.world.GrassColors;
import net.minecraft.world.ILightReader;
import net.minecraft.world.biome.BiomeColors;

public class QuadTintingHelper {
    private static final IBlockColor[] TINT_FUNCTIONS = new IBlockColor[]{(state, level, pos, tintIndex) -> {
        if (level == null || pos == null) {
            return GrassColors.func_77480_a((double)0.5, (double)1.0);
        }
        return BiomeColors.func_228358_a_((ILightReader)level, (BlockPos)pos);
    }, (state, level, pos, tintIndex) -> {
        if (level == null || pos == null) {
            return FoliageColors.func_77468_c();
        }
        return BiomeColors.func_228361_b_((ILightReader)level, (BlockPos)pos);
    }, (state, level, pos, tintIndex) -> {
        if (level == null || pos == null) {
            return -1;
        }
        return BiomeColors.func_228363_c_((ILightReader)level, (BlockPos)pos);
    }};

    public static int getColor(BaseTextureData.QuadTinting tinting, BlockState state, ILightReader level, BlockPos pos) {
        IBlockColor tintFunction = TINT_FUNCTIONS[tinting.ordinal()];
        return tintFunction.getColor(state, level, pos, 0) | 0xFF000000;
    }

    static {
        if (TINT_FUNCTIONS.length != BaseTextureData.QuadTinting.values().length) {
            throw new AssertionError((Object)"Missing tinting functions!");
        }
    }
}

