/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.base;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.texture.DefaultTextureTypes;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.model.MutableQuad;
import com.supermartijn642.fusion.model.OriginalRenderTypeHelper;
import com.supermartijn642.fusion.model.types.base.BaseModelQuad;
import com.supermartijn642.fusion.model.types.base.CustomRenderTypeBakedModel;
import com.supermartijn642.fusion.texture.types.continuous.ContinuousTextureSprite;
import com.supermartijn642.fusion.texture.types.continuous.ContinuousTextureType;
import com.supermartijn642.fusion.texture.types.random.RandomTextureSprite;
import com.supermartijn642.fusion.texture.types.random.RandomTextureType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class BaseBakedModel
implements IBakedModel,
CustomRenderTypeBakedModel {
    public static final ModelProperty<BlockPos> POSITION_PROPERTY = new ModelProperty();
    private final List<TaggedBakedQuad>[] completeBlockMesh;
    private final Map<RenderType, List<TaggedBakedQuad>[]> blockMesh;
    private final List<BakedQuad> itemMesh;
    private final List<RenderType> blockRenderTypes;
    private final boolean shouldCheckOriginalBlockRenderTypes;
    private final List<TextureAtlasSprite> sprites;
    private final boolean hasSpecialQuads;
    private final boolean hasAmbientOcclusion;
    private final boolean isGui3d;
    private final boolean usesBlockLight;
    private final TextureAtlasSprite particleIcon;
    private final ItemCameraTransforms transforms;
    private final ItemOverrideList overrides;

    public BaseBakedModel(List<BaseModelQuad> quads, boolean hasAmbientOcclusion, boolean isGui3d, boolean usesBlockLight, TextureAtlasSprite particleIcon, ItemCameraTransforms transforms, ItemOverrideList overrides) {
        this.hasAmbientOcclusion = hasAmbientOcclusion;
        this.isGui3d = isGui3d;
        this.usesBlockLight = usesBlockLight;
        this.particleIcon = particleIcon;
        this.transforms = transforms;
        this.overrides = overrides;
        HashMap<RenderType, List[]> blockMesh = new HashMap<RenderType, List[]>();
        HashSet<RenderType> blockRenderTypes = new HashSet<RenderType>();
        ArrayList<BakedQuad> itemMesh = new ArrayList<BakedQuad>();
        HashMap<TextureAtlasSprite, Integer> sprites = new HashMap<TextureAtlasSprite, Integer>();
        boolean hasSpecialQuads = false;
        MutableQuad mutableQuad = new MutableQuad();
        for (BaseModelQuad quad : quads) {
            mutableQuad.fillFromBakedQuad(quad.bakedQuad());
            mutableQuad.emissive(quad.emissive());
            if (quad.lightEmission() != null) {
                for (int i = 0; i < 4; ++i) {
                    int sky = Math.max(quad.lightEmission(), LightTexture.func_228454_b_((int)mutableQuad.lightmap(i)));
                    int block = Math.max(quad.lightEmission(), LightTexture.func_228450_a_((int)mutableQuad.lightmap(i)));
                    mutableQuad.lightmap(i, LightTexture.func_228451_a_((int)sky, (int)block));
                }
            }
            int spriteIndex = -1;
            if (quad.textureType() == DefaultTextureTypes.RANDOM || quad.textureType() == DefaultTextureTypes.CONTINUOUS) {
                spriteIndex = sprites.computeIfAbsent(quad.bakedQuad().func_187508_a(), o -> sprites.size());
                hasSpecialQuads = true;
            }
            TaggedBakedQuad finishedQuad = new TaggedBakedQuad(mutableQuad.toBakedQuad(), quad.textureType(), spriteIndex);
            RenderType renderType = FusionClient.getRenderTypeMaterial(quad.renderType());
            blockRenderTypes.add(renderType);
            int cullIndex = BaseBakedModel.cullIndex(quad.cullDirection());
            List[] mesh = blockMesh.computeIfAbsent(renderType, r -> new List[7]);
            if (mesh[cullIndex] == null) {
                mesh[cullIndex] = new ArrayList();
            }
            mesh[cullIndex].add(finishedQuad);
            itemMesh.add(mutableQuad.toBakedQuad());
        }
        this.blockMesh = ImmutableMap.copyOf(blockMesh);
        this.blockRenderTypes = blockRenderTypes.stream().filter(r -> r != FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER).collect(Collectors.toList());
        this.shouldCheckOriginalBlockRenderTypes = blockRenderTypes.contains(FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER);
        this.itemMesh = ImmutableList.copyOf(itemMesh);
        this.sprites = sprites.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).collect(Collectors.toList());
        this.hasSpecialQuads = hasSpecialQuads;
        this.completeBlockMesh = new List[7];
        for (int i = 0; i < 7; ++i) {
            int cullIndex = i;
            this.completeBlockMesh[i] = this.blockMesh.values().stream().map(arr -> arr[cullIndex]).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        }
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction cullDirection, Random random, IModelData data, @Nullable RenderType renderType) {
        ArrayList<BakedQuad> bakedQuads;
        ArrayList<TaggedBakedQuad> quads;
        if (state == null) {
            return cullDirection == null ? this.itemMesh : Collections.emptyList();
        }
        if (renderType == null) {
            quads = this.completeBlockMesh[BaseBakedModel.cullIndex(cullDirection)];
        } else {
            List<TaggedBakedQuad>[] mesh = this.blockMesh.get(renderType);
            List<TaggedBakedQuad> list = quads = mesh == null ? null : mesh[BaseBakedModel.cullIndex(cullDirection)];
            if (this.shouldCheckOriginalBlockRenderTypes && state != null && OriginalRenderTypeHelper.couldBlockRenderInLayerOriginally(state, renderType)) {
                Iterator<TaggedBakedQuad> additionalQuads;
                mesh = this.blockMesh.get(FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER);
                Iterator<TaggedBakedQuad> iterator = additionalQuads = mesh == null ? null : mesh[BaseBakedModel.cullIndex(cullDirection)];
                if (additionalQuads != null) {
                    if (quads == null) {
                        quads = additionalQuads;
                    } else {
                        ArrayList<TaggedBakedQuad> arrayList = new ArrayList<TaggedBakedQuad>(quads.size() + additionalQuads.size());
                        arrayList.addAll(quads);
                        arrayList.addAll((Collection<TaggedBakedQuad>)((Object)additionalQuads));
                        quads = arrayList;
                    }
                }
            }
            if (quads == null) {
                quads = Collections.emptyList();
            }
        }
        if (!this.hasSpecialQuads) {
            ArrayList<BakedQuad> bakedQuads2 = new ArrayList<BakedQuad>(quads.size());
            for (TaggedBakedQuad taggedBakedQuad : quads) {
                bakedQuads2.add(taggedBakedQuad.bakedQuad);
            }
            return bakedQuads2;
        }
        BlockPos pos = (BlockPos)data.getData(POSITION_PROPERTY);
        if (pos == null) {
            bakedQuads = new ArrayList<BakedQuad>(quads.size());
            for (TaggedBakedQuad quad : quads) {
                bakedQuads.add(quad.bakedQuad);
            }
            return bakedQuads;
        }
        bakedQuads = new ArrayList(quads.size());
        MutableQuad mutableQuad = new MutableQuad();
        for (TaggedBakedQuad quad : quads) {
            if (quad.textureType == DefaultTextureTypes.RANDOM || quad.textureType == DefaultTextureTypes.CONTINUOUS) {
                TextureAtlasSprite sprite = this.sprites.get(quad.spriteIndex);
                mutableQuad.fillFromBakedQuad(quad.bakedQuad);
                if (quad.textureType == DefaultTextureTypes.RANDOM) {
                    RandomTextureType.processQuad(mutableQuad, pos, quad.bakedQuad.func_178210_d(), random, (RandomTextureSprite)sprite);
                } else {
                    ContinuousTextureType.processQuad(mutableQuad, pos, quad.bakedQuad.func_178210_d(), (ContinuousTextureSprite)sprite);
                }
                bakedQuads.add(mutableQuad.toBakedQuad());
                continue;
            }
            bakedQuads.add(quad.bakedQuad);
        }
        return bakedQuads;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction cullDirection, @Nonnull Random random, @Nonnull IModelData data) {
        return this.getQuads(state, cullDirection, random, data, MinecraftForgeClient.getRenderLayer());
    }

    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction cullDirection, Random random) {
        return this.getQuads(state, cullDirection, random, (IModelData)EmptyModelData.INSTANCE, MinecraftForgeClient.getRenderLayer());
    }

    public List<RenderType> getBlockRenderTypes() {
        return this.blockRenderTypes;
    }

    public IModelData getModelData(ILightReader level, BlockPos pos, BlockState state, IModelData data) {
        if (!this.hasSpecialQuads) {
            return EmptyModelData.INSTANCE;
        }
        return new ModelDataMap.Builder().withInitial(POSITION_PROPERTY, (Object)pos).build();
    }

    public boolean func_177555_b() {
        return this.hasAmbientOcclusion;
    }

    public boolean func_177556_c() {
        return this.isGui3d;
    }

    public boolean func_230044_c_() {
        return this.usesBlockLight;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.particleIcon;
    }

    public ItemCameraTransforms func_177552_f() {
        return this.transforms;
    }

    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    private static int cullIndex(Direction cullDirection) {
        return cullDirection == null ? 0 : cullDirection.ordinal() + 1;
    }

    private static class TaggedBakedQuad {
        final BakedQuad bakedQuad;
        final TextureType<?> textureType;
        final int spriteIndex;

        private TaggedBakedQuad(BakedQuad bakedQuad, TextureType<?> textureType, int spriteIndex) {
            this.bakedQuad = bakedQuad;
            this.textureType = textureType;
            this.spriteIndex = spriteIndex;
        }
    }
}

