/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.resources;

import com.mojang.blaze3d.systems.RenderSystem;
import com.supermartijn642.fusion.resources.FusionPackMetadata;
import com.supermartijn642.fusion.resources.MinimumVersionWarningScreen;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.ClientResourcePackInfo;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ResourcePackListTipRenderer {
    private static final ResourceLocation FUSION_LOGO = new ResourceLocation("fusion", "textures/resourcepacks/fusion_icon_blurred.png");

    public static void renderBackground(FusionPackMetadata metadata, boolean isVanillaCompatible, int x, int y, int width, int height) {
        if (isVanillaCompatible && !metadata.isMinVersionSatisfied()) {
            Screen.fill((int)(x - 1), (int)(y - 1), (int)(x + width - 9), (int)(y + height + 1), (int)-9284864);
        }
    }

    public static void renderIcon(FusionPackMetadata metadata, boolean isVanillaCompatible, int x, int y, int width, int height) {
        RenderSystem.enableBlend();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(FUSION_LOGO);
        Screen.blit((int)x, (int)y, (float)0.0f, (float)0.0f, (int)12, (int)12, (int)12, (int)12);
        RenderSystem.disableBlend();
    }

    public static ITextComponent getWarningMessage(FusionPackMetadata metadata, boolean isVanillaCompatible) {
        if (isVanillaCompatible && !metadata.isMinVersionSatisfied()) {
            return new TranslationTextComponent("fusion.resource_packs.requires_newer_version", new Object[0]).func_211708_a(TextFormatting.GRAY);
        }
        return null;
    }

    public static boolean showWarningScreen(FusionPackMetadata metadata, boolean isVanillaCompatible, ClientResourcePackInfo pack, Consumer<Boolean> confirmation) {
        if (!isVanillaCompatible || metadata.isMinVersionSatisfied()) {
            return false;
        }
        Minecraft.func_71410_x().func_147108_a((Screen)new MinimumVersionWarningScreen(pack, confirmation));
        return true;
    }
}

