/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.core;

import com.google.common.collect.Multimap;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraftforge.fml.common.asm.transformers.AccessTransformer;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;

public class FusionAccessTransformer
extends AccessTransformer {
    private static final Function<Object, String> MODIFIER_NAME;
    private static final BiConsumer<Object, String> SET_MODIFIER_NAME;
    private static final Function<Object, String> MODIFIER_DESC;
    private static final Function<Object, Boolean> MODIFIER_MODIFY_CLASS_VISIBILITY;

    public FusionAccessTransformer() throws IOException {
        super("META-INF/fusion-accesstransformer.cfg");
        if (FMLLaunchHandler.isDeobfuscatedEnvironment()) {
            this.deobfuscateModifiers();
        }
    }

    private void deobfuscateModifiers() {
        Multimap modifiers;
        try {
            Field modifiersField = AccessTransformer.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiers = (Multimap)modifiersField.get((Object)this);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry entry : modifiers.entries()) {
            String className = ((String)entry.getKey()).replace('.', '/');
            Object modifier = entry.getValue();
            if (MODIFIER_MODIFY_CLASS_VISIBILITY.apply(modifier).booleanValue()) continue;
            String name = MODIFIER_NAME.apply(modifier);
            String desc = MODIFIER_DESC.apply(modifier);
            String remappedName = desc.isEmpty() ? FMLDeobfuscatingRemapper.INSTANCE.mapFieldName(className, name, null) : FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(className, name, desc);
            SET_MODIFIER_NAME.accept(modifier, remappedName);
        }
    }

    static {
        Class<?> modifier = AccessTransformer.class.getDeclaredClasses()[0];
        try {
            Field name = modifier.getDeclaredField("name");
            name.setAccessible(true);
            MODIFIER_NAME = o -> {
                try {
                    return (String)name.get(o);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            };
            SET_MODIFIER_NAME = (o, value) -> {
                try {
                    name.set(o, value);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            };
            Field desc = modifier.getDeclaredField("desc");
            desc.setAccessible(true);
            MODIFIER_DESC = o -> {
                try {
                    return (String)desc.get(o);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            };
            Field modifyClassVisibility = modifier.getDeclaredField("modifyClassVisibility");
            modifyClassVisibility.setAccessible(true);
            MODIFIER_MODIFY_CLASS_VISIBILITY = o -> {
                try {
                    return (Boolean)modifyClassVisibility.get(o);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

