/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.supermartijn642.fusion.extensions.ResourcePackExtension;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.FileResourcePack;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FileResourcePack.class})
public class FileResourcePackMixin
implements ResourcePackExtension {
    @Unique
    private String overridesFolder;

    @Override
    public void setFusionOverridesFolder(@Nonnull String folder) {
        this.overridesFolder = folder;
    }

    @Override
    public Collection<ResourceLocation> fusionGetResources(String folder, int maxDepth, Predicate<String> filter) {
        ZipFile zipfile;
        try {
            zipfile = this.func_110599_c();
        }
        catch (IOException e) {
            return Collections.emptySet();
        }
        HashSet<ResourceLocation> resources = new HashSet<ResourceLocation>();
        String assetsPath = "assets/";
        String overwritesAssetsPath = this.overridesFolder + assetsPath;
        Enumeration<? extends ZipEntry> entries = zipfile.entries();
        while (entries.hasMoreElements()) {
            String[] fileParts;
            String file;
            int namespaceEnd;
            String path;
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory() || entry.getName().endsWith(".mcmeta")) continue;
            if (entry.getName().startsWith(assetsPath)) {
                path = entry.getName().substring(assetsPath.length());
            } else {
                if (!entry.getName().startsWith(overwritesAssetsPath)) continue;
                path = entry.getName().substring(overwritesAssetsPath.length());
            }
            if ((namespaceEnd = path.indexOf(47)) < 0 || !(file = path.substring(namespaceEnd + 1)).startsWith(folder + "/") || (fileParts = file.substring(folder.length() + 2).split("/")).length < maxDepth + 1 || !filter.test(file)) continue;
            String namespace = path.substring(0, namespaceEnd);
            resources.add(new ResourceLocation(namespace, file));
        }
        return resources;
    }

    @Shadow
    private ZipFile func_110599_c() throws IOException {
        throw new AssertionError();
    }

    @Inject(method={"getInputStreamByName(Ljava/lang/String;)Ljava/io/InputStream;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getInputStreamByName(String path, CallbackInfoReturnable<InputStream> ci) throws IOException {
        ZipEntry zipEntry;
        ZipFile zipFile;
        if (this.overridesFolder == null) {
            return;
        }
        path = this.overridesFolder + path;
        try {
            zipFile = this.func_110599_c();
        }
        catch (Exception ignored) {
            return;
        }
        if (zipFile != null && (zipEntry = zipFile.getEntry(path)) != null) {
            ci.setReturnValue(zipFile.getInputStream(zipEntry));
        }
    }

    @Inject(method={"hasResourceName(Ljava/lang/String;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void hasResourceName(String path, CallbackInfoReturnable<Boolean> ci) {
        if (this.overridesFolder == null) {
            return;
        }
        path = this.overridesFolder + path;
        try {
            ZipFile zipFile = this.func_110599_c();
            if (zipFile != null && zipFile.getEntry(path) != null) {
                ci.setReturnValue(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Inject(method={"getResourceDomains"}, at={@At(value="RETURN")}, cancellable=true)
    private void getResourceDomains(CallbackInfoReturnable<Set<String>> ci) {
        ZipFile zipFile;
        if (this.overridesFolder == null) {
            return;
        }
        try {
            zipFile = this.func_110599_c();
        }
        catch (Exception ignored) {
            return;
        }
        if (zipFile == null) {
            return;
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        HashSet namespaces = Sets.newHashSet((Iterable)ci.getReturnValue());
        while (enumeration.hasMoreElements()) {
            ArrayList list;
            ZipEntry zipEntry = enumeration.nextElement();
            String name = zipEntry.getName();
            if (!name.startsWith(this.overridesFolder) || !(name = name.substring(this.overridesFolder.length())).startsWith("assets/") || (list = Lists.newArrayList((Iterable)FileResourcePack.field_110601_c.split((CharSequence)name))).size() <= 1) continue;
            String namespace = (String)list.get(1);
            if (namespace.equals(namespace.toLowerCase(Locale.ROOT))) {
                namespaces.add(namespace);
                continue;
            }
            FileResourcePack.field_110598_a.warn("Ignored non-lowercase namespace: {} in {}", (Object)namespace, (Object)((FileResourcePack)this).field_110597_b);
        }
        ci.setReturnValue(namespaces);
    }
}

