/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.supermartijn642.fusion.api.texture.TextureErrorException;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.extensions.TextureAtlasSpriteExtension;
import com.supermartijn642.fusion.texture.FusionTextureMetadataSection;
import com.supermartijn642.fusion.texture.SpriteCreationContextImpl;
import com.supermartijn642.fusion.texture.SpritePreparationContextImpl;
import com.supermartijn642.fusion.texture.TextureTypeRegistryImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ProgressManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={TextureMap.class}, priority=900)
public class TextureAtlasMixin {
    @Unique
    private final Map<ResourceLocation, Pair<TextureType<Object>, Object>> fusionTextureMetadata = new HashMap<ResourceLocation, Pair<TextureType<Object>, Object>>();
    @Unique
    private final ThreadLocal<IResource> textureResource = new ThreadLocal();

    @Inject(method={"loadTexture(Lnet/minecraft/client/renderer/texture/Stitcher;Lnet/minecraft/client/resources/IResourceManager;Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;Lnet/minecraftforge/fml/common/ProgressManager$ProgressBar;II)I"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/client/resources/IResourceManager;getResource(Lnet/minecraft/util/ResourceLocation;)Lnet/minecraft/client/resources/IResource;", ordinal=1, shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void captureTextureResource(Stitcher stitcher, IResourceManager resourceManager, ResourceLocation location, TextureAtlasSprite textureatlassprite, ProgressManager.ProgressBar bar, int j, int k, CallbackInfoReturnable<Integer> ci, ResourceLocation resourceLocation, IResource resource) {
        this.textureResource.set(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"loadTexture(Lnet/minecraft/client/renderer/texture/Stitcher;Lnet/minecraft/client/resources/IResourceManager;Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;Lnet/minecraftforge/fml/common/ProgressManager$ProgressBar;II)I"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;loadSprite(Lnet/minecraft/client/renderer/texture/PngSizeInfo;Z)V"))
    private void gatherMetadata(TextureAtlasSprite sprite, PngSizeInfo pngInfo, boolean hasAnimation) throws IOException {
        Pair<TextureType<Object>, Object> metadata;
        FusionTextureMetadataSection.registerMetadata();
        FusionTextureMetadataSection.Data data = (FusionTextureMetadataSection.Data)this.textureResource.get().func_110526_a(FusionTextureMetadataSection.INSTANCE.func_110483_a());
        Pair<TextureType<Object>, Object> pair = metadata = data == null ? null : data.pair;
        if (metadata != null) {
            Pair<Integer, Integer> newSize;
            ResourceLocation identifier = new ResourceLocation(sprite.func_94215_i());
            Map<ResourceLocation, Pair<TextureType<Object>, Object>> map = this.fusionTextureMetadata;
            synchronized (map) {
                this.fusionTextureMetadata.put(identifier, metadata);
            }
            AnimationMetadataSection animation = hasAnimation ? (AnimationMetadataSection)this.textureResource.get().func_110526_a("animation") : null;
            int originalWidth = pngInfo.field_188533_a;
            int originalHeight = pngInfo.field_188534_b;
            if (animation != null) {
                if (animation.field_110476_b != -1 || animation.field_110477_c != -1) {
                    originalWidth = animation.field_110476_b == -1 ? animation.field_110476_b : pngInfo.field_188533_a;
                    originalHeight = animation.field_110477_c == -1 ? animation.field_110477_c : pngInfo.field_188534_b;
                } else {
                    originalWidth = originalHeight = Math.min(pngInfo.field_188533_a, pngInfo.field_188534_b);
                }
            }
            try {
                newSize = metadata.left().getFrameSize(new SpritePreparationContextImpl(originalWidth, originalHeight, pngInfo.field_188533_a, pngInfo.field_188534_b, identifier, animation), metadata.right());
            }
            catch (TextureErrorException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Encountered an exception whilst getting frame size from texture type '" + TextureTypeRegistryImpl.getIdentifier(metadata.left()) + "' for texture '" + identifier + "'!", e);
            }
            if (newSize == null) {
                throw new RuntimeException("Received null frame size from texture type '" + TextureTypeRegistryImpl.getIdentifier(metadata.left()) + "' for texture '" + identifier + "'!");
            }
            ((TextureAtlasSpriteExtension)sprite).setTextureSize(pngInfo.field_188533_a, pngInfo.field_188534_b);
            ((TextureAtlasSpriteExtension)sprite).setFusionTextureType(metadata.left());
            pngInfo.field_188533_a = newSize.left();
            pngInfo.field_188534_b = newSize.right();
            sprite.func_188538_a(pngInfo, hasAnimation);
            sprite.field_130224_d = newSize.right();
            return;
        }
        sprite.func_188538_a(pngInfo, hasAnimation);
    }

    @ModifyVariable(method={"loadTexture(Lnet/minecraft/client/renderer/texture/Stitcher;Lnet/minecraft/client/resources/IResourceManager;Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;Lnet/minecraftforge/fml/common/ProgressManager$ProgressBar;II)I"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/texture/Stitcher;addSprite(Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;)V", shift=At.Shift.BEFORE), ordinal=0)
    private TextureAtlasSprite replaceSprite(TextureAtlasSprite texture) {
        ResourceLocation identifier = new ResourceLocation(texture.func_94215_i());
        Pair<TextureType<Object>, Object> textureData = this.fusionTextureMetadata.get(identifier);
        if (textureData != null) {
            TextureAtlasSprite newTexture;
            try (SpriteCreationContextImpl context = new SpriteCreationContextImpl(texture, (TextureMap)this);){
                newTexture = textureData.left().createSprite(context, textureData.right());
            }
            catch (Exception e) {
                throw new RuntimeException("Encountered an exception whilst initialising texture '" + identifier + "' for texture type '" + TextureTypeRegistryImpl.getIdentifier(textureData.left()) + "'!", e);
            }
            if (newTexture == null) {
                throw new RuntimeException("Received null texture from texture type '" + TextureTypeRegistryImpl.getIdentifier(textureData.left()) + "' for texture '" + identifier + "'!");
            }
            ((TextureAtlasSpriteExtension)newTexture).setFusionTextureType(textureData.left());
            return newTexture;
        }
        return texture;
    }

    @Inject(method={"loadSprites(Lnet/minecraft/client/resources/IResourceManager;Lnet/minecraft/client/renderer/texture/ITextureMapPopulator;)V"}, at={@At(value="RETURN")})
    private void clearTextureData(CallbackInfo ci) {
        this.fusionTextureMetadata.clear();
    }
}

