/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.supermartijn642.fusion.api.texture.DefaultTextureTypes;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.extensions.TextureAtlasSpriteExtension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.data.AnimationFrame;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TextureAtlasSprite.class})
public class TextureAtlasSpriteMixin
implements TextureAtlasSpriteExtension {
    @Shadow
    private List<int[][]> field_110976_a;
    @Shadow
    private AnimationMetadataSection field_110982_k;
    @Shadow
    private int field_130223_c;
    @Shadow
    private int field_130224_d;
    @Unique
    private TextureType<?> fusionType;
    @Unique
    private int textureWidth;
    @Unique
    private int textureHeight;

    @Shadow
    private static int[][] func_147962_a(int[][] pixels, int width, int height, int level) {
        return null;
    }

    @Override
    public void setFusionTextureType(TextureType<?> type) {
        this.fusionType = type;
    }

    @Override
    public TextureType<?> getFusionTextureType() {
        return this.fusionType;
    }

    @Override
    public void setTextureSize(int width, int height) {
        this.textureWidth = width;
        this.textureHeight = height;
    }

    @Override
    public Pair<Integer, Integer> getTextureSize() {
        return Pair.of(this.textureWidth, this.textureHeight);
    }

    @Inject(method={"loadSprite"}, at={@At(value="INVOKE", target="Ljava/lang/RuntimeException;<init>(Ljava/lang/String;)V", shift=At.Shift.BEFORE)}, cancellable=true)
    private void loadSprite(PngSizeInfo sizeInfo, boolean hasAnimation, CallbackInfo ci) {
        if (this.fusionType != null) {
            ci.cancel();
        }
    }

    @Inject(method={"loadSpriteFrames"}, at={@At(value="HEAD")}, cancellable=true)
    public void loadSpriteFrames(IResource resource, int mipmapLevels, CallbackInfo ci) throws IOException {
        if (this.fusionType == null || this.fusionType == DefaultTextureTypes.VANILLA) {
            return;
        }
        ci.cancel();
        BufferedImage bufferedimage = TextureUtil.func_177053_a((InputStream)resource.func_110527_b());
        AnimationMetadataSection animation = (AnimationMetadataSection)resource.func_110526_a("animation");
        int[][] pixelsPerLevel = new int[mipmapLevels][];
        pixelsPerLevel[0] = new int[bufferedimage.getWidth() * bufferedimage.getHeight()];
        bufferedimage.getRGB(0, 0, bufferedimage.getWidth(), bufferedimage.getHeight(), pixelsPerLevel[0], 0, bufferedimage.getWidth());
        if (animation == null) {
            this.field_110976_a.add(pixelsPerLevel);
            return;
        }
        int frames = bufferedimage.getHeight() / this.field_130224_d;
        if (animation.func_110473_c() > 0) {
            for (Integer index : animation.func_130073_e()) {
                if (index >= frames) {
                    throw new RuntimeException("invalid frameindex " + index);
                }
                while (this.field_110976_a.size() <= index) {
                    this.field_110976_a.add(null);
                }
                this.field_110976_a.set(index, TextureAtlasSpriteMixin.func_147962_a(pixelsPerLevel, this.field_130223_c, this.field_130224_d, index));
            }
            this.field_110982_k = animation;
        } else {
            ArrayList<AnimationFrame> list = new ArrayList<AnimationFrame>();
            for (int index = 0; index < frames; ++index) {
                this.field_110976_a.add(TextureAtlasSpriteMixin.func_147962_a(pixelsPerLevel, this.field_130223_c, this.field_130224_d, index));
                list.add(new AnimationFrame(index, -1));
            }
            this.field_110982_k = new AnimationMetadataSection(list, this.field_130223_c, this.field_130224_d, animation.func_110469_d(), animation.func_177219_e());
        }
    }
}

