/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model;

import com.supermartijn642.fusion.api.model.ModelBakingContext;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.api.model.SpriteIdentifier;
import com.supermartijn642.fusion.model.FusionBlockModel;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;

public class ModelBakingContextImpl
implements ModelBakingContext {
    private final Function<ResourceLocation, TextureAtlasSprite> spriteGetter;
    private final IModelState modelState;
    private final ResourceLocation modelIdentifier;

    public ModelBakingContextImpl(Function<ResourceLocation, TextureAtlasSprite> spriteGetter, IModelState modelState, ResourceLocation modelIdentifier) {
        this.spriteGetter = spriteGetter;
        this.modelState = modelState;
        this.modelIdentifier = modelIdentifier;
    }

    @Override
    public TextureAtlasSprite getTexture(SpriteIdentifier identifier) {
        return this.spriteGetter.apply(identifier.getTexture());
    }

    @Override
    public TextureAtlasSprite getTexture(ResourceLocation atlas, ResourceLocation texture) {
        return this.spriteGetter.apply(texture);
    }

    @Override
    public IModelState getTransformation() {
        return this.modelState;
    }

    @Override
    public ResourceLocation getModelIdentifier() {
        return this.modelIdentifier;
    }

    @Override
    public ModelInstance<?> getModel(ResourceLocation identifier) {
        return FusionBlockModel.getModelInstance(identifier);
    }
}

