/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.modifiers.block;

import com.google.common.collect.ImmutableMap;
import com.supermartijn642.fusion.model.MutableQuad;
import com.supermartijn642.fusion.model.WrappedBakedModel;
import com.supermartijn642.fusion.model.types.connecting.ConnectingBakedModel;
import com.supermartijn642.fusion.model.types.connecting.SurroundingBlockCache;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockPane;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.EnumFacing;

public class PaneCullingBakedModel
extends WrappedBakedModel {
    private static final PropertyBool[] SIDE_PROPERTIES = new PropertyBool[]{null, null, BlockPane.field_176241_b, BlockPane.field_176243_N, BlockPane.field_176244_O, BlockPane.field_176242_M};
    private final MutableQuad helperMutableQuad = new MutableQuad();

    public PaneCullingBakedModel(IBakedModel original) {
        super(original);
    }

    @Override
    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing cullDirection, long seed) {
        IBlockState stateBelow;
        if (state == null) {
            return super.func_188616_a(null, cullDirection, seed);
        }
        ImmutableMap properties = state.func_177228_b();
        if (!(properties.containsKey((Object)BlockPane.field_176241_b) || properties.containsKey((Object)BlockPane.field_176243_N) || properties.containsKey((Object)BlockPane.field_176244_O) || properties.containsKey((Object)BlockPane.field_176242_M))) {
            return super.func_188616_a(state, cullDirection, seed);
        }
        SurroundingBlockCache surroundingBlockCache = ConnectingBakedModel.BLOCK_CACHE.get();
        if (surroundingBlockCache == null) {
            return super.func_188616_a(state, cullDirection, seed);
        }
        IBlockState stateAbove = surroundingBlockCache.getState(0, 1, 0);
        if (stateAbove.func_177230_c() != state.func_177230_c()) {
            stateAbove = null;
        }
        if ((stateBelow = surroundingBlockCache.getState(0, -1, 0)).func_177230_c() != state.func_177230_c()) {
            stateBelow = null;
        }
        if (stateAbove == null && stateBelow == null) {
            return super.func_188616_a(state, cullDirection, seed);
        }
        List<BakedQuad> quads = super.func_188616_a(state, cullDirection, seed);
        ArrayList<BakedQuad> culledQuads = new ArrayList<BakedQuad>(quads.size());
        for (BakedQuad quad : quads) {
            if (!this.filterQuad(quad, stateAbove, stateBelow)) continue;
            culledQuads.add(quad);
        }
        return culledQuads;
    }

    private boolean filterQuad(BakedQuad bakedQuad, IBlockState stateAbove, IBlockState stateBelow) {
        EnumFacing quadDirection = bakedQuad.func_178210_d();
        if (quadDirection != EnumFacing.UP && quadDirection != EnumFacing.DOWN) {
            return true;
        }
        MutableQuad quad = this.helperMutableQuad;
        quad.fillFromBakedQuad(bakedQuad);
        float centerX = (quad.x(0) + quad.x(1) + quad.x(2) + quad.x(3)) / 4.0f;
        float centerZ = (quad.z(0) + quad.z(1) + quad.z(2) + quad.z(3)) / 4.0f;
        double quadDistance = Math.sqrt(((double)centerX - 0.5) * ((double)centerX - 0.5) + ((double)centerZ - 0.5) * ((double)centerZ - 0.5));
        if (quadDistance < 0.1) {
            return quadDirection == EnumFacing.UP ? stateAbove == null : stateBelow == null;
        }
        EnumFacing partSide = EnumFacing.func_176737_a((float)(centerX - 0.5f), (float)0.0f, (float)(centerZ - 0.5f));
        return quadDirection == EnumFacing.UP ? stateAbove == null || !((Boolean)stateAbove.func_177229_b((IProperty)SIDE_PROPERTIES[partSide.ordinal()])).booleanValue() : stateBelow == null || (Boolean)stateBelow.func_177229_b((IProperty)SIDE_PROPERTIES[partSide.ordinal()]) == false;
    }
}

