/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.modifiers.item.predicates;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.model.modifier.item.ItemPredicate;
import com.supermartijn642.fusion.api.util.Serializer;
import com.supermartijn642.fusion.util.IdentifierUtil;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EnchantmentItemPredicate
implements ItemPredicate {
    public static final Serializer<EnchantmentItemPredicate> SERIALIZER = new Serializer<EnchantmentItemPredicate>(){

        @Override
        public EnchantmentItemPredicate deserialize(JsonObject json) throws JsonParseException {
            int minLevel;
            if (!(json.has("enchantment") && json.get("enchantment").isJsonPrimitive() && json.getAsJsonPrimitive("enchantment").isString())) {
                throw new JsonParseException("Item-predicate must have string property 'enchantment'!");
            }
            if (!IdentifierUtil.isValidIdentifier(json.get("enchantment").getAsString())) {
                throw new JsonParseException("Property 'enchantment' must be a valid identifier, not '" + json.get("enchantment").getAsString() + "'!");
            }
            ResourceLocation enchantmentIdentifier = new ResourceLocation(json.get("enchantment").getAsString());
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(enchantmentIdentifier);
            if (enchantment == null) {
                throw new JsonParseException("Unknown enchantment '" + enchantmentIdentifier + "'!");
            }
            int enchantmentId = Enchantment.func_185258_b((Enchantment)enchantment);
            int maxLevel = 255;
            if (json.has("max_level")) {
                if (!json.get("max_level").isJsonPrimitive() || !json.getAsJsonPrimitive("max_level").isNumber()) {
                    throw new JsonParseException("Property 'max_level' must be a number!");
                }
                maxLevel = json.getAsJsonPrimitive("max_level").getAsInt();
                if (maxLevel < 0 || maxLevel > 255) {
                    throw new JsonParseException("Property 'max_level' must be between 0 and 255!");
                }
            }
            int n = minLevel = maxLevel == 0 ? 0 : 1;
            if (json.has("min_level")) {
                if (!json.get("min_level").isJsonPrimitive() || !json.getAsJsonPrimitive("min_level").isNumber()) {
                    throw new JsonParseException("Property 'min_level' must be a number!");
                }
                minLevel = json.getAsJsonPrimitive("min_level").getAsInt();
                if (minLevel < 0 || minLevel > 255) {
                    throw new JsonParseException("Property 'min_level' must be between 0 and 255!");
                }
            }
            if (minLevel > maxLevel) {
                throw new JsonParseException("Property 'min_level' must be less than or equal to 'max_level'!");
            }
            return new EnchantmentItemPredicate(enchantmentId, minLevel, maxLevel);
        }

        @Override
        public JsonObject serialize(EnchantmentItemPredicate value) {
            JsonObject json = new JsonObject();
            json.addProperty("enchantment", ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)Enchantment.func_185262_c((int)value.enchantment)).toString());
            if (value.maxLevel != 0 && value.minLevel != 1) {
                json.addProperty("min_level", (Number)value.minLevel);
            }
            if (value.maxLevel != 255) {
                json.addProperty("max_level", (Number)value.maxLevel);
            }
            return json;
        }
    };
    private final int enchantment;
    private final int minLevel;
    private final int maxLevel;

    public EnchantmentItemPredicate(int enchantment, int minLevel, int maxLevel) {
        if (Enchantment.func_185262_c((int)enchantment) == null) {
            throw new IllegalArgumentException("No enchantment with id '" + enchantment + "'!");
        }
        if (minLevel < 0 || minLevel > 255) {
            throw new IllegalArgumentException("Min level must be between 0 and 255!");
        }
        if (maxLevel < 0 || maxLevel > 255) {
            throw new IllegalArgumentException("Max level must be between 0 and 255!");
        }
        if (minLevel > maxLevel) {
            throw new IllegalArgumentException("Minimum level must be less than or equal to maximum level!");
        }
        this.enchantment = enchantment;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
    }

    @Override
    public boolean test(ItemStack stack) {
        NBTTagList enchantmentsTag;
        if (!stack.func_77942_o()) {
            return this.minLevel == 0;
        }
        NBTTagList nBTTagList = enchantmentsTag = stack.func_77973_b() == Items.field_151134_bR ? ItemEnchantedBook.func_92110_g((ItemStack)stack) : stack.func_77986_q();
        if (!enchantmentsTag.func_82582_d()) {
            for (int i = 0; i < enchantmentsTag.func_74745_c(); ++i) {
                NBTTagCompound tag = enchantmentsTag.func_150305_b(i);
                int level = MathHelper.func_76125_a((int)tag.func_74765_d("lvl"), (int)0, (int)255);
                if (level < this.minLevel || level > this.maxLevel || this.enchantment != tag.func_74765_d("id")) continue;
                return true;
            }
        }
        return this.minLevel == 0;
    }

    @Override
    public Serializer<? extends ItemPredicate> getSerializer() {
        return SERIALIZER;
    }
}

