/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.base;

import com.google.common.collect.ImmutableList;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.texture.DefaultTextureTypes;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.model.MutableQuad;
import com.supermartijn642.fusion.model.types.base.BaseModelQuad;
import com.supermartijn642.fusion.model.types.base.CustomRenderTypeBakedModel;
import com.supermartijn642.fusion.model.types.connecting.ConnectingBakedModel;
import com.supermartijn642.fusion.model.types.connecting.SurroundingBlockCache;
import com.supermartijn642.fusion.texture.types.continuous.ContinuousTextureSprite;
import com.supermartijn642.fusion.texture.types.continuous.ContinuousTextureType;
import com.supermartijn642.fusion.texture.types.random.RandomTextureSprite;
import com.supermartijn642.fusion.texture.types.random.RandomTextureType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.MinecraftForgeClient;

public class BaseBakedModel
implements IBakedModel,
CustomRenderTypeBakedModel {
    private final List<TaggedBakedQuad>[] completeBlockMesh;
    private final List<TaggedBakedQuad>[][] blockMesh;
    private final List<BakedQuad> itemMesh;
    private final List<BlockRenderLayer> blockRenderTypes;
    private final boolean shouldCheckOriginalBlockRenderTypes;
    private final List<TextureAtlasSprite> sprites;
    private final boolean hasSpecialQuads;
    private final boolean hasAmbientOcclusion;
    private final boolean isGui3d;
    private final TextureAtlasSprite particleIcon;
    private final ItemCameraTransforms transforms;
    private final ItemOverrideList overrides;

    public BaseBakedModel(List<BaseModelQuad> quads, boolean hasAmbientOcclusion, boolean isGui3d, TextureAtlasSprite particleIcon, ItemCameraTransforms transforms, ItemOverrideList overrides) {
        this.hasAmbientOcclusion = hasAmbientOcclusion;
        this.isGui3d = isGui3d;
        this.particleIcon = particleIcon;
        this.transforms = transforms;
        this.overrides = overrides;
        List[][] blockMesh = new List[BlockRenderLayer.values().length + 1][];
        HashSet<BlockRenderLayer> blockRenderTypes = new HashSet<BlockRenderLayer>();
        ArrayList<BakedQuad> itemMesh = new ArrayList<BakedQuad>();
        HashMap<TextureAtlasSprite, Integer> sprites = new HashMap<TextureAtlasSprite, Integer>();
        boolean hasSpecialQuads = false;
        MutableQuad mutableQuad = new MutableQuad();
        for (BaseModelQuad quad : quads) {
            mutableQuad.fillFromBakedQuad(quad.bakedQuad());
            mutableQuad.emissive(quad.emissive());
            if (quad.lightEmission() != null) {
                for (int i = 0; i < 4; ++i) {
                    int sky = Math.max(quad.lightEmission(), mutableQuad.lightmap(i) >> 20 & 0xFFFF);
                    int block = Math.max(quad.lightEmission(), (mutableQuad.lightmap(i) & 0xFFFF) >> 4);
                    mutableQuad.lightmap(i, sky << 20 | block << 4);
                }
            }
            int spriteIndex = -1;
            if (quad.textureType() == DefaultTextureTypes.RANDOM || quad.textureType() == DefaultTextureTypes.CONTINUOUS) {
                spriteIndex = sprites.computeIfAbsent(quad.bakedQuad().func_187508_a(), o -> sprites.size());
                hasSpecialQuads = true;
            }
            TaggedBakedQuad finishedQuad = new TaggedBakedQuad(mutableQuad.toBakedQuad(), quad.textureType(), spriteIndex);
            BlockRenderLayer renderType = FusionClient.getRenderTypeMaterial(quad.renderType());
            blockRenderTypes.add(renderType);
            int cullIndex = BaseBakedModel.cullIndex(quad.cullDirection());
            List[] mesh = blockMesh[renderType == null ? 0 : renderType.ordinal() + 1];
            if (mesh == null) {
                mesh = new List[7];
                blockMesh[renderType == null ? 0 : renderType.ordinal() + 1] = mesh;
            }
            if (mesh[cullIndex] == null) {
                mesh[cullIndex] = new ArrayList();
            }
            mesh[cullIndex].add(finishedQuad);
            itemMesh.add(mutableQuad.toBakedQuad());
        }
        this.blockMesh = blockMesh;
        this.blockRenderTypes = blockRenderTypes.stream().filter(Objects::nonNull).collect(Collectors.toList());
        this.shouldCheckOriginalBlockRenderTypes = blockRenderTypes.contains(null);
        this.itemMesh = ImmutableList.copyOf(itemMesh);
        this.sprites = sprites.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).collect(Collectors.toList());
        this.hasSpecialQuads = hasSpecialQuads;
        this.completeBlockMesh = new List[7];
        for (int i = 0; i < 7; ++i) {
            int cullIndex = i;
            this.completeBlockMesh[i] = Arrays.stream(this.blockMesh).filter(Objects::nonNull).map(arr -> arr[cullIndex]).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        }
    }

    public List<BakedQuad> getQuads(@Nullable IBlockState state, @Nullable EnumFacing cullDirection, long seed, @Nullable BlockRenderLayer renderType) {
        ArrayList<TaggedBakedQuad> quads;
        if (state == null) {
            return cullDirection == null ? this.itemMesh : Collections.emptyList();
        }
        if (renderType == null) {
            quads = this.completeBlockMesh[BaseBakedModel.cullIndex(cullDirection)];
        } else {
            List<TaggedBakedQuad>[] mesh = this.blockMesh[renderType.ordinal() + 1];
            List<TaggedBakedQuad> list = quads = mesh == null ? null : mesh[BaseBakedModel.cullIndex(cullDirection)];
            if (this.shouldCheckOriginalBlockRenderTypes && state.func_177230_c().func_180664_k() == renderType) {
                Iterator<TaggedBakedQuad> additionalQuads;
                mesh = this.blockMesh[0];
                Iterator<TaggedBakedQuad> iterator = additionalQuads = mesh == null ? null : mesh[BaseBakedModel.cullIndex(cullDirection)];
                if (additionalQuads != null) {
                    if (quads == null) {
                        quads = additionalQuads;
                    } else {
                        ArrayList<TaggedBakedQuad> arrayList = new ArrayList<TaggedBakedQuad>(quads.size() + additionalQuads.size());
                        arrayList.addAll(quads);
                        arrayList.addAll((Collection<TaggedBakedQuad>)((Object)additionalQuads));
                        quads = arrayList;
                    }
                }
            }
            if (quads == null) {
                quads = Collections.emptyList();
            }
        }
        if (!this.hasSpecialQuads) {
            ArrayList<BakedQuad> bakedQuads = new ArrayList<BakedQuad>(quads.size());
            for (TaggedBakedQuad taggedBakedQuad : quads) {
                bakedQuads.add(taggedBakedQuad.bakedQuad);
            }
            return bakedQuads;
        }
        SurroundingBlockCache blockCache = ConnectingBakedModel.BLOCK_CACHE.get();
        if (blockCache == null) {
            ArrayList<BakedQuad> bakedQuads = new ArrayList<BakedQuad>(quads.size());
            for (TaggedBakedQuad quad : quads) {
                bakedQuads.add(quad.bakedQuad);
            }
            return bakedQuads;
        }
        BlockPos pos = blockCache.getRealPos();
        ArrayList<BakedQuad> arrayList = new ArrayList<BakedQuad>(quads.size());
        Random random = null;
        MutableQuad mutableQuad = new MutableQuad();
        for (TaggedBakedQuad quad : quads) {
            if (quad.textureType == DefaultTextureTypes.RANDOM || quad.textureType == DefaultTextureTypes.CONTINUOUS) {
                TextureAtlasSprite sprite = this.sprites.get(quad.spriteIndex);
                mutableQuad.fillFromBakedQuad(quad.bakedQuad);
                if (quad.textureType == DefaultTextureTypes.RANDOM) {
                    if (random == null) {
                        random = new Random();
                    }
                    RandomTextureType.processQuad(mutableQuad, pos, quad.bakedQuad.func_178210_d(), random, (RandomTextureSprite)sprite);
                } else {
                    ContinuousTextureType.processQuad(mutableQuad, pos, quad.bakedQuad.func_178210_d(), (ContinuousTextureSprite)sprite);
                }
                arrayList.add(mutableQuad.toBakedQuad());
                continue;
            }
            arrayList.add(quad.bakedQuad);
        }
        return arrayList;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing cullDirection, long seed) {
        return this.getQuads(state, cullDirection, seed, MinecraftForgeClient.getRenderLayer());
    }

    public List<BlockRenderLayer> getBlockRenderTypes() {
        return this.blockRenderTypes;
    }

    public boolean func_177555_b() {
        return this.hasAmbientOcclusion;
    }

    public boolean func_177556_c() {
        return this.isGui3d;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.particleIcon;
    }

    public ItemCameraTransforms func_177552_f() {
        return this.transforms;
    }

    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    private static int cullIndex(EnumFacing cullDirection) {
        return cullDirection == null ? 0 : cullDirection.ordinal() + 1;
    }

    private static class TaggedBakedQuad {
        final BakedQuad bakedQuad;
        final TextureType<?> textureType;
        final int spriteIndex;

        private TaggedBakedQuad(BakedQuad bakedQuad, TextureType<?> textureType, int spriteIndex) {
            this.bakedQuad = bakedQuad;
            this.textureType = textureType;
            this.spriteIndex = spriteIndex;
        }
    }
}

