/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.texture.types.connecting.layouts;

import com.supermartijn642.fusion.api.texture.data.ConnectingTextureLayout;
import com.supermartijn642.fusion.model.MutableQuad;
import com.supermartijn642.fusion.texture.types.connecting.ConnectingTextureSprite;
import com.supermartijn642.fusion.texture.types.connecting.TextureConnections;
import com.supermartijn642.fusion.texture.types.connecting.layouts.CompactLayoutHandler;
import com.supermartijn642.fusion.texture.types.connecting.layouts.FullLayoutHandler;
import com.supermartijn642.fusion.texture.types.connecting.layouts.HorizontalLayoutHandler;
import com.supermartijn642.fusion.texture.types.connecting.layouts.OverlayLayoutHandler;
import com.supermartijn642.fusion.texture.types.connecting.layouts.PiecedLayoutHandler;
import com.supermartijn642.fusion.texture.types.connecting.layouts.SimpleLayoutHandler;
import com.supermartijn642.fusion.texture.types.connecting.layouts.VerticalLayoutHandler;

public abstract class ConnectingTextureLayoutHandler {
    private static ConnectingTextureLayoutHandler[] HANDLERS;
    protected final int width;
    protected final int height;
    protected final int defaultTileX;
    protected final int defaultTileY;
    protected final int auxiliaryQuadCount;

    public static ConnectingTextureLayoutHandler get(ConnectingTextureLayout layout) {
        if (HANDLERS == null && (HANDLERS = new ConnectingTextureLayoutHandler[]{new FullLayoutHandler(), new HorizontalLayoutHandler(), new SimpleLayoutHandler(), new VerticalLayoutHandler(), new CompactLayoutHandler(), new PiecedLayoutHandler(), new OverlayLayoutHandler()}).length != ConnectingTextureLayout.values().length) {
            throw new AssertionError((Object)"Missing connecting texture layout handlers!");
        }
        return HANDLERS[layout.ordinal()];
    }

    public ConnectingTextureLayoutHandler(int width, int height, int defaultTileX, int defaultTileY, int auxiliaryQuadCount) {
        if (auxiliaryQuadCount > 15) {
            throw new IllegalArgumentException("Invalid auxiliary quad count: " + auxiliaryQuadCount);
        }
        this.width = width;
        this.height = height;
        this.defaultTileX = defaultTileX;
        this.defaultTileY = defaultTileY;
        this.auxiliaryQuadCount = auxiliaryQuadCount;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getAuxiliaryQuadCount() {
        return this.auxiliaryQuadCount;
    }

    public int defaultTileX() {
        return this.defaultTileX;
    }

    public int defaultTileY() {
        return this.defaultTileY;
    }

    public abstract boolean processBlockQuad(int var1, MutableQuad var2, ConnectingTextureSprite var3, TextureConnections var4);

    public abstract boolean processItemQuad(int var1, MutableQuad var2, ConnectingTextureSprite var3);

    public static abstract class SimpleHandler
    extends ConnectingTextureLayoutHandler {
        private final int[][] uvs;

        public SimpleHandler(int width, int height, int maxIndexSize) {
            super(width, height, 0, 0, 0);
            this.uvs = new int[(int)Math.pow(2.0, maxIndexSize)][];
            for (TextureConnections connections : TextureConnections.iterateAll()) {
                int i = this.connectionsIndex(connections);
                if (this.uvs[i] != null) continue;
                this.uvs[i] = this.getTilePos(connections);
            }
        }

        protected abstract int connectionsIndex(TextureConnections var1);

        protected abstract int[] getTilePos(TextureConnections var1);

        @Override
        public boolean processBlockQuad(int quadIndex, MutableQuad quad, ConnectingTextureSprite sprite, TextureConnections connections) {
            int[] tile = this.uvs[this.connectionsIndex(connections)];
            if (sprite.field_130222_e) {
                SimpleHandler.adjustQuadUV(quad, tile[1], tile[0], sprite);
            } else {
                SimpleHandler.adjustQuadUV(quad, tile[0], tile[1], sprite);
            }
            return true;
        }

        @Override
        public boolean processItemQuad(int quadIndex, MutableQuad quad, ConnectingTextureSprite sprite) {
            return true;
        }

        private static void adjustQuadUV(MutableQuad quad, int tileU, int tileV, ConnectingTextureSprite sprite) {
            for (int i = 0; i < 4; ++i) {
                float width = sprite.func_94212_f() - sprite.func_94209_e();
                float u = sprite.getStartU() + quad.u(i) - sprite.func_94209_e() + width * (float)tileU;
                float height = sprite.func_94210_h() - sprite.func_94206_g();
                float v = sprite.getStartV() + quad.v(i) - sprite.func_94206_g() + height * (float)tileV;
                quad.uv(i, u, v);
            }
        }
    }
}

