/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.api.provider;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.fusion.api.util.Pair;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7403;

public abstract class FusionBlockModelModifierProvider
implements class_2405 {
    private final Map<class_2960, ModifierBuilder> modifiers = new HashMap<class_2960, ModifierBuilder>();
    private final String modName;
    private final class_2403 generator;

    public FusionBlockModelModifierProvider(String modid, class_2403 generator) {
        this.modName = FabricLoader.getInstance().getModContainer(modid).map(ModContainer::getMetadata).map(ModMetadata::getName).orElse(modid);
        this.generator = generator;
    }

    public final void method_10319(class_7403 cache) throws IOException {
        this.generate();
        Path output = this.generator.method_10313();
        for (Map.Entry<class_2960, ModifierBuilder> entry : this.modifiers.entrySet()) {
            class_2960 location = entry.getKey();
            JsonObject json = this.toJson(entry.getValue());
            String extension = location.method_12832().endsWith(".json") ? "" : ".json";
            Path path = Path.of("assets", location.method_12836(), "fusion/model_modifiers/blocks", location.method_12832() + extension);
            class_2405.method_10320((class_7403)cache, (JsonElement)json, (Path)output.resolve(path));
        }
    }

    private JsonObject toJson(ModifierBuilder modifier) {
        JsonObject json = new JsonObject();
        if (modifier.targets.isEmpty()) {
            throw new IllegalArgumentException("Modifier '" + String.valueOf(modifier.location) + "' must have at least one target!");
        }
        JsonArray targets = new JsonArray();
        modifier.targets.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            class_2960 block = (class_2960)entry.getKey();
            Map properties = (Map)entry.getValue();
            if (properties.isEmpty()) {
                targets.add(block.toString());
                return;
            }
            JsonObject object = new JsonObject();
            object.addProperty("block", block.toString());
            JsonObject propertiesJson = new JsonObject();
            properties.entrySet().stream().sorted(Comparator.comparing(e -> ((class_2769)e.getKey()).method_11899())).forEach(e -> {
                class_2769 property = (class_2769)e.getKey();
                JsonArray values = new JsonArray();
                ((Set)e.getValue()).stream().map(v -> property.method_11901((Comparable)v)).sorted().forEach(arg_0 -> ((JsonArray)values).add(arg_0));
                propertiesJson.add(property.method_11899(), (JsonElement)values);
            });
            object.add("properties", (JsonElement)propertiesJson);
            targets.add((JsonElement)object);
        });
        json.add("targets", (JsonElement)targets);
        if (!modifier.appendModels.isEmpty() || !modifier.paneCullingFix) {
            JsonArray appendModels = new JsonArray();
            modifier.appendModels.stream().map(class_2960::toString).sorted().forEach(arg_0 -> ((JsonArray)appendModels).add(arg_0));
            json.add("append", (JsonElement)appendModels);
        }
        if (modifier.paneCullingFix) {
            json.addProperty("pane_culling_fix", Boolean.valueOf(true));
        }
        return json;
    }

    protected abstract void generate();

    public final ModifierBuilder modifier(class_2960 location) {
        return this.modifiers.computeIfAbsent(location, ModifierBuilder::new);
    }

    public String method_10321() {
        return "Fusion Block Model Modifier Provider: " + this.modName;
    }

    public static final class ModifierBuilder {
        private final class_2960 location;
        private final Map<class_2960, Map<class_2769<?>, Set<Object>>> targets = new HashMap();
        private final Set<class_2960> appendModels = new HashSet<class_2960>();
        private boolean paneCullingFix = false;

        private ModifierBuilder(class_2960 location) {
            this.location = location;
        }

        public ModifierBuilder target(class_2960 block) {
            if (!this.targets.containsKey(block)) {
                this.targets.put(block, new HashMap());
            }
            return this;
        }

        public ModifierBuilder target(class_2248 block) {
            return this.target(class_2378.field_11146.method_10221((Object)block));
        }

        public ModifierBuilder target(class_2248 block, Map<class_2769<?>, Set<?>> properties) {
            class_2960 identifier = class_2378.field_11146.method_10221((Object)block);
            Map map = this.targets.computeIfAbsent(identifier, o -> new HashMap());
            for (Map.Entry<class_2769<?>, Set<?>> entry : properties.entrySet()) {
                class_2769<?> property = entry.getKey();
                Set values = map.computeIfAbsent(property, o -> new HashSet());
                for (Object value : entry.getValue()) {
                    if (!property.method_11898().contains(value)) {
                        throw new IllegalStateException("Value '" + String.valueOf(value) + "' is not a valid value for property '" + property.method_11899() + "'!");
                    }
                    values.add(value);
                }
            }
            return this;
        }

        public <T extends Comparable<T>> ModifierBuilder target(class_2248 block, class_2769<T> property, T ... values) {
            return this.target(block, new HashMap(Map.of(property, new HashSet<T>(Set.of(values)))));
        }

        public ModifierBuilder target(class_2680 state) {
            return this.target(state.method_26204(), state.method_28501().stream().sorted(Comparator.comparing(class_2769::method_11899)).map(property -> Pair.of(property, Set.of(state.method_11654(property)))).collect(Collectors.toMap(Pair::left, Pair::right, (a, b) -> {
                throw new AssertionError();
            }, HashMap::new)));
        }

        public ModifierBuilder appendModel(class_2960 location) {
            this.appendModels.add(location);
            return this;
        }

        public ModifierBuilder paneCullingFix(boolean enabled) {
            this.paneCullingFix = enabled;
            return this;
        }
    }
}

