/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.api.provider;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.fusion.api.texture.FusionTextureTypeRegistry;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.util.Pair;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7403;

public abstract class FusionTextureMetadataProvider
implements class_2405 {
    private final Map<class_2960, Pair<TextureType<Object>, Object>> metadata = new HashMap<class_2960, Pair<TextureType<Object>, Object>>();
    private final String modName;
    private final class_2403 generator;

    public FusionTextureMetadataProvider(String modid, class_2403 generator) {
        this.modName = FabricLoader.getInstance().getModContainer(modid).map(ModContainer::getMetadata).map(ModMetadata::getName).orElse(modid);
        this.generator = generator;
    }

    public final void method_10319(class_7403 cache) throws IOException {
        this.generate();
        Path output = this.generator.method_10313();
        for (Map.Entry<class_2960, Pair<TextureType<Object>, Object>> entry : this.metadata.entrySet()) {
            class_2960 location = entry.getKey();
            Pair<TextureType<Object>, Object> metadata = entry.getValue();
            String extension = location.method_12832().endsWith(".mcmeta") ? "" : (location.method_12832().lastIndexOf(46) > location.method_12832().lastIndexOf(47) ? ".mcmeta" : ".png.mcmeta");
            Path path = Path.of("assets", location.method_12836(), "textures", location.method_12832() + extension);
            JsonObject json = new JsonObject();
            json.add("fusion", (JsonElement)FusionTextureTypeRegistry.serializeTextureData(metadata.left(), metadata.right()));
            class_2405.method_10320((class_7403)cache, (JsonElement)json, (Path)output.resolve(path));
        }
    }

    protected abstract void generate();

    public final <T> void addTextureMetadata(class_2960 location, TextureType<T> textureType, T data) {
        Pair<TextureType<T>, T> previousValue = this.metadata.put(location, Pair.of(textureType, data));
        if (previousValue != null) {
            throw new RuntimeException("Duplicate texture metadata for '" + String.valueOf(location) + "'!");
        }
    }

    public String method_10321() {
        return "Fusion Texture Metadata Provider: " + this.modName;
    }
}

