/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.entity;

import com.google.common.collect.ImmutableMap;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.util.Either;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.entity.EntityModelModifier;
import com.supermartijn642.fusion.entity.EntityModelModifierReloadListener;
import com.supermartijn642.fusion.entity.VanillaModelLayerProperties;
import com.supermartijn642.fusion.entity.model.EntityLayerProperties;
import com.supermartijn642.fusion.entity.model.FusionModelPart;
import com.supermartijn642.fusion.entity.model.ModelTransformer;
import com.supermartijn642.fusion.entity.model.loader.FusionEntityModelLoader;
import com.supermartijn642.fusion.entity.model.predicates.EntityModelPredicate;
import com.supermartijn642.fusion.extensions.EntityRendererExtension;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5601;
import net.minecraft.class_5607;
import net.minecraft.class_5617;
import net.minecraft.class_630;
import net.minecraft.class_897;

public class EntityModelModifierManager {
    private static final ThreadLocal<Boolean> trackingBakedModels = ThreadLocal.withInitial(() -> false);
    private static final Set<class_5601> currentModifierLayers = new HashSet<class_5601>();
    private static final Map<class_5601, FusionModelPart> overwrittenModelParts = new HashMap<class_5601, FusionModelPart>();
    private static int currentLayerIndex = 0;
    private static final Map<class_1299<?>, EntityModelModifier> MODEL_PROPERTIES = new HashMap();
    public static int reloadCounter = 0;

    public static void bakeModels(Map<class_5601, class_5607> originalModels) {
        MODEL_PROPERTIES.clear();
        ++reloadCounter;
        HashMap<class_2960, Supplier<class_630>> vanillaModels = new HashMap<class_2960, Supplier<class_630>>();
        originalModels.forEach((layer, layerDefinition) -> vanillaModels.put(FusionEntityModelLoader.locationForLayer(layer), () -> ((class_5607)layerDefinition).method_32109()));
        Map<class_1299<?>, EntityModelModifierReloadListener.Modifier> modifiers = EntityModelModifierReloadListener.getModifiers();
        for (Map.Entry<class_1299<?>, EntityModelModifierReloadListener.Modifier> entry : modifiers.entrySet()) {
            class_1299<?> entity = entry.getKey();
            EntityModelModifierReloadListener.Modifier modifier = entry.getValue();
            ImmutableMap.Builder layers = ImmutableMap.builder();
            for (Map.Entry<class_5601, EntityModelModifierReloadListener.Layer> layerEntry : modifier.layers.entrySet()) {
                List<EntityLayerProperties.ModelOption> defaultModels;
                class_5601 layerIdentifier = layerEntry.getKey();
                EntityModelModifierReloadListener.Layer rawLayer = layerEntry.getValue();
                HashSet<class_2960> missingModels = new HashSet<class_2960>();
                List<EntityLayerProperties.ModelOption> list = defaultModels = rawLayer.defaultModel.model == null ? EntityModelModifierManager.bakeModelOptions(layerIdentifier, List.of(new EntityModelModifierReloadListener.ModelOption(Either.left(FusionEntityModelLoader.locationForLayer(layerIdentifier)), null, null, null, null, null, null, null, null, 1.0f)), null, rawLayer.defaultModel, vanillaModels, missingModels) : EntityModelModifierManager.bakeModelOptions(layerIdentifier, List.of(rawLayer.defaultModel), null, rawLayer.defaultModel, vanillaModels, missingModels);
                if (defaultModels == null) continue;
                ArrayList<Pair<EntityModelPredicate, List<EntityLayerProperties.ModelOption>>> conditionals = new ArrayList<Pair<EntityModelPredicate, List<EntityLayerProperties.ModelOption>>>();
                for (Pair<EntityModelPredicate, EntityModelModifierReloadListener.ModelOption> conditional : rawLayer.conditionals) {
                    EntityModelPredicate predicate = conditional.left();
                    EntityModelModifierReloadListener.ModelOption rawModel = conditional.right();
                    List<EntityLayerProperties.ModelOption> options = EntityModelModifierManager.bakeModelOptions(layerIdentifier, List.of(rawModel), defaultModels, rawLayer.defaultModel, vanillaModels, missingModels);
                    if (options == null) {
                        return;
                    }
                    conditionals.add(Pair.of(predicate, options));
                }
                layers.put((Object)layerIdentifier, (Object)new EntityLayerProperties(layerIdentifier, defaultModels, conditionals));
            }
            MODEL_PROPERTIES.put(entity, new EntityModelModifier((Map<class_5601, EntityLayerProperties>)layers.build()));
        }
    }

    private static List<EntityLayerProperties.ModelOption> bakeModelOptions(class_5601 layer, List<EntityModelModifierReloadListener.ModelOption> rawOptions, List<EntityLayerProperties.ModelOption> defaultModels, EntityModelModifierReloadListener.ModelOption defaults, Map<class_2960, Supplier<class_630>> vanillaModels, Set<class_2960> missingModels) {
        ArrayList<EntityLayerProperties.ModelOption> options = new ArrayList<EntityLayerProperties.ModelOption>(rawOptions.size());
        for (EntityModelModifierReloadListener.ModelOption option : rawOptions) {
            float offset;
            if (option.model == null || option.model.isRight()) {
                List<EntityLayerProperties.ModelOption> models;
                if (option.model == null) {
                    models = defaultModels;
                } else {
                    models = EntityModelModifierManager.bakeModelOptions(layer, option.model.right(), defaultModels, defaults, vanillaModels, missingModels);
                    if (models == null) {
                        return null;
                    }
                }
                if (models == null) {
                    FusionClient.LOGGER.error("No model defined for an entry in layer '{}'", (Object)layer);
                    return null;
                }
                double totalWeight = models.stream().mapToDouble(EntityLayerProperties.ModelOption::weight).sum();
                for (EntityLayerProperties.ModelOption defaultModel : models) {
                    List<class_2960> textures;
                    List<class_2960> list = option.textures == null ? (defaultModel.textures() == null ? defaults.textures : defaultModel.textures()) : (textures = option.textures);
                    Float scale = option.scale == null ? (defaultModel.scaling() == null ? defaults.scale : defaultModel.scaling()) : option.scale;
                    options.add(new EntityLayerProperties.ModelOption(defaultModel.model(), defaultModel.isVanillaModel(), textures, defaultModel.weight() / totalWeight * option.weight, scale));
                }
                continue;
            }
            Pair<class_630, Boolean> baked = EntityModelModifierManager.bakeModel(layer, option.model.left(), vanillaModels, missingModels);
            if (baked == null) {
                return null;
            }
            class_630 model = baked.left();
            float f = option.offsetX == null ? (defaults.offsetX == null ? 0.0f : defaults.offsetX.floatValue()) : (offset = option.offsetX.floatValue());
            if (offset != 0.0f) {
                model = ModelTransformer.translateX(model, offset);
            }
            float f2 = option.offsetY == null ? (defaults.offsetY == null ? 0.0f : defaults.offsetY.floatValue()) : (offset = option.offsetY.floatValue());
            if (offset != 0.0f) {
                model = ModelTransformer.translateY(model, offset);
            }
            float f3 = option.offsetZ == null ? (defaults.offsetZ == null ? 0.0f : defaults.offsetZ.floatValue()) : (offset = option.offsetZ.floatValue());
            if (offset != 0.0f) {
                model = ModelTransformer.translateZ(model, offset);
            }
            if (option.flipX == null ? defaults.flipX == Boolean.TRUE : option.flipX != false) {
                model = ModelTransformer.flipX(model);
            }
            if (option.flipY == null ? defaults.flipY == Boolean.TRUE : option.flipY != false) {
                model = ModelTransformer.flipY(model);
            }
            if (option.flipZ == null ? defaults.flipZ == Boolean.TRUE : option.flipZ != false) {
                model = ModelTransformer.flipZ(model);
            }
            List<class_2960> textures = option.textures == null ? defaults.textures : option.textures;
            Float scale = option.scale == null ? defaults.scale : option.scale;
            options.add(new EntityLayerProperties.ModelOption(model, baked.right(), textures, option.weight, scale));
        }
        double totalWeight = options.stream().mapToDouble(EntityLayerProperties.ModelOption::weight).sum();
        if (totalWeight != 1.0) {
            for (int i = 0; i < options.size(); ++i) {
                EntityLayerProperties.ModelOption option = (EntityLayerProperties.ModelOption)options.get(i);
                options.set(i, new EntityLayerProperties.ModelOption(option.model(), option.isVanillaModel(), option.textures(), option.weight() / totalWeight, option.scaling()));
            }
        }
        options.sort(Comparator.comparingDouble(EntityLayerProperties.ModelOption::weight).reversed());
        return options;
    }

    private static Pair<class_630, Boolean> bakeModel(class_5601 layer, class_2960 modelLocation, Map<class_2960, Supplier<class_630>> vanillaModels, Set<class_2960> missingModels) {
        Supplier<class_630> vanillaSupplier;
        class_630 model = FusionEntityModelLoader.MODELS.get(modelLocation);
        boolean isVanillaModel = false;
        if (model == null && (vanillaSupplier = vanillaModels.get(modelLocation)) != null) {
            model = vanillaSupplier.get();
            isVanillaModel = true;
        }
        if (model == null) {
            if (!missingModels.add(modelLocation)) {
                FusionClient.LOGGER.error("Missing model '{}' for layer '{}'!", (Object)modelLocation, (Object)layer);
            }
            return null;
        }
        return Pair.of(model, isVanillaModel);
    }

    public static FusionModelPart handleModelBake(class_5601 location, class_630 original) {
        if (!trackingBakedModels.get().booleanValue()) {
            return null;
        }
        if (!currentModifierLayers.contains(location) && !FusionEntityModelLoader.MODELS.containsKey(FusionEntityModelLoader.locationForLayer(location))) {
            return null;
        }
        FusionModelPart fusionModelPart = new FusionModelPart(currentLayerIndex++, original);
        overwrittenModelParts.put(location, fusionModelPart);
        return fusionModelPart;
    }

    public static class_897<?> handleRendererCreation(class_1299<?> entityType, class_5617<?> rendererProvider, class_5617.class_5618 context) {
        class_897 renderer;
        EntityModelModifier properties = MODEL_PROPERTIES.get(entityType);
        if (properties != null) {
            currentModifierLayers.addAll(properties.getLayers().keySet());
        }
        trackingBakedModels.set(true);
        try {
            renderer = rendererProvider.create(context);
        }
        catch (Exception e) {
            overwrittenModelParts.clear();
            throw e;
        }
        finally {
            trackingBakedModels.set(false);
            currentModifierLayers.clear();
            currentLayerIndex = 0;
        }
        if (properties != null) {
            for (class_5601 class_56012 : properties.getLayers().keySet()) {
                if (overwrittenModelParts.containsKey(class_56012)) continue;
                FusionClient.LOGGER.warn("An entity model modifier for entity '{}' overwrites layer '{}', but no such layer was found!", (Object)class_2378.field_11145.method_10221(entityType), (Object)class_56012);
            }
        }
        if (!overwrittenModelParts.isEmpty()) {
            for (Map.Entry entry : overwrittenModelParts.entrySet()) {
                EntityLayerProperties layerProperties;
                class_5601 layer = (class_5601)entry.getKey();
                FusionModelPart fusionModelPart = (FusionModelPart)((Object)entry.getValue());
                fusionModelPart.finish();
                if (properties != null && properties.getLayers().containsKey(layer)) {
                    layerProperties = properties.getLayers().get(layer);
                } else {
                    class_630 model = FusionEntityModelLoader.MODELS.get(FusionEntityModelLoader.locationForLayer(layer));
                    layerProperties = new EntityLayerProperties(layer, List.of(new EntityLayerProperties.ModelOption(model, false, null, 1.0, null)), List.of());
                }
                HashSet models = new HashSet();
                layerProperties.gatherModels(models::add);
                HashSet missingParts = new HashSet();
                boolean hasMissingParts = false;
                for (class_630 model : models) {
                    fusionModelPart.validateModelHasImportantChildren(model, missingParts::add);
                    if (missingParts.isEmpty()) continue;
                    FusionClient.LOGGER.error("A model for layer '{}' on entity '{}' is missing required parts: {}!", new Object[]{layer, class_2378.field_11145.method_10221(entityType), missingParts.stream().map(s -> "'" + s + "'").collect(Collectors.joining(","))});
                    missingParts.clear();
                    hasMissingParts = true;
                }
                if (hasMissingParts) {
                    fusionModelPart.setProperties(null, null);
                }
                VanillaModelLayerProperties vanillaProperties = VanillaModelLayerProperties.get(layer, renderer);
                layerProperties = layerProperties.transformed(vanillaProperties);
                fusionModelPart.setProperties(layerProperties, vanillaProperties);
            }
            ((EntityRendererExtension)renderer).setFusionModelParts(new ArrayList<FusionModelPart>(overwrittenModelParts.values()));
            overwrittenModelParts.clear();
        }
        return renderer;
    }
}

