/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.entity.model.loader;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.entity.model.DummyModelPart;
import com.supermartijn642.fusion.entity.model.loader.EntityModelLoader;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_2350;
import net.minecraft.class_5603;
import net.minecraft.class_630;

public class BedrockEntityModelLoader
implements EntityModelLoader {
    @Override
    public class_630 loadModel(JsonObject json) {
        if (!json.has("format_version")) {
            throw new JsonParseException("Missing 'format_version'!");
        }
        if (!json.get("format_version").isJsonPrimitive() || !json.getAsJsonPrimitive("format_version").isString()) {
            throw new JsonParseException("Property 'format_version' must be a string!");
        }
        SchemaVersion version = SchemaVersion.fromName(json.get("format_version").getAsString());
        if (version == null) {
            throw new JsonParseException("Unknown 'format_version': '" + json.get("format_version").getAsString() + "'!");
        }
        if (version.ordinal() < SchemaVersion.V1_12_0.ordinal()) {
            throw new JsonParseException("Unsupported 'format_version': '" + String.valueOf((Object)version) + "'!");
        }
        if (version.ordinal() > SchemaVersion.V1_12_0.ordinal()) {
            FusionClient.LOGGER.warn("Found an entity model with schema version '{}'. In case the model does not load as expected, please report it as a bug to Fusion!", (Object)version);
        }
        if (!json.has("minecraft:geometry")) {
            throw new JsonParseException("Missing 'minecraft:geometry'!");
        }
        if (!json.get("minecraft:geometry").isJsonArray()) {
            throw new JsonParseException("Property 'minecraft:geometry' must be an array!");
        }
        JsonArray geometryArray = json.getAsJsonArray("minecraft:geometry");
        if (geometryArray.isEmpty()) {
            throw new JsonParseException("Array property 'minecraft:geometry' must not be empty!");
        }
        if (!geometryArray.get(0).isJsonObject()) {
            throw new JsonParseException("Array property 'minecraft:geometry' must only contain objects!");
        }
        JsonObject geometryJson = geometryArray.get(0).getAsJsonObject();
        Geometry geometry = BedrockEntityModelLoader.readGeometry(version, geometryJson);
        return geometry.bake();
    }

    private static Geometry readGeometry(SchemaVersion version, JsonObject json) {
        ArrayList<Bone> roots = new ArrayList<Bone>();
        if (!json.has("description") || !json.get("description").isJsonObject()) {
            throw new JsonParseException("Geometry object must have object property 'description'!");
        }
        JsonObject description = json.getAsJsonObject("description");
        if (!(description.has("texture_width") && description.get("texture_width").isJsonPrimitive() && description.getAsJsonPrimitive("texture_width").isNumber())) {
            throw new JsonParseException("Geometry description must have int property 'texture_width'!");
        }
        if (!(description.has("texture_height") && description.get("texture_height").isJsonPrimitive() && description.getAsJsonPrimitive("texture_height").isNumber())) {
            throw new JsonParseException("Geometry description must have int property 'texture_height'!");
        }
        int textureWidth = description.get("texture_width").getAsInt();
        int textureHeight = description.get("texture_height").getAsInt();
        if (textureWidth < 0) {
            throw new JsonParseException("Property 'texture_width' must be greater than zero!");
        }
        if (textureHeight < 0) {
            throw new JsonParseException("Property 'texture_height' must be greater than zero!");
        }
        HashMap<String, Bone> bones = new HashMap<String, Bone>();
        if (json.has("bones")) {
            if (!json.get("bones").isJsonArray()) {
                throw new JsonParseException("Property 'bones' must be an array!");
            }
            JsonArray bonesJson = json.getAsJsonArray("bones");
            for (JsonElement boneJson : bonesJson) {
                if (!boneJson.isJsonObject()) {
                    throw new JsonParseException("Array property 'bones' must only contain objects!");
                }
                Bone bone = BedrockEntityModelLoader.readBone(version, boneJson.getAsJsonObject());
                bones.put(bone.name, bone);
            }
        }
        for (Bone part : bones.values()) {
            if (part.parent == null) {
                roots.add(part);
                continue;
            }
            if (!bones.containsKey(part.parent)) {
                throw new JsonParseException("Missing parent '" + part.parent + "' for bone '" + part.name + "'!");
            }
            Bone parent = (Bone)bones.get(part.parent);
            parent.children.add(part);
        }
        return new Geometry(textureWidth, textureHeight, roots);
    }

    private static Bone readBone(SchemaVersion version, JsonObject json) {
        if (!(json.has("name") && json.get("name").isJsonPrimitive() && json.getAsJsonPrimitive("name").isString())) {
            throw new JsonParseException("Bone must have string property 'name'!");
        }
        String name = json.get("name").getAsString();
        String parent = null;
        if (json.has("parent")) {
            if (!json.get("parent").isJsonPrimitive() || !json.getAsJsonPrimitive("parent").isString()) {
                throw new JsonParseException("Bone property 'parent' must be a string!");
            }
            parent = json.get("parent").getAsString();
        }
        float[] pivot = new float[3];
        if (json.has("pivot")) {
            if (!json.get("pivot").isJsonArray()) {
                throw new JsonParseException("Bone property 'pivot' must be an array!");
            }
            JsonArray arr = json.getAsJsonArray("pivot");
            if (!(arr.size() == 3 && arr.get(0).isJsonPrimitive() && arr.get(0).getAsJsonPrimitive().isNumber() && arr.get(1).isJsonPrimitive() && arr.get(1).getAsJsonPrimitive().isNumber() && arr.get(2).isJsonPrimitive() && arr.get(2).getAsJsonPrimitive().isNumber())) {
                throw new JsonParseException("Bone property 'pivot' must consist of 3 floats!");
            }
            pivot = new float[]{arr.get(0).getAsFloat(), arr.get(1).getAsFloat(), arr.get(2).getAsFloat()};
        }
        float[] rotation = new float[3];
        if (json.has("rotation")) {
            if (!json.get("rotation").isJsonArray()) {
                throw new JsonParseException("Bone property 'rotation' must be an array!");
            }
            JsonArray arr = json.getAsJsonArray("rotation");
            if (!(arr.size() == 3 && arr.get(0).isJsonPrimitive() && arr.get(0).getAsJsonPrimitive().isNumber() && arr.get(1).isJsonPrimitive() && arr.get(1).getAsJsonPrimitive().isNumber() && arr.get(2).isJsonPrimitive() && arr.get(2).getAsJsonPrimitive().isNumber())) {
                throw new JsonParseException("Bone property 'rotation' must consist of 3 floats!");
            }
            rotation = new float[]{arr.get(0).getAsFloat(), arr.get(1).getAsFloat(), arr.get(2).getAsFloat()};
        }
        boolean mirror = false;
        if (json.has("mirror")) {
            if (!json.get("mirror").isJsonPrimitive() || !json.getAsJsonPrimitive("mirror").isBoolean()) {
                throw new JsonParseException("Bone property 'mirror' must be a boolean!");
            }
            mirror = json.get("mirror").getAsBoolean();
        }
        float inflate = 0.0f;
        if (json.has("inflate")) {
            if (!json.get("inflate").isJsonPrimitive() || !json.getAsJsonPrimitive("inflate").isNumber()) {
                throw new JsonParseException("Bone property 'inflate' must be a number!");
            }
            inflate = json.get("inflate").getAsFloat();
        }
        List<Cube> cubes = List.of();
        if (json.has("cubes")) {
            if (!json.get("cubes").isJsonArray()) {
                throw new JsonParseException("Bone property 'cubes' must be an array!");
            }
            JsonArray cubesJson = json.getAsJsonArray("cubes");
            cubes = new ArrayList(cubesJson.size());
            for (JsonElement element : cubesJson) {
                if (!element.isJsonObject()) {
                    throw new JsonParseException("Bone property 'cubes' must only contain objects!");
                }
                cubes.add(BedrockEntityModelLoader.readCube(version, element.getAsJsonObject()));
            }
        }
        if (json.has("poly_mesh")) {
            throw new JsonParseException("Bone property 'poly_mesh' is not supported!");
        }
        if (json.has("texture_meshes")) {
            throw new JsonParseException("Bone property 'texture_meshes' is not supported!");
        }
        return new Bone(name, parent, pivot, rotation, mirror, inflate, cubes);
    }

    private static Cube readCube(SchemaVersion version, JsonObject json) {
        float[] origin = new float[3];
        if (json.has("origin")) {
            if (!json.get("origin").isJsonArray()) {
                throw new JsonParseException("Cube property 'origin' must be an array!");
            }
            JsonArray arr = json.getAsJsonArray("origin");
            if (!(arr.size() == 3 && arr.get(0).isJsonPrimitive() && arr.get(0).getAsJsonPrimitive().isNumber() && arr.get(1).isJsonPrimitive() && arr.get(1).getAsJsonPrimitive().isNumber() && arr.get(2).isJsonPrimitive() && arr.get(2).getAsJsonPrimitive().isNumber())) {
                throw new JsonParseException("Cube property 'origin' must consist of 3 floats!");
            }
            origin = new float[]{arr.get(0).getAsFloat(), arr.get(1).getAsFloat(), arr.get(2).getAsFloat()};
        }
        float[] size = new float[3];
        if (json.has("size")) {
            if (!json.get("size").isJsonArray()) {
                throw new JsonParseException("Cube property 'size' must be an array!");
            }
            JsonArray arr = json.getAsJsonArray("size");
            if (!(arr.size() == 3 && arr.get(0).isJsonPrimitive() && arr.get(0).getAsJsonPrimitive().isNumber() && arr.get(1).isJsonPrimitive() && arr.get(1).getAsJsonPrimitive().isNumber() && arr.get(2).isJsonPrimitive() && arr.get(2).getAsJsonPrimitive().isNumber())) {
                throw new JsonParseException("Cube property 'size' must consist of 3 floats!");
            }
            size = new float[]{arr.get(0).getAsFloat(), arr.get(1).getAsFloat(), arr.get(2).getAsFloat()};
        }
        float[] rotation = new float[3];
        if (json.has("rotation")) {
            if (!json.get("rotation").isJsonArray()) {
                throw new JsonParseException("Cube property 'rotation' must be an array!");
            }
            JsonArray arr = json.getAsJsonArray("rotation");
            if (!(arr.size() == 3 && arr.get(0).isJsonPrimitive() && arr.get(0).getAsJsonPrimitive().isNumber() && arr.get(1).isJsonPrimitive() && arr.get(1).getAsJsonPrimitive().isNumber() && arr.get(2).isJsonPrimitive() && arr.get(2).getAsJsonPrimitive().isNumber())) {
                throw new JsonParseException("Cube property 'rotation' must consist of 3 floats!");
            }
            rotation = new float[]{arr.get(0).getAsFloat(), arr.get(1).getAsFloat(), arr.get(2).getAsFloat()};
        }
        float[] pivot = new float[3];
        if (json.has("pivot")) {
            if (!json.get("pivot").isJsonArray()) {
                throw new JsonParseException("Cube property 'pivot' must be an array!");
            }
            JsonArray arr = json.getAsJsonArray("pivot");
            if (!(arr.size() == 3 && arr.get(0).isJsonPrimitive() && arr.get(0).getAsJsonPrimitive().isNumber() && arr.get(1).isJsonPrimitive() && arr.get(1).getAsJsonPrimitive().isNumber() && arr.get(2).isJsonPrimitive() && arr.get(2).getAsJsonPrimitive().isNumber())) {
                throw new JsonParseException("Cube property 'pivot' must consist of 3 floats!");
            }
            pivot = new float[]{arr.get(0).getAsFloat(), arr.get(1).getAsFloat(), arr.get(2).getAsFloat()};
        }
        Float inflate = null;
        if (json.has("inflate")) {
            if (!json.get("inflate").isJsonPrimitive() || !json.getAsJsonPrimitive("inflate").isNumber()) {
                throw new JsonParseException("Cube property 'inflate' must be a number!");
            }
            inflate = Float.valueOf(json.get("inflate").getAsFloat());
        }
        Boolean mirror = null;
        if (json.has("mirror")) {
            if (!json.get("mirror").isJsonPrimitive() || !json.getAsJsonPrimitive("mirror").isBoolean()) {
                throw new JsonParseException("Cube property 'mirror' must be a boolean!");
            }
            mirror = json.get("mirror").getAsBoolean();
        }
        EnumMap<class_2350, Face> faces = new EnumMap<class_2350, Face>(class_2350.class);
        if (json.has("uv")) {
            if (json.get("uv").isJsonArray()) {
                JsonArray arr = json.getAsJsonArray("uv");
                if (!(arr.size() == 2 && arr.get(0).isJsonPrimitive() && arr.get(0).getAsJsonPrimitive().isNumber() && arr.get(1).isJsonPrimitive() && arr.get(1).getAsJsonPrimitive().isNumber())) {
                    throw new JsonParseException("Cube property 'uv' must consist of 2 floats!");
                }
                for (class_2350 side : class_2350.values()) {
                    faces.put(side, new Face(new float[]{arr.get(0).getAsFloat(), arr.get(1).getAsFloat()}, null, 0, false));
                }
            } else if (json.get("uv").isJsonObject()) {
                JsonObject uvJson = json.getAsJsonObject("uv");
                for (class_2350 side : class_2350.values()) {
                    if (!uvJson.has(side.method_10151())) continue;
                    if (!uvJson.get(side.method_10151()).isJsonObject()) {
                        throw new JsonParseException("Cube uv for side '" + side.method_10151() + "' must be an object!");
                    }
                    faces.put(side, BedrockEntityModelLoader.readFace(version, uvJson.getAsJsonObject(side.method_10151()), side));
                }
            } else {
                throw new JsonParseException("Cube property 'uv' must either be an object or an array!");
            }
        }
        return new Cube(origin, size, rotation, pivot, inflate, mirror, faces);
    }

    private static Face readFace(SchemaVersion version, JsonObject json, class_2350 side) {
        if (!json.has("uv") || !json.get("uv").isJsonArray()) {
            throw new JsonParseException("Cube uv for side '" + side.method_10151() + "' must have array property 'uv'!");
        }
        JsonArray arr = json.getAsJsonArray("uv");
        if (!(arr.size() == 2 && arr.get(0).isJsonPrimitive() && arr.get(0).getAsJsonPrimitive().isNumber() && arr.get(1).isJsonPrimitive() && arr.get(1).getAsJsonPrimitive().isNumber())) {
            throw new JsonParseException("Property 'uv' in cube uv for side '" + side.method_10151() + "' must consist of 2 floats!");
        }
        float[] uv = new float[]{arr.get(0).getAsFloat(), arr.get(1).getAsFloat()};
        float[] size = null;
        if (json.has("uv_size")) {
            if (!json.get("uv_size").isJsonArray()) {
                throw new JsonParseException("Property 'uv_size' in cube uv for side '" + side.method_10151() + "' must be an array!");
            }
            arr = json.getAsJsonArray("uv_size");
            if (!(arr.size() == 2 && arr.get(0).isJsonPrimitive() && arr.get(0).getAsJsonPrimitive().isNumber() && arr.get(1).isJsonPrimitive() && arr.get(1).getAsJsonPrimitive().isNumber())) {
                throw new JsonParseException("Property 'uv_size' in cube uv for side '" + side.method_10151() + "' must consist of 2 floats!");
            }
            size = new float[]{arr.get(0).getAsFloat(), arr.get(1).getAsFloat()};
        }
        int rotation = 0;
        if (json.has("uv_rotation")) {
            if (!json.get("uv_rotation").isJsonPrimitive() || !json.getAsJsonPrimitive("uv_rotation").isNumber()) {
                throw new JsonParseException("Property 'uv_rotation' in cube uv for side '" + side.method_10151() + "' must be an integer!");
            }
            rotation = json.get("uv_rotation").getAsInt();
        }
        return new Face(uv, size, rotation, true);
    }

    private static enum SchemaVersion {
        V1_8_0("1.8.0"),
        V1_12_0("1.12.0"),
        V1_14_0("1.14.0"),
        V1_16_0("1.16.0"),
        V1_19_30("1.19.30"),
        V1_21_0("1.21.0");

        private final String name;

        public static SchemaVersion fromName(String version) {
            for (SchemaVersion value : SchemaVersion.values()) {
                if (!value.name.equals(version)) continue;
                return value;
            }
            return null;
        }

        private SchemaVersion(String name) {
            this.name = name;
        }
    }

    private static class Geometry {
        private final int textureWidth;
        private final int textureHeight;
        private final List<Bone> bones;

        private Geometry(int textureWidth, int textureHeight, List<Bone> bones) {
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.bones = bones;
        }

        public class_630 bake() {
            Map<String, class_630> children = this.bones.stream().collect(Collectors.toUnmodifiableMap(b -> b.name, b -> b.bake(this.textureWidth, this.textureHeight)));
            return new class_630(List.of(), children);
        }
    }

    private static class Bone {
        public final String name;
        public final String parent;
        private final float[] pivot;
        private final float[] rotation;
        private final boolean mirror;
        private final float inflate;
        private final List<Cube> cubes;
        public final List<Bone> children = new ArrayList<Bone>();

        private Bone(String name, String parent, float[] pivot, float[] rotation, boolean mirror, float inflate, List<Cube> cubes) {
            this.name = name;
            this.parent = parent;
            this.pivot = pivot;
            this.rotation = rotation;
            this.mirror = mirror;
            this.inflate = inflate;
            this.cubes = cubes;
        }

        public class_630 bake(int textureWidth, int textureHeight) {
            HashMap<Object, class_630> children = new HashMap<Object, class_630>();
            for (Bone bone : this.children) {
                children.put(bone.name, bone.bake(textureWidth, textureHeight));
            }
            int index = 0;
            for (Cube cube : this.cubes) {
                class_630 part = cube.bake(this, textureWidth, textureHeight);
                while (children.containsKey("Cube " + index)) {
                    ++index;
                }
                children.put("Cube " + index, part);
            }
            class_630 class_6302 = new class_630(List.of(), Map.copyOf(children));
            class_5603 pose = class_5603.method_32090((float)this.pivot[0], (float)(-this.pivot[1]), (float)(-this.pivot[2]));
            class_6302.method_41918(pose);
            class_6302.method_32085(pose);
            DummyModelPart pivotPart = new DummyModelPart(class_6302);
            pose = class_5603.method_32091((float)(-this.pivot[0]), (float)this.pivot[1], (float)this.pivot[2], (float)((float)Math.toRadians(-this.rotation[0])), (float)((float)Math.toRadians(-this.rotation[1])), (float)((float)Math.toRadians(this.rotation[2])));
            pivotPart.method_41918(pose);
            pivotPart.method_32085(pose);
            return pivotPart;
        }
    }

    private static class Cube {
        private final float[] origin;
        private final float[] size;
        private final float[] rotation;
        private final float[] pivot;
        private final Float inflate;
        private final Boolean mirror;
        private final Map<class_2350, Face> uvs;

        private Cube(float[] origin, float[] size, float[] rotation, float[] pivot, Float inflate, Boolean mirror, Map<class_2350, Face> uvs) {
            this.origin = origin;
            this.size = size;
            this.rotation = rotation;
            this.pivot = pivot;
            this.inflate = inflate;
            this.mirror = mirror;
            this.uvs = uvs;
        }

        public class_630 bake(Bone bone, int textureWidth, int textureHeight) {
            float inflate = this.inflate == null ? bone.inflate : this.inflate.floatValue();
            boolean mirror = this.mirror == null ? bone.mirror : this.mirror;
            for (class_2350 side : class_2350.values()) {
                this.uvs.computeIfPresent(side, (s, f) -> new Face(f.uv, f.size, f.rotation, f.sideSpecific));
            }
            class_630.class_593[] polygons = Cube.createPolygons(-this.origin[0] - this.size[0] - this.pivot[0], this.origin[1] + this.pivot[1], this.origin[2] + this.pivot[2], this.size[0], this.size[1], this.size[2], inflate, textureWidth, textureHeight, this.uvs, mirror);
            class_630.class_628 cube = new class_630.class_628(0, 0, -this.origin[0] - this.size[0] - this.pivot[0], this.origin[1] + this.pivot[1], this.origin[2] + this.pivot[2], this.size[0], this.size[1], this.size[2], inflate, inflate, inflate, mirror, 1.0f, 1.0f);
            cube.field_3649 = polygons;
            class_630 part = new class_630(List.of(cube), Map.of());
            class_5603 pose = class_5603.method_32091((float)this.pivot[0], (float)(-this.pivot[1]), (float)(-this.pivot[2]), (float)((float)Math.toRadians(-this.rotation[0])), (float)((float)Math.toRadians(-this.rotation[1])), (float)((float)Math.toRadians(this.rotation[2])));
            part.method_41918(pose);
            part.method_32085(pose);
            return part;
        }

        private static class_630.class_593[] createPolygons(float startX, float startY, float startZ, float sizeX, float sizeY, float sizeZ, float inflation, int textureWidth, int textureHeight, Map<class_2350, Face> faces, boolean mirror) {
            float endX = startX + sizeX + inflation;
            float endY = startY + sizeY + inflation;
            float endZ = startZ + sizeZ + inflation;
            startX -= inflation;
            startY -= inflation;
            startZ -= inflation;
            if (mirror) {
                float f = endX;
                endX = startX;
                startX = f;
            }
            class_630.class_618 minXMinYMinZ = new class_630.class_618(startX, startY, startZ, 0.0f, 0.0f);
            class_630.class_618 maxXMinYMinZ = new class_630.class_618(endX, startY, startZ, 0.0f, 8.0f);
            class_630.class_618 maxXMaxYMinZ = new class_630.class_618(endX, endY, startZ, 8.0f, 8.0f);
            class_630.class_618 minXMaxYMinZ = new class_630.class_618(startX, endY, startZ, 8.0f, 0.0f);
            class_630.class_618 minXMinYMaxZ = new class_630.class_618(startX, startY, endZ, 0.0f, 0.0f);
            class_630.class_618 maxXMinYMaxZ = new class_630.class_618(endX, startY, endZ, 0.0f, 8.0f);
            class_630.class_618 maxXMaxYMaxZ = new class_630.class_618(endX, endY, endZ, 8.0f, 8.0f);
            class_630.class_618 minXMaxYMaxZ = new class_630.class_618(startX, endY, endZ, 8.0f, 0.0f);
            int polygonIndex = 0;
            class_630.class_593[] polygons = new class_630.class_593[faces.size()];
            if (faces.containsKey(class_2350.field_11033)) {
                polygons[polygonIndex++] = Cube.createPolygon(minXMinYMinZ, maxXMinYMinZ, maxXMinYMaxZ, minXMinYMaxZ, sizeX + sizeZ, sizeZ, sizeX + sizeX + sizeZ, 0.0f, sizeX, sizeZ, textureWidth, textureHeight, mirror, class_2350.field_11033, faces);
            }
            if (faces.containsKey(class_2350.field_11036)) {
                polygons[polygonIndex++] = Cube.createPolygon(minXMaxYMaxZ, maxXMaxYMaxZ, maxXMaxYMinZ, minXMaxYMinZ, sizeZ, 0.0f, sizeX + sizeZ, sizeZ, sizeX, sizeZ, textureWidth, textureHeight, mirror, class_2350.field_11036, faces);
            }
            if (faces.containsKey(class_2350.field_11039)) {
                polygons[polygonIndex++] = Cube.createPolygon(minXMaxYMaxZ, minXMaxYMinZ, minXMinYMinZ, minXMinYMaxZ, sizeX + sizeZ, sizeZ, sizeX + sizeZ + sizeZ, sizeY + sizeZ, sizeZ, sizeY, textureWidth, textureHeight, mirror, class_2350.field_11039, faces);
            }
            if (faces.containsKey(class_2350.field_11043)) {
                polygons[polygonIndex++] = Cube.createPolygon(minXMaxYMinZ, maxXMaxYMinZ, maxXMinYMinZ, minXMinYMinZ, sizeZ, sizeZ, sizeX + sizeZ, sizeY + sizeZ, sizeX, sizeY, textureWidth, textureHeight, mirror, class_2350.field_11043, faces);
            }
            if (faces.containsKey(class_2350.field_11034)) {
                polygons[polygonIndex++] = Cube.createPolygon(maxXMaxYMinZ, maxXMaxYMaxZ, maxXMinYMaxZ, maxXMinYMinZ, 0.0f, sizeZ, sizeZ, sizeY + sizeZ, sizeZ, sizeY, textureWidth, textureHeight, mirror, class_2350.field_11034, faces);
            }
            if (faces.containsKey(class_2350.field_11035)) {
                polygons[polygonIndex] = Cube.createPolygon(maxXMaxYMaxZ, minXMaxYMaxZ, minXMinYMaxZ, maxXMinYMaxZ, sizeX + sizeZ + sizeZ, sizeZ, sizeX + sizeX + sizeZ + sizeZ, sizeY + sizeZ, sizeX, sizeY, textureWidth, textureHeight, mirror, class_2350.field_11035, faces);
            }
            return polygons;
        }

        private static class_630.class_593 createPolygon(class_630.class_618 vertex0, class_630.class_618 vertex1, class_630.class_618 vertex2, class_630.class_618 vertex3, float u0, float v0, float u1, float v1, float width, float height, int textureWidth, int textureHeight, boolean mirror, class_2350 side, Map<class_2350, Face> faces) {
            Face face = faces.get(class_2350.field_11033);
            if (face.sideSpecific) {
                float[] fArray;
                if (face.size == null) {
                    float[] fArray2 = new float[2];
                    fArray2[0] = width;
                    fArray = fArray2;
                    fArray2[1] = height;
                } else {
                    fArray = face.size;
                }
                float[] uvSize = fArray;
                u0 = face.uv[0];
                u1 = face.uv[0] + uvSize[0];
                v0 = face.uv[1];
                v1 = face.uv[1] + uvSize[1];
            } else {
                u0 += face.uv[0];
                u1 += face.uv[0];
                v0 += face.uv[1];
                v1 += face.uv[1];
            }
            return new class_630.class_593(new class_630.class_618[]{vertex0, vertex1, vertex2, vertex3}, u0, v0, u1, v1, (float)textureWidth, (float)textureHeight, mirror, class_2350.field_11033);
        }
    }

    private static class Face {
        private final float[] uv;
        private final float[] size;
        private final int rotation;
        private final boolean sideSpecific;

        private Face(float[] uv, float[] size, int rotation, boolean sideSpecific) {
            this.uv = uv;
            this.size = size;
            this.rotation = rotation;
            this.sideSpecific = sideSpecific;
        }
    }
}

