/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.supermartijn642.fusion.extensions.PackResourcesExtension;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.class_2960;
import net.minecraft.class_3258;
import net.minecraft.class_3264;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3258.class})
public class FilePackResourcesMixin
implements PackResourcesExtension {
    @Unique
    private String overridesFolder;

    @Override
    public void setFusionOverridesFolder(String folder) {
        this.overridesFolder = folder;
    }

    @Shadow
    private ZipFile method_14399() {
        throw new AssertionError();
    }

    @Inject(method={"getResource(Ljava/lang/String;)Ljava/io/InputStream;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getResource(String path, CallbackInfoReturnable<InputStream> ci) throws IOException {
        ZipEntry zipEntry;
        if (this.overridesFolder == null) {
            return;
        }
        path = this.overridesFolder + (String)path;
        ZipFile zipFile = this.method_14399();
        if (zipFile != null && (zipEntry = zipFile.getEntry((String)path)) != null) {
            ci.setReturnValue((Object)zipFile.getInputStream(zipEntry));
        }
    }

    @Inject(method={"hasResource(Ljava/lang/String;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void hasResource(String path, CallbackInfoReturnable<Boolean> ci) {
        if (this.overridesFolder == null) {
            return;
        }
        path = this.overridesFolder + (String)path;
        try {
            ZipFile zipFile = this.method_14399();
            if (zipFile != null && zipFile.getEntry((String)path) != null) {
                ci.setReturnValue((Object)true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @ModifyReturnValue(method={"getNamespaces"}, at={@At(value="RETURN")})
    private Set<String> getNamespaces(Set<String> namespaces, class_3264 type) {
        ZipFile zipFile;
        if (this.overridesFolder == null) {
            return namespaces;
        }
        try {
            zipFile = this.method_14399();
        }
        catch (Exception ignored) {
            return namespaces;
        }
        if (zipFile == null) {
            return namespaces;
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        namespaces = Sets.newHashSet(namespaces);
        while (enumeration.hasMoreElements()) {
            ArrayList list;
            ZipEntry zipEntry = enumeration.nextElement();
            String name = zipEntry.getName();
            if (!name.startsWith(this.overridesFolder) || !(name = name.substring(this.overridesFolder.length())).startsWith(type.method_14413() + "/") || (list = Lists.newArrayList((Iterable)class_3258.field_14183.split((CharSequence)name))).size() <= 1) continue;
            String namespace = (String)list.get(1);
            if (namespace.equals(namespace.toLowerCase(Locale.ROOT))) {
                namespaces.add(namespace);
                continue;
            }
            class_3258.field_39096.warn("Ignored non-lowercase namespace: {} in {}", (Object)namespace, (Object)((class_3258)this).field_14181);
        }
        return namespaces;
    }

    @ModifyReturnValue(method={"getResources"}, at={@At(value="RETURN")})
    private Collection<class_2960> getResources(Collection<class_2960> locations, class_3264 type, String namespace, String folderName, Predicate<class_2960> predicate) {
        ZipFile zipFile;
        if (this.overridesFolder == null) {
            return locations;
        }
        if (locations == null) {
            return null;
        }
        if (!(locations instanceof ArrayList)) {
            locations = new ArrayList<class_2960>(locations);
        }
        HashSet<class_2960> locationSet = new HashSet<class_2960>(locations);
        try {
            zipFile = this.method_14399();
        }
        catch (Exception ignored) {
            return locations;
        }
        if (zipFile == null) {
            return locations;
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        String namespaceDirectory = this.overridesFolder + type.method_14413() + "/" + namespace + "/";
        String pathDirectory = namespaceDirectory + folderName + "/";
        while (enumeration.hasMoreElements()) {
            String name;
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || (name = zipEntry.getName()).endsWith(".mcmeta") || !name.startsWith(pathDirectory)) continue;
            String identifier = name.substring(namespaceDirectory.length());
            class_2960 location = class_2960.method_43902((String)namespace, (String)identifier);
            if (location != null) {
                if (locationSet.contains(location) || !predicate.test(location)) continue;
                locations.add(location);
                continue;
            }
            class_3258.field_39096.warn("Invalid path in datapack: {}:{}, ignoring", (Object)namespace, (Object)identifier);
        }
        return locations;
    }
}

