/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.mojang.datafixers.util.Pair;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.texture.TextureErrorException;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.extensions.TextureAtlasSpriteExtension;
import com.supermartijn642.fusion.texture.FusionTextureMetadataSection;
import com.supermartijn642.fusion.texture.SpriteCreationContextImpl;
import com.supermartijn642.fusion.texture.SpritePreparationContextImpl;
import com.supermartijn642.fusion.texture.TextureTypeRegistryImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import net.minecraft.class_1050;
import net.minecraft.class_1055;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1079;
import net.minecraft.class_2960;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1059.class}, priority=900)
public class TextureAtlasMixin {
    @Unique
    private final Map<class_2960, com.supermartijn642.fusion.api.util.Pair<TextureType<Object>, Object>> fusionTextureMetadata = new HashMap<class_2960, com.supermartijn642.fusion.api.util.Pair<TextureType<Object>, Object>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"method_18160(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/server/packs/resources/ResourceManager;Ljava/util/Queue;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/resources/metadata/animation/AnimationMetadataSection;getFrameSize(II)Lcom/mojang/datafixers/util/Pair;", shift=At.Shift.BEFORE)}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private void gatherMetadata(class_2960 identifier, class_3300 resourceManager, Queue<class_1058.class_4727> queue, CallbackInfo ci, class_2960 location, Optional<?> optional, class_3298 resource, class_1050 pngInfo, class_1079 animationMetadata) {
        com.supermartijn642.fusion.api.util.Pair metadata = null;
        try {
            metadata = resource.method_14481().method_43041((class_3270)FusionTextureMetadataSection.INSTANCE).orElse(null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (metadata != null) {
            com.supermartijn642.fusion.api.util.Pair<Integer, Integer> newSize;
            Map<class_2960, com.supermartijn642.fusion.api.util.Pair<TextureType<Object>, Object>> map = this.fusionTextureMetadata;
            synchronized (map) {
                this.fusionTextureMetadata.put(identifier, metadata);
            }
            Pair originalSize = animationMetadata.method_24143(pngInfo.field_5227, pngInfo.field_5226);
            try {
                newSize = ((TextureType)metadata.left()).getFrameSize(new SpritePreparationContextImpl((Integer)originalSize.getFirst(), (Integer)originalSize.getSecond(), pngInfo.field_5227, pngInfo.field_5226, identifier, animationMetadata), metadata.right());
            }
            catch (TextureErrorException e) {
                FusionClient.LOGGER.error("Error for texture '{}': {}", (Object)identifier, (Object)e.getMessage());
                ci.cancel();
                return;
            }
            catch (Exception e) {
                throw new RuntimeException("Encountered an exception whilst getting frame size from texture type '" + String.valueOf(TextureTypeRegistryImpl.getIdentifier((TextureType)metadata.left())) + "' for texture '" + String.valueOf(location) + "'!", e);
            }
            if (newSize == null) {
                throw new RuntimeException("Received null frame size from texture type '" + String.valueOf(TextureTypeRegistryImpl.getIdentifier((TextureType)metadata.left())) + "' for texture '" + String.valueOf(location) + "'!");
            }
            queue.add(new class_1058.class_4727(identifier, newSize.left().intValue(), newSize.right().intValue(), animationMetadata));
            ci.cancel();
        }
    }

    @Inject(method={"getLoadedSprites(Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/client/renderer/texture/Stitcher;I)Ljava/util/List;"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void getLoadedSprites(class_3300 resourceManager, class_1055 stitcher, int i, CallbackInfoReturnable<List<class_1058>> ci) {
        List textures = (List)ci.getReturnValue();
        if (textures != null) {
            for (int index = 0; index < textures.size(); ++index) {
                class_1058 newTexture;
                class_1058 texture = (class_1058)textures.get(index);
                com.supermartijn642.fusion.api.util.Pair<TextureType<Object>, Object> textureData = this.fusionTextureMetadata.get(texture.method_4598());
                if (textureData == null) continue;
                try (SpriteCreationContextImpl context = new SpriteCreationContextImpl(texture);){
                    newTexture = textureData.left().createSprite(context, textureData.right());
                }
                catch (Exception e) {
                    throw new RuntimeException("Encountered an exception whilst initialising texture '" + String.valueOf(texture.method_4598()) + "' for texture type '" + String.valueOf(TextureTypeRegistryImpl.getIdentifier(textureData.left())) + "'!", e);
                }
                if (newTexture == null) {
                    throw new RuntimeException("Received null texture from texture type '" + String.valueOf(TextureTypeRegistryImpl.getIdentifier(textureData.left())) + "' for texture '" + String.valueOf(texture.method_4598()) + "'!");
                }
                ((TextureAtlasSpriteExtension)newTexture).setFusionTextureType(textureData.left());
                textures.set(index, newTexture);
            }
        }
        this.fusionTextureMetadata.clear();
    }
}

