/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin.modernfix;

import com.google.common.collect.Lists;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.extensions.ResourceMetadataExtension;
import com.supermartijn642.fusion.extensions.TextureAtlasSpriteExtension;
import com.supermartijn642.fusion.texture.FusionTextureMetadataSection;
import com.supermartijn642.fusion.texture.SpriteCreationContextImpl;
import com.supermartijn642.fusion.texture.SpritePreparationContextImpl;
import com.supermartijn642.fusion.texture.TextureTypeRegistryImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1055;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1079;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7368;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1059.class}, priority=900)
public class TextureAtlasMixinModernFix {
    @Unique
    private final Map<class_2960, Pair<TextureType<Object>, Object>> fusionTextureMetadata = new HashMap<class_2960, Pair<TextureType<Object>, Object>>();

    @Shadow
    private class_2960 method_4603(class_2960 location) {
        throw new AssertionError();
    }

    @Inject(method={"getBasicSpriteInfos(Lnet/minecraft/server/packs/resources/ResourceManager;Ljava/util/Set;)Ljava/util/Collection;"}, at={@At(value="RETURN")})
    private void gatherMetadata(class_3300 resourceManager, Set<class_2960> sprites, CallbackInfoReturnable<Collection<class_1058.class_4727>> ci) {
        Collection spriteInfos = (Collection)ci.getReturnValue();
        ArrayList tasks = Lists.newArrayList();
        for (class_1058.class_4727 info : spriteInfos) {
            tasks.add(CompletableFuture.runAsync(() -> {
                class_2960 location = this.method_4603(info.method_24121());
                Optional optional = resourceManager.method_14486(location);
                if (optional.isPresent()) {
                    Object resourceMetadata3;
                    Pair metadata;
                    class_3298 resource = (class_3298)optional.get();
                    try {
                        class_7368 resourceMetadata2 = resource.method_14481();
                        if (resourceMetadata2 instanceof ResourceMetadataExtension) {
                            ((ResourceMetadataExtension)resourceMetadata2).disableFusionOverwrite();
                        }
                        metadata = resourceMetadata2.method_43041((class_3270)FusionTextureMetadataSection.INSTANCE).orElse(null);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Encountered an exception whilst reading metadata for '" + String.valueOf(location) + "'!", e);
                    }
                    class_1079 animationMetadata = null;
                    try {
                        resourceMetadata3 = resource.method_14481();
                        if (resourceMetadata3 instanceof ResourceMetadataExtension) {
                            ((ResourceMetadataExtension)resourceMetadata3).disableFusionOverwrite();
                        }
                        animationMetadata = resourceMetadata3.method_43041((class_3270)class_1079.field_5337).orElse(null);
                    }
                    catch (IOException resourceMetadata3) {
                        // empty catch block
                    }
                    if (metadata != null) {
                        Pair<Integer, Integer> newSize;
                        resourceMetadata3 = this.fusionTextureMetadata;
                        synchronized (resourceMetadata3) {
                            this.fusionTextureMetadata.put(info.method_24121(), metadata);
                        }
                        try {
                            newSize = ((TextureType)metadata.left()).getFrameSize(new SpritePreparationContextImpl(info.method_24123(), info.method_24125(), info.method_24123(), info.method_24125(), info.method_24121(), animationMetadata), metadata.right());
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Encountered an exception whilst getting frame size from texture type '" + String.valueOf(TextureTypeRegistryImpl.getIdentifier((TextureType)metadata.left())) + "' for texture '" + String.valueOf(location) + "'!", e);
                        }
                        if (newSize == null) {
                            throw new RuntimeException("Received null frame size from texture type '" + String.valueOf(TextureTypeRegistryImpl.getIdentifier((TextureType)metadata.left())) + "' for texture '" + String.valueOf(location) + "'!");
                        }
                        info.field_21756 = animationMetadata == null ? class_1079.field_21768 : animationMetadata;
                        info.field_21754 = newSize.left();
                        info.field_21755 = newSize.right();
                    }
                }
            }, class_156.method_18349()));
        }
        CompletableFuture.allOf(tasks.toArray(new CompletableFuture[0])).join();
    }

    @Inject(method={"getLoadedSprites(Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/client/renderer/texture/Stitcher;I)Ljava/util/List;"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void getLoadedSprites(class_3300 resourceManager, class_1055 stitcher, int i, CallbackInfoReturnable<List<class_1058>> ci) {
        List textures = (List)ci.getReturnValue();
        if (textures != null) {
            for (int index = 0; index < textures.size(); ++index) {
                class_1058 newTexture;
                class_1058 texture = (class_1058)textures.get(index);
                Pair<TextureType<Object>, Object> textureData = this.fusionTextureMetadata.get(texture.method_4598());
                if (textureData == null) continue;
                try (SpriteCreationContextImpl context = new SpriteCreationContextImpl(texture);){
                    newTexture = textureData.left().createSprite(context, textureData.right());
                }
                catch (Exception e) {
                    throw new RuntimeException("Encountered an exception whilst initialising texture '" + String.valueOf(texture.method_4598()) + "' for texture type '" + String.valueOf(TextureTypeRegistryImpl.getIdentifier(textureData.left())) + "'!", e);
                }
                if (newTexture == null) {
                    throw new RuntimeException("Received null texture from texture type '" + String.valueOf(TextureTypeRegistryImpl.getIdentifier(textureData.left())) + "' for texture '" + String.valueOf(texture.method_4598()) + "'!");
                }
                ((TextureAtlasSpriteExtension)newTexture).setFusionTextureType(textureData.left());
                textures.set(index, newTexture);
            }
        }
        this.fusionTextureMetadata.clear();
    }
}

