/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.base;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.GatherTexturesContext;
import com.supermartijn642.fusion.api.model.ModelBakingContext;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.api.model.SpriteIdentifier;
import com.supermartijn642.fusion.api.model.data.BaseModelData;
import com.supermartijn642.fusion.model.types.base.BaseModelElement;
import com.supermartijn642.fusion.model.types.base.BaseModelQuad;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1058;
import net.minecraft.class_1088;
import net.minecraft.class_1159;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_4730;
import net.minecraft.class_777;
import net.minecraft.class_783;
import net.minecraft.class_785;
import net.minecraft.class_793;
import net.minecraft.class_796;
import net.minecraft.class_801;

public class BaseModelDataImpl
implements BaseModelData {
    protected static final class_796 FACE_BAKERY = new class_796();
    protected final class_793 model;
    protected final List<class_2960> parents;
    protected final List<BaseModelElement> elements;

    public BaseModelDataImpl(class_793 model, List<class_2960> parents, List<BaseModelElement> elements) {
        this.model = model;
        this.parents = ImmutableList.copyOf(parents);
        this.elements = ImmutableList.copyOf(elements);
    }

    @Override
    public class_793 getVanillaModel() {
        return this.model;
    }

    @Override
    public List<class_2960> getParents() {
        return this.parents;
    }

    public List<? extends BaseModelElement> getElements() {
        return this.elements;
    }

    public void validateParents(Function<class_2960, ModelInstance<?>> modelResolver, class_2960 rootModel) {
        ArrayList<class_2960> encounteredModels = new ArrayList<class_2960>();
        for (class_2960 parent : this.parents) {
            this.validateParents(modelResolver, parent, encounteredModels, rootModel);
        }
    }

    private void validateParents(Function<class_2960, ModelInstance<?>> modelResolver, class_2960 modelLocation, List<class_2960> encounteredModels, class_2960 rootModel) {
        if (encounteredModels.contains(modelLocation)) {
            throw new IllegalStateException("Unable to bake model '" + String.valueOf(rootModel) + "' due to circular dependency " + encounteredModels.stream().map(o -> "'" + String.valueOf(o) + "'").collect(Collectors.joining("->")) + "->'" + String.valueOf(modelLocation) + "'!");
        }
        encounteredModels.add(modelLocation);
        ModelInstance<?> model = modelResolver.apply(modelLocation);
        if (model != null) {
            for (class_2960 dependency : model.getParentModels()) {
                this.validateParents(modelResolver, dependency, encounteredModels, rootModel);
            }
        }
        encounteredModels.remove(encounteredModels.size() - 1);
    }

    public <T> T findProperty(ModelBakingContext context, Function<class_793, T> property, T defaultValue) {
        T value = this.findProperty(context::getModel, ModelInstance.of(DefaultModelTypes.BASE, this), property);
        return value == null ? defaultValue : value;
    }

    private <T> T findProperty(Function<class_2960, ModelInstance<?>> modelResolver, ModelInstance<?> model, Function<class_793, T> property) {
        T value;
        class_793 vanillaModel = model.getAsVanillaModel();
        if (vanillaModel != null && (value = property.apply(vanillaModel)) != null) {
            return value;
        }
        for (class_2960 location : model.getParentModels()) {
            T childValue;
            ModelInstance<?> dependency = modelResolver.apply(location);
            if (dependency == null || (childValue = this.findProperty(modelResolver, dependency, property)) == null) continue;
            return childValue;
        }
        return null;
    }

    public SpriteIdentifier findParticleSprite(ModelBakingContext context) {
        ModelInstance<BaseModelDataImpl> model = ModelInstance.of(DefaultModelTypes.BASE, this);
        ArrayList<String> encounteredKeys = new ArrayList<String>();
        encounteredKeys.add("particle");
        String currentKey = "particle";
        while (true) {
            String finalCurrentKey = currentKey;
            Either either = this.findProperty(context::getModel, model, m -> (Either)m.field_4251.get(finalCurrentKey));
            if (either == null) {
                return SpriteIdentifier.missing();
            }
            if (either.left().isPresent()) {
                return SpriteIdentifier.of((class_4730)either.left().get());
            }
            currentKey = (String)either.right().get();
            if (encounteredKeys.contains(currentKey)) {
                FusionClient.LOGGER.warn("Unable to resolve texture due to circular references {}->'{}' in '{}'!", new Object[]{encounteredKeys.stream().map(o -> "'" + o + "'").collect(Collectors.joining("->")), currentKey, context.getModelIdentifier()});
                return SpriteIdentifier.missing();
            }
            encounteredKeys.add(currentKey);
        }
    }

    public List<BaseModelQuad> bakeQuads(ModelBakingContext context) {
        ArrayList<BaseModelQuad> quads = new ArrayList<BaseModelQuad>();
        this.bakeQuads(context, ModelInstance.of(DefaultModelTypes.BASE, this), new LinkedList(), quads::add);
        return quads;
    }

    private void bakeQuads(ModelBakingContext context, ModelInstance<?> model, Deque<ModelInstance<?>> modelStack, Consumer<BaseModelQuad> output) {
        modelStack.addLast(model);
        List<class_785> elements = null;
        if (model.getModelType() == DefaultModelTypes.BASE || model.getModelType() == DefaultModelTypes.CONNECTING) {
            elements = ((BaseModelDataImpl)model.getModelData()).elements;
        } else {
            class_793 vanillaModel = model.getAsVanillaModel();
            if (vanillaModel != null) {
                elements = vanillaModel == class_1088.field_5400 ? this.generateItemModel(context, modelStack) : vanillaModel.field_4245;
            }
        }
        if (elements != null && !elements.isEmpty()) {
            for (class_785 element : elements) {
                for (class_2350 direction : element.field_4230.keySet()) {
                    class_783 face = (class_783)element.field_4230.get(direction);
                    class_1058 sprite = context.getTexture(this.resolveMaterial(context::getModel, modelStack, face.field_4224, context.getModelIdentifier()));
                    class_777 quad = FACE_BAKERY.method_3468(element.field_4228, element.field_4231, face, sprite, direction, context.getTransformation(), element.field_4232, element.field_4229, context.getModelIdentifier());
                    class_2350 cullDirection = face.field_4225 != null ? class_2350.method_23225((class_1159)context.getTransformation().method_3509().method_22936(), (class_2350)face.field_4225) : null;
                    Integer lightEmission = element instanceof BaseModelElement ? ((BaseModelElement)element).light_emission : null;
                    output.accept(new BaseModelQuad(quad, cullDirection, lightEmission));
                }
            }
            modelStack.pop();
            return;
        }
        for (class_2960 location : model.getParentModels()) {
            ModelInstance<?> dependency = context.getModel(location);
            if (dependency == null) continue;
            this.bakeQuads(context, dependency, modelStack, output);
        }
        modelStack.removeLast();
    }

    public Set<SpriteIdentifier> gatherTextures(GatherTexturesContext context) {
        HashSet<SpriteIdentifier> textures = new HashSet<SpriteIdentifier>();
        this.gatherTextures(context, ModelInstance.of(DefaultModelTypes.BASE, this), new LinkedList(), textures::add);
        return textures;
    }

    private void gatherTextures(GatherTexturesContext context, ModelInstance<?> model, Deque<ModelInstance<?>> modelStack, Consumer<SpriteIdentifier> output) {
        modelStack.addLast(model);
        List elements = null;
        if (model.getModelType() == DefaultModelTypes.BASE || model.getModelType() == DefaultModelTypes.CONNECTING) {
            elements = ((BaseModelDataImpl)model.getModelData()).elements;
        } else {
            class_793 vanillaModel = model.getAsVanillaModel();
            if (vanillaModel != null) {
                elements = vanillaModel.field_4245;
            }
        }
        if (elements != null && !elements.isEmpty()) {
            for (class_785 element : elements) {
                for (class_2350 direction : element.field_4230.keySet()) {
                    class_783 face = (class_783)element.field_4230.get(direction);
                    SpriteIdentifier sprite = this.resolveMaterial(context::getModel, modelStack, face.field_4224, null);
                    if (sprite.equals(SpriteIdentifier.missing())) continue;
                    output.accept(sprite);
                }
            }
            modelStack.pop();
            return;
        }
        for (class_2960 location : model.getParentModels()) {
            ModelInstance<?> dependency = context.getModel(location);
            if (dependency == null) continue;
            this.gatherTextures(context, dependency, modelStack, output);
        }
        modelStack.removeLast();
    }

    protected SpriteIdentifier resolveMaterial(Function<class_2960, ModelInstance<?>> modelResolver, Deque<ModelInstance<?>> modelStack, String key, class_2960 rootModel) {
        if (key.charAt(0) == '#') {
            key = key.substring(1);
        }
        ArrayList<String> encounteredKeys = new ArrayList<String>();
        encounteredKeys.add(key);
        String currentKey = key;
        while (true) {
            Either either = null;
            for (ModelInstance<?> model2 : modelStack) {
                class_793 vanillaModel = model2.getAsVanillaModel();
                if (vanillaModel == null) continue;
                if (vanillaModel == class_1088.field_5400 && currentKey.equals("particle")) {
                    either = Either.right((Object)"layer0");
                    break;
                }
                either = (Either)vanillaModel.field_4251.get(currentKey);
                if (either == null) continue;
                break;
            }
            if (either == null) {
                String finalCurrentKey = currentKey;
                either = this.findProperty(modelResolver, modelStack.getLast(), model -> {
                    if (model == class_1088.field_5400 && finalCurrentKey.equals("particle")) {
                        return Either.right((Object)"layer0");
                    }
                    return (Either)model.field_4251.get(finalCurrentKey);
                });
            }
            if (either == null) {
                return SpriteIdentifier.missing();
            }
            if (either.left().isPresent()) {
                return SpriteIdentifier.of((class_4730)either.left().get());
            }
            currentKey = (String)either.right().get();
            if (encounteredKeys.contains(currentKey)) {
                FusionClient.LOGGER.warn("Unable to resolve texture due to circular references {}->'{}' in '{}'!", new Object[]{encounteredKeys.stream().map(o -> "'" + o + "'").collect(Collectors.joining("->")), currentKey, rootModel});
                return SpriteIdentifier.missing();
            }
            encounteredKeys.add(currentKey);
        }
    }

    protected List<class_785> generateItemModel(ModelBakingContext context, Deque<ModelInstance<?>> modelStack) {
        ArrayList<class_785> elements = new ArrayList<class_785>();
        for (int layer = 0; layer < class_801.field_4270.size(); ++layer) {
            String layerName = (String)class_801.field_4270.get(layer);
            SpriteIdentifier sprite = this.resolveMaterial(context::getModel, modelStack, layerName, context.getModelIdentifier());
            if (SpriteIdentifier.missing().equals(sprite)) break;
            class_1058 texture = context.getTexture(sprite);
            elements.addAll(class_1088.field_5384.method_3480(layer, layerName, texture));
        }
        return elements;
    }
}

