/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.texture.types.connecting;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.texture.DefaultTextureTypes;
import com.supermartijn642.fusion.api.texture.SpriteCreationContext;
import com.supermartijn642.fusion.api.texture.SpritePreparationContext;
import com.supermartijn642.fusion.api.texture.TextureErrorException;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.texture.data.BaseTextureData;
import com.supermartijn642.fusion.api.texture.data.ConnectingTextureData;
import com.supermartijn642.fusion.api.texture.data.ConnectingTextureLayout;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.texture.types.connecting.ConnectingTextureSprite;
import com.supermartijn642.fusion.texture.types.connecting.layouts.ConnectingTextureLayoutHandler;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.class_1058;
import net.minecraft.class_1079;

public class ConnectingTextureType
implements TextureType<ConnectingTextureData> {
    @Override
    public ConnectingTextureData deserialize(JsonObject json) throws JsonParseException {
        BaseTextureData base = (BaseTextureData)DefaultTextureTypes.BASE.deserialize(json);
        ConnectingTextureData.Builder builder = ConnectingTextureData.builder();
        builder.renderType(base.getRenderType());
        builder.emissive(base.isEmissive());
        builder.tinting(base.getTinting());
        if (json.has("layout")) {
            ConnectingTextureLayout layout;
            if (!json.get("layout").isJsonPrimitive() || !json.getAsJsonPrimitive("layout").isString()) {
                throw new JsonParseException("Property 'layout' must be a string!");
            }
            String layoutString = json.get("layout").getAsString();
            try {
                layout = ConnectingTextureLayout.valueOf(layoutString.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException("Property 'layout' must be one of " + Arrays.toString((Object[])ConnectingTextureLayout.values()).toLowerCase(Locale.ROOT) + ", not '" + layoutString + "'!");
            }
            builder.layout(layout);
        }
        return (ConnectingTextureData)builder.build();
    }

    @Override
    public JsonObject serialize(ConnectingTextureData data) {
        JsonObject json = DefaultTextureTypes.BASE.serialize(data);
        if (data.getLayout() != ConnectingTextureLayout.FULL) {
            json.addProperty("layout", data.getLayout().name().toLowerCase(Locale.ROOT));
        }
        return json.size() == 0 ? null : json;
    }

    @Override
    public Pair<Integer, Integer> getFrameSize(SpritePreparationContext context, ConnectingTextureData data) {
        if (data.getLayout() == ConnectingTextureLayout.FULL && context.getTextureWidth() == context.getTextureHeight()) {
            return Pair.of(context.getTextureWidth(), context.getTextureHeight() * 6 / 8);
        }
        if (context.getAnimationMetadata() != null) {
            Pair<Integer, Integer> frameSize;
            class_1079 animation = context.getAnimationMetadata();
            if (animation.field_5338 != -1 && animation.field_5336 != -1) {
                frameSize = Pair.of(animation.field_5338, animation.field_5336);
            } else if (animation.field_5338 != -1) {
                frameSize = Pair.of(animation.field_5338, context.getTextureHeight());
            } else if (animation.field_5336 != -1) {
                frameSize = Pair.of(context.getTextureWidth(), animation.field_5336);
            } else {
                ConnectingTextureLayoutHandler handler = ConnectingTextureLayoutHandler.get(data.getLayout());
                int height = Math.min(context.getTextureWidth() / handler.getWidth() * handler.getHeight(), context.getTextureHeight());
                frameSize = Pair.of(context.getTextureWidth(), height);
            }
            if (context.getTextureWidth() % frameSize.left() != 0 || context.getTextureHeight() % frameSize.right() != 0) {
                throw new TextureErrorException("Image size " + context.getTextureWidth() + "x" + context.getTextureHeight() + " is not a multiple of frame size " + String.valueOf(frameSize.left()) + "x" + String.valueOf(frameSize.right()) + "!");
            }
            return frameSize;
        }
        return Pair.of(context.getTextureWidth(), context.getTextureHeight());
    }

    @Override
    public class_1058 createSprite(SpriteCreationContext context, ConnectingTextureData data) {
        ConnectingTextureLayoutHandler layoutHandler = ConnectingTextureLayoutHandler.get(data.getLayout());
        class_1058 sprite = context.createOriginalSprite();
        float startU = sprite.field_5270;
        float startV = sprite.field_5268;
        float tileWidth = (sprite.field_5269 - sprite.field_5270) / (float)layoutHandler.getWidth();
        float tileHeight = (sprite.field_5267 - sprite.field_5268) / (float)layoutHandler.getHeight();
        sprite.field_5269 = sprite.field_5270 + tileWidth * (float)(layoutHandler.defaultTileX() + 1);
        sprite.field_5267 = sprite.field_5268 + tileHeight * (float)(layoutHandler.defaultTileY() + 1);
        sprite.field_5270 += tileWidth * (float)layoutHandler.defaultTileX();
        sprite.field_5268 += tileHeight * (float)layoutHandler.defaultTileY();
        return new ConnectingTextureSprite(sprite, data, startU, startV);
    }
}

