/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.modifiers.block;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.model.modifiers.block.BlockModelModifierBakedModel;
import com.supermartijn642.fusion.model.modifiers.block.PaneCullingBakedModel;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelDiscovery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockModelModifierReloadListener
implements PreparableReloadListener {
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    private static final String LOCATION = "fusion/model_modifiers/blocks";
    public static final BlockModelModifierReloadListener INSTANCE = new BlockModelModifierReloadListener();
    private final Map<ModelResourceLocation, Properties> models = new HashMap<ModelResourceLocation, Properties>();

    private BlockModelModifierReloadListener() {
    }

    public void registerOverlays(UnbakedModel.Resolver resolver, ModelDiscovery modelDiscovery) {
        HashSet<ResourceLocation> models = new HashSet<ResourceLocation>();
        for (Properties properties : this.models.values()) {
            models.addAll(properties.appendModels);
        }
        for (ResourceLocation model : models) {
            UnbakedModel unbakedModel = resolver.resolve(model);
            modelDiscovery.registerTopModel(BlockModelModifierReloadListener.overlayModelLocation(model), unbakedModel);
            unbakedModel.resolveDependencies(resolver);
        }
    }

    public void applyOverlays(ModelBakery bakery) {
        Map bakedModels = bakery.getBakedTopLevelModels();
        for (Map.Entry<ModelResourceLocation, Properties> entry : this.models.entrySet()) {
            ModelResourceLocation target = entry.getKey();
            BakedModel targetModel = (BakedModel)bakedModels.get(target);
            Properties properties = entry.getValue();
            List<ResourceLocation> overlays = properties.appendModels;
            List<BakedModel> overlayModels = overlays.stream().map(BlockModelModifierReloadListener::overlayModelLocation).map(bakedModels::get).toList();
            Object model = new BlockModelModifierBakedModel(targetModel, overlayModels);
            if (properties.paneCullingFix) {
                model = new PaneCullingBakedModel((BakedModel)model);
            }
            bakedModels.put(target, model);
        }
    }

    private static ModelResourceLocation overlayModelLocation(ResourceLocation modelLocation) {
        return new ModelResourceLocation(modelLocation, "fusion_overlay_model");
    }

    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier barrier, ResourceManager resourceManager, Executor executor, Executor executor2) {
        return CompletableFuture.runAsync(() -> this.reload(resourceManager), executor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)barrier).wait(arg_0));
    }

    private void reload(ResourceManager resourceManager) {
        this.models.clear();
        HashMap resources = new HashMap();
        SimpleJsonResourceReloadListener.scanDirectory((ResourceManager)resourceManager, (String)LOCATION, (DynamicOps)JsonOps.INSTANCE, (Codec)new Codec<JsonElement>(this){

            public <T> DataResult<Pair<JsonElement, T>> decode(DynamicOps<T> ops, T input) {
                return DataResult.success((Object)Pair.of((Object)((JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input)), input));
            }

            public <T> DataResult<T> encode(JsonElement input, DynamicOps<T> ops, T prefix) {
                return DataResult.success((Object)JsonOps.INSTANCE.convertTo(ops, input));
            }
        }, resources);
        for (Map.Entry entry : resources.entrySet()) {
            ResourceLocation location = (ResourceLocation)entry.getKey();
            if (!((JsonElement)entry.getValue()).isJsonObject()) {
                throw new IllegalArgumentException("Block model overlay '" + String.valueOf(location) + "' must contain a json object!");
            }
            JsonObject json = ((JsonElement)entry.getValue()).getAsJsonObject();
            try {
                this.parseResource(json);
            }
            catch (JsonParseException e) {
                FusionClient.LOGGER.error("Failed to parse block model overlay '{}': {}", (Object)location, (Object)e.getMessage());
            }
        }
    }

    private void parseResource(JsonObject json) {
        if (!json.has("targets") || !json.get("targets").isJsonArray()) {
            throw new JsonParseException("Model overlay must have array property 'targets'!");
        }
        JsonArray targetsJson = json.getAsJsonArray("targets");
        HashSet targets = new HashSet();
        for (JsonElement element : targetsJson) {
            if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                if (!IdentifierUtil.isValidIdentifier(element.getAsString())) {
                    throw new JsonParseException("Target must be a valid identifier, not '" + element.getAsString() + "'!!");
                }
                ResourceLocation identifier = ResourceLocation.parse((String)element.getAsString());
                Optional block = BuiltInRegistries.BLOCK.getOptional(identifier);
                if (block.isEmpty()) {
                    throw new JsonParseException("Could not find a block for model overlay target '" + String.valueOf(identifier) + "'!");
                }
                ((Block)block.get()).getStateDefinition().getPossibleStates().stream().map(BlockModelShaper::stateToModelLocation).forEach(targets::add);
                continue;
            }
            if (element.isJsonObject()) {
                this.parseTarget(element.getAsJsonObject()).map(BlockModelShaper::stateToModelLocation).forEach(targets::add);
                continue;
            }
            throw new JsonParseException("Model overlay 'targets' array must only contain objects and strings!");
        }
        if (targets.isEmpty()) {
            return;
        }
        if (!json.has("append") && !json.has("pane_culling_fix")) {
            throw new JsonParseException("Must have either 'append' or 'pane_culling_fix' property!");
        }
        LinkedHashSet<ResourceLocation> models = new LinkedHashSet<ResourceLocation>();
        if (json.has("append")) {
            if (!json.get("append").isJsonArray()) {
                throw new JsonParseException("Property 'append' must be an array!");
            }
            JsonArray appendJson = json.getAsJsonArray("append");
            for (JsonElement element : appendJson) {
                if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                    throw new JsonParseException("Array property 'append' must only contain strings!");
                }
                if (!IdentifierUtil.isValidIdentifier(element.getAsString())) {
                    throw new JsonParseException("Model must be a valid identifier, not '" + element.getAsString() + "'!!");
                }
                models.add(ResourceLocation.parse((String)element.getAsString()));
            }
        }
        boolean paneCullingFix = false;
        if (json.has("pane_culling_fix")) {
            if (!json.get("pane_culling_fix").isJsonPrimitive() || !json.getAsJsonPrimitive("pane_culling_fix").isBoolean()) {
                throw new JsonParseException("Property 'pane_culling_fix' must be a boolean!");
            }
            paneCullingFix = json.get("pane_culling_fix").getAsBoolean();
        }
        if (models.isEmpty() && !paneCullingFix) {
            return;
        }
        for (ModelResourceLocation target : targets) {
            Properties properties = this.models.computeIfAbsent(target, t -> new Properties());
            properties.appendModels.addAll(models);
            properties.paneCullingFix = paneCullingFix;
        }
    }

    private Stream<BlockState> parseTarget(JsonObject json) {
        if (!(json.has("block") && json.get("block").isJsonPrimitive() && json.getAsJsonPrimitive("block").isString())) {
            throw new JsonParseException("Target must have string property 'block'!");
        }
        if (!IdentifierUtil.isValidIdentifier(json.get("block").getAsString())) {
            throw new JsonParseException("Target property 'block' must be a valid identifier, not '" + json.get("block").getAsString() + "'!!");
        }
        ResourceLocation identifier = ResourceLocation.parse((String)json.get("block").getAsString());
        Optional optional = BuiltInRegistries.BLOCK.getOptional(identifier);
        if (optional.isEmpty()) {
            throw new JsonParseException("Could not find a block for model overlay target '" + String.valueOf(identifier) + "'!");
        }
        Block block = (Block)optional.get();
        HashMap<Property, ImmutableSet> properties = new HashMap<Property, ImmutableSet>();
        if (!json.has("properties") || !json.get("properties").isJsonObject()) {
            throw new JsonParseException("Match block predicate must have object property 'properties'!");
        }
        if (json.getAsJsonObject("properties").isEmpty()) {
            throw new JsonParseException("At least one property must be specified for match state predicate!");
        }
        for (Map.Entry entry : json.getAsJsonObject("properties").entrySet()) {
            Property property = block.getStateDefinition().getProperty((String)entry.getKey());
            if (property == null) {
                throw new JsonParseException("Block '" + String.valueOf(identifier) + "' does not have a property named '" + (String)entry.getKey() + "'!");
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (((JsonElement)entry.getValue()).isJsonPrimitive() && ((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                Optional value = property.getValue(((JsonElement)entry.getValue()).getAsString());
                if (value.isEmpty()) {
                    throw new JsonParseException("Unknown value '" + ((JsonElement)entry.getValue()).getAsString() + "' for property '" + property.getName() + "' in block '" + String.valueOf(identifier) + "'!");
                }
                builder.add(value.get());
            } else if (((JsonElement)entry.getValue()).isJsonArray()) {
                if (((JsonElement)entry.getValue()).getAsJsonArray().isEmpty()) {
                    throw new JsonParseException("Valid values for property '" + property.getName() + "' cannot be empty!");
                }
                for (JsonElement element : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                    if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                        throw new JsonParseException("Property '" + (String)entry.getKey() + "' must be a string or an array of strings!");
                    }
                    Optional value = property.getValue(element.getAsString());
                    if (value.isEmpty()) {
                        throw new JsonParseException("Unknown value '" + element.getAsString() + "' for property '" + property.getName() + "' in block '" + String.valueOf(identifier) + "'!");
                    }
                    builder.add(value.get());
                }
            } else {
                throw new JsonParseException("Property '" + (String)entry.getKey() + "' must be a string or an array of strings!");
            }
            properties.put(property, builder.build());
        }
        Stream<Object> states = Stream.of((BlockState)block.getStateDefinition().any());
        for (Property property : block.getStateDefinition().getProperties()) {
            if (properties.containsKey(property)) {
                Set values = (Set)properties.get(property);
                states = states.flatMap(state -> values.stream().map(value -> BlockModelModifierReloadListener.stateWithValue(state, property, value)));
                continue;
            }
            states = states.flatMap(state -> property.getAllValues().map(value -> BlockModelModifierReloadListener.stateWithValue(state, property, value.value())));
        }
        return states;
    }

    private static <T extends Comparable<T>> BlockState stateWithValue(BlockState state, Property<?> property, Object value) {
        return (BlockState)state.setValue(property, (Comparable)value);
    }

    public String getName() {
        return "Fusion Block Model Overlay Reload Listener";
    }

    private static class Properties {
        final List<ResourceLocation> appendModels = new ArrayList<ResourceLocation>();
        boolean paneCullingFix;

        private Properties() {
        }
    }
}

