/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.base;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.ModelBakingContext;
import com.supermartijn642.fusion.api.model.ModelType;
import com.supermartijn642.fusion.api.model.data.BaseModelData;
import com.supermartijn642.fusion.model.types.base.BaseBakedModel;
import com.supermartijn642.fusion.model.types.base.BaseModelDataImpl;
import com.supermartijn642.fusion.model.types.base.BaseModelElement;
import com.supermartijn642.fusion.model.types.base.BaseModelQuad;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedOverrides;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.SpecialModels;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import org.jetbrains.annotations.Nullable;

public class BaseModelType
implements ModelType<BaseModelData> {
    @Override
    public Collection<ResourceLocation> getModelDependencies(BaseModelData data) {
        return data.getParents();
    }

    @Override
    @Nullable
    public BlockModel getAsVanillaModel(BaseModelData data) {
        return data.getVanillaModel();
    }

    @Override
    public List<ResourceLocation> getParentModels(BaseModelData data) {
        return data.getParents();
    }

    @Override
    public BakedModel bake(ModelBakingContext context, BaseModelData data) {
        ((BaseModelDataImpl)data).validateParents(context);
        List<BaseModelQuad> quads = ((BaseModelDataImpl)data).bakeQuads(context);
        boolean ambientOcclusion = ((BaseModelDataImpl)data).findProperty(context, model -> model.hasAmbientOcclusion, true);
        boolean isGui3d = ((BaseModelDataImpl)data).findProperty(context, model -> model == SpecialModels.GENERATED_MARKER ? Boolean.valueOf(false) : null, true);
        boolean usesBlockLight = ((BaseModelDataImpl)data).findProperty(context, model -> model.guiLight, BlockModel.GuiLight.SIDE).lightLikeBlock();
        TextureAtlasSprite particleSprite = context.getTexture(((BaseModelDataImpl)data).findParticleSprite(context));
        ItemTransform transformThirdPersonLeftHand = ((BaseModelDataImpl)data).findProperty(context, model -> model.transforms.hasTransform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND) ? model.transforms.getTransform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND) : null, ItemTransform.NO_TRANSFORM);
        ItemTransform transformThirdPersonRightHand = ((BaseModelDataImpl)data).findProperty(context, model -> model.transforms.hasTransform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) ? model.transforms.getTransform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) : null, ItemTransform.NO_TRANSFORM);
        ItemTransform transformFirstPersonLeftHand = ((BaseModelDataImpl)data).findProperty(context, model -> model.transforms.hasTransform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND) ? model.transforms.getTransform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND) : null, ItemTransform.NO_TRANSFORM);
        ItemTransform transformFirstPersonRightHand = ((BaseModelDataImpl)data).findProperty(context, model -> model.transforms.hasTransform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) ? model.transforms.getTransform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) : null, ItemTransform.NO_TRANSFORM);
        ItemTransform transformHead = ((BaseModelDataImpl)data).findProperty(context, model -> model.transforms.hasTransform(ItemDisplayContext.HEAD) ? model.transforms.getTransform(ItemDisplayContext.HEAD) : null, ItemTransform.NO_TRANSFORM);
        ItemTransform transformGui = ((BaseModelDataImpl)data).findProperty(context, model -> model.transforms.hasTransform(ItemDisplayContext.GUI) ? model.transforms.getTransform(ItemDisplayContext.GUI) : null, ItemTransform.NO_TRANSFORM);
        ItemTransform transformGround = ((BaseModelDataImpl)data).findProperty(context, model -> model.transforms.hasTransform(ItemDisplayContext.GROUND) ? model.transforms.getTransform(ItemDisplayContext.GROUND) : null, ItemTransform.NO_TRANSFORM);
        ItemTransform transformFixed = ((BaseModelDataImpl)data).findProperty(context, model -> model.transforms.hasTransform(ItemDisplayContext.FIXED) ? model.transforms.getTransform(ItemDisplayContext.FIXED) : null, ItemTransform.NO_TRANSFORM);
        ItemTransforms itemTransforms = new ItemTransforms(transformThirdPersonLeftHand, transformThirdPersonRightHand, transformFirstPersonLeftHand, transformFirstPersonRightHand, transformHead, transformGui, transformGround, transformFixed);
        BakedOverrides itemOverrides = data.getVanillaModel().overrides.isEmpty() ? BakedOverrides.EMPTY : new BakedOverrides(context.getModelBaker(), data.getVanillaModel().overrides);
        return new BaseBakedModel(quads, ambientOcclusion, isGui3d, usesBlockLight, particleSprite, itemTransforms, itemOverrides);
    }

    @Override
    public BaseModelData deserialize(JsonObject json) throws JsonParseException {
        BlockModel model = (BlockModel)DefaultModelTypes.VANILLA.deserialize(json);
        if (json.has("parent") && json.has("parents")) {
            throw new JsonParseException("Model can only have either 'parent' or 'parents', not both!");
        }
        List<ResourceLocation> parents = List.of();
        if (json.has("parent")) {
            if (!json.get("parent").isJsonPrimitive() || !json.get("parent").getAsJsonPrimitive().isString()) {
                throw new JsonParseException("Property 'parent' must be a string!");
            }
            String parent = json.get("parent").getAsString();
            if (!IdentifierUtil.isValidIdentifier(parent)) {
                throw new JsonParseException("Property 'parent' must be a valid identifier!");
            }
            parents = List.of(ResourceLocation.parse((String)parent));
        } else if (json.has("parents")) {
            if (!json.get("parents").isJsonArray()) {
                throw new JsonParseException("Property 'parents' must be an array!");
            }
            JsonArray parentArray = json.getAsJsonArray("parents");
            parents = new ArrayList(parentArray.size());
            for (JsonElement element2 : parentArray) {
                if (!element2.isJsonPrimitive() || !element2.getAsJsonPrimitive().isString()) {
                    throw new JsonParseException("Array 'parents' must only contain strings!");
                }
                String parent = element2.getAsString();
                if (!IdentifierUtil.isValidIdentifier(parent)) {
                    throw new JsonParseException("Array 'parents' must only contain valid identifiers, not '" + parent + "'!");
                }
                parents.add(ResourceLocation.parse((String)parent));
            }
            if (!parents.isEmpty()) {
                model.parentLocation = parents.get(0);
            }
        }
        ArrayList<BaseModelElement> elements = new ArrayList<BaseModelElement>(model.elements.size());
        model.elements.forEach(element -> elements.add(new BaseModelElement(element.from, element.to, element.faces, element.rotation, element.shade, element.lightEmission)));
        return new BaseModelDataImpl(model, parents, elements);
    }

    @Override
    public JsonObject serialize(BaseModelData value) {
        JsonObject json = DefaultModelTypes.VANILLA.serialize(value.getVanillaModel());
        if (value.getParents().size() > 1) {
            json.remove("parent");
            JsonArray parents = new JsonArray(value.getParents().size());
            value.getParents().forEach(p -> parents.add(p.toString()));
            json.add("parents", (JsonElement)parents);
        }
        return json;
    }
}

