/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.api.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.supermartijn642.fusion.api.model.FusionModelTypeRegistry;
import com.supermartijn642.fusion.api.model.ModelInstance;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

public abstract class FusionModelProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private final Map<ResourceLocation, ModelInstance<?>> models = new HashMap();
    private final String modName;
    private final DataGenerator generator;
    private final ExistingFileHelper existingFileHelper;

    public FusionModelProvider(String modid, DataGenerator generator, ExistingFileHelper existingFileHelper) {
        this.modName = ModList.get().getModContainerById(modid).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse(modid);
        this.generator = generator;
        this.existingFileHelper = existingFileHelper;
    }

    @Deprecated
    public FusionModelProvider(String modid, DataGenerator generator) {
        this(modid, generator, null);
    }

    public final void func_200398_a(DirectoryCache cache) throws IOException {
        this.generate();
        Path output = this.generator.func_200391_b();
        for (Map.Entry<ResourceLocation, ModelInstance<?>> entry : this.models.entrySet()) {
            ResourceLocation location = entry.getKey();
            ModelInstance<?> model = entry.getValue();
            String extension = location.func_110623_a().lastIndexOf(".") > location.func_110623_a().lastIndexOf("/") ? "" : ".json";
            Path path = Paths.get("assets", location.func_110624_b(), "models", location.func_110623_a() + extension);
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)FusionModelTypeRegistry.serializeModelData(model), (Path)output.resolve(path));
        }
    }

    protected abstract void generate();

    public final void addModel(ResourceLocation location, ModelInstance<?> model) {
        ModelInstance<?> previousValue = this.models.put(location, model);
        if (previousValue != null) {
            throw new RuntimeException("Duplicate model for '" + location + "'!");
        }
        if (this.existingFileHelper != null) {
            this.existingFileHelper.trackGenerated(location, ResourcePackType.CLIENT_RESOURCES, ".json", "models");
        }
    }

    public String func_200397_b() {
        return "Fusion Model Provider: " + this.modName;
    }
}

