/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.api.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.fusion.api.texture.FusionTextureTypeRegistry;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.util.Pair;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

public abstract class FusionTextureMetadataProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private final Map<ResourceLocation, Pair<TextureType<Object>, Object>> metadata = new HashMap<ResourceLocation, Pair<TextureType<Object>, Object>>();
    private final String modName;
    private final DataGenerator generator;

    public FusionTextureMetadataProvider(String modid, DataGenerator generator) {
        this.modName = ModList.get().getModContainerById(modid).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse(modid);
        this.generator = generator;
    }

    public final void func_200398_a(DirectoryCache cache) throws IOException {
        this.generate();
        Path output = this.generator.func_200391_b();
        for (Map.Entry<ResourceLocation, Pair<TextureType<Object>, Object>> entry : this.metadata.entrySet()) {
            ResourceLocation location = entry.getKey();
            Pair<TextureType<Object>, Object> metadata = entry.getValue();
            String extension = location.func_110623_a().endsWith(".mcmeta") ? "" : (location.func_110623_a().lastIndexOf(46) > location.func_110623_a().lastIndexOf(47) ? ".mcmeta" : ".png.mcmeta");
            Path path = Paths.get("assets", location.func_110624_b(), "textures", location.func_110623_a() + extension);
            JsonObject json = new JsonObject();
            json.add("fusion", (JsonElement)FusionTextureTypeRegistry.serializeTextureData(metadata.left(), metadata.right()));
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)json, (Path)output.resolve(path));
        }
    }

    protected abstract void generate();

    public final <T> void addTextureMetadata(ResourceLocation location, TextureType<T> textureType, T data) {
        Pair<TextureType<T>, T> previousValue = this.metadata.put(location, Pair.of(textureType, data));
        if (previousValue != null) {
            throw new RuntimeException("Duplicate texture metadata for '" + location + "'!");
        }
    }

    public String func_200397_b() {
        return "Fusion Texture Metadata Provider: " + this.modName;
    }
}

