/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.mojang.datafixers.util.Pair;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.texture.TextureErrorException;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.extensions.TextureAtlasSpriteExtension;
import com.supermartijn642.fusion.texture.FusionTextureMetadataSection;
import com.supermartijn642.fusion.texture.SpriteCreationContextImpl;
import com.supermartijn642.fusion.texture.SpritePreparationContextImpl;
import com.supermartijn642.fusion.texture.TextureTypeRegistryImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={AtlasTexture.class}, priority=900)
public class TextureAtlasMixin {
    @Unique
    private final Map<ResourceLocation, com.supermartijn642.fusion.api.util.Pair<TextureType<Object>, Object>> fusionTextureMetadata = new HashMap<ResourceLocation, com.supermartijn642.fusion.api.util.Pair<TextureType<Object>, Object>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"lambda$getBasicSpriteInfos$2(Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/resources/IResourceManager;Ljava/util/concurrent/ConcurrentLinkedQueue;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/resources/data/AnimationMetadataSection;getFrameSize(II)Lcom/mojang/datafixers/util/Pair;", shift=At.Shift.BEFORE)}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private void gatherMetadata(ResourceLocation identifier, IResourceManager resourceManager, ConcurrentLinkedQueue<TextureAtlasSprite.Info> queue, CallbackInfo ci, ResourceLocation location, IResource resource, Object object, PngSizeInfo pngInfo, AnimationMetadataSection animationMetadata) {
        com.supermartijn642.fusion.api.util.Pair metadata = (com.supermartijn642.fusion.api.util.Pair)resource.func_199028_a((IMetadataSectionSerializer)FusionTextureMetadataSection.INSTANCE);
        if (metadata != null) {
            com.supermartijn642.fusion.api.util.Pair<Integer, Integer> newSize;
            Map<ResourceLocation, com.supermartijn642.fusion.api.util.Pair<TextureType<Object>, Object>> map = this.fusionTextureMetadata;
            synchronized (map) {
                this.fusionTextureMetadata.put(identifier, metadata);
            }
            Pair originalSize = animationMetadata.func_229304_c_(pngInfo.field_188533_a, pngInfo.field_188534_b);
            try {
                newSize = ((TextureType)metadata.left()).getFrameSize(new SpritePreparationContextImpl((Integer)originalSize.getFirst(), (Integer)originalSize.getSecond(), pngInfo.field_188533_a, pngInfo.field_188534_b, identifier, animationMetadata), metadata.right());
            }
            catch (TextureErrorException e) {
                FusionClient.LOGGER.error("Error for texture '{}': {}", (Object)identifier, (Object)e.getMessage());
                ci.cancel();
                return;
            }
            catch (Exception e) {
                throw new RuntimeException("Encountered an exception whilst getting frame size from texture type '" + TextureTypeRegistryImpl.getIdentifier((TextureType)metadata.left()) + "' for texture '" + location + "'!", e);
            }
            if (newSize == null) {
                throw new RuntimeException("Received null frame size from texture type '" + TextureTypeRegistryImpl.getIdentifier((TextureType)metadata.left()) + "' for texture '" + location + "'!");
            }
            queue.add(new TextureAtlasSprite.Info(identifier, newSize.left().intValue(), newSize.right().intValue(), animationMetadata));
            ci.cancel();
        }
    }

    @Inject(method={"getLoadedSprites(Lnet/minecraft/resources/IResourceManager;Lnet/minecraft/client/renderer/texture/Stitcher;I)Ljava/util/List;"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void getLoadedSprites(IResourceManager resourceManager, Stitcher stitcher, int i, CallbackInfoReturnable<List<TextureAtlasSprite>> ci) {
        List textures = (List)ci.getReturnValue();
        if (textures != null) {
            for (int index = 0; index < textures.size(); ++index) {
                TextureAtlasSprite newTexture;
                TextureAtlasSprite texture = (TextureAtlasSprite)textures.get(index);
                com.supermartijn642.fusion.api.util.Pair<TextureType<Object>, Object> textureData = this.fusionTextureMetadata.get(texture.func_195668_m());
                if (textureData == null) continue;
                try (SpriteCreationContextImpl context = new SpriteCreationContextImpl(texture);){
                    newTexture = textureData.left().createSprite(context, textureData.right());
                }
                catch (Exception e) {
                    throw new RuntimeException("Encountered an exception whilst initialising texture '" + texture.func_195668_m() + "' for texture type '" + TextureTypeRegistryImpl.getIdentifier(textureData.left()) + "'!", e);
                }
                if (newTexture == null) {
                    throw new RuntimeException("Received null texture from texture type '" + TextureTypeRegistryImpl.getIdentifier(textureData.left()) + "' for texture '" + texture.func_195668_m() + "'!");
                }
                ((TextureAtlasSpriteExtension)newTexture).setFusionTextureType(textureData.left());
                textures.set(index, newTexture);
            }
        }
        this.fusionTextureMetadata.clear();
    }
}

