/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin.modernfix;

import com.google.common.collect.Lists;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.extensions.ResourceMetadataExtension;
import com.supermartijn642.fusion.extensions.TextureAtlasSpriteExtension;
import com.supermartijn642.fusion.texture.FusionTextureMetadataSection;
import com.supermartijn642.fusion.texture.SpriteCreationContextImpl;
import com.supermartijn642.fusion.texture.SpritePreparationContextImpl;
import com.supermartijn642.fusion.texture.TextureTypeRegistryImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={AtlasTexture.class}, priority=900)
public class TextureAtlasMixinModernFix {
    @Unique
    private final Map<ResourceLocation, Pair<TextureType<Object>, Object>> fusionTextureMetadata = new HashMap<ResourceLocation, Pair<TextureType<Object>, Object>>();

    @Shadow
    private ResourceLocation func_195420_b(ResourceLocation location) {
        throw new AssertionError();
    }

    @Inject(method={"getBasicSpriteInfos(Lnet/minecraft/resources/IResourceManager;Ljava/util/Set;)Ljava/util/Collection;"}, at={@At(value="RETURN")})
    private void gatherMetadata(IResourceManager resourceManager, Set<ResourceLocation> sprites, CallbackInfoReturnable<Collection<TextureAtlasSprite.Info>> ci) {
        Collection spriteInfos = (Collection)ci.getReturnValue();
        ArrayList tasks = Lists.newArrayList();
        for (TextureAtlasSprite.Info info : spriteInfos) {
            tasks.add(CompletableFuture.runAsync(() -> {
                block20: {
                    ResourceLocation location = this.func_195420_b(info.func_229248_a_());
                    try (IResource resource = resourceManager.func_199002_a(location);){
                        Pair<Integer, Integer> newSize;
                        if (resource == null) break block20;
                        ((ResourceMetadataExtension)resource).disableFusionOverwrite();
                        Pair metadata = (Pair)resource.func_199028_a((IMetadataSectionSerializer)FusionTextureMetadataSection.INSTANCE);
                        if (metadata == null) break block20;
                        Map<ResourceLocation, Pair<TextureType<Object>, Object>> map = this.fusionTextureMetadata;
                        synchronized (map) {
                            this.fusionTextureMetadata.put(info.func_229248_a_(), metadata);
                        }
                        AnimationMetadataSection animationMetadata = (AnimationMetadataSection)resource.func_199028_a((IMetadataSectionSerializer)AnimationMetadataSection.field_195817_a);
                        try {
                            newSize = ((TextureType)metadata.left()).getFrameSize(new SpritePreparationContextImpl(info.func_229250_b_(), info.func_229252_c_(), info.func_229250_b_(), info.func_229252_c_(), info.func_229248_a_(), animationMetadata), metadata.right());
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Encountered an exception whilst getting frame size from texture type '" + TextureTypeRegistryImpl.getIdentifier((TextureType)metadata.left()) + "' for texture '" + location + "'!", e);
                        }
                        if (newSize == null) {
                            throw new RuntimeException("Received null frame size from texture type '" + TextureTypeRegistryImpl.getIdentifier((TextureType)metadata.left()) + "' for texture '" + location + "'!");
                        }
                        info.field_229247_d_ = animationMetadata == null ? AnimationMetadataSection.field_229300_b_ : animationMetadata;
                        info.field_229245_b_ = newSize.left();
                        info.field_229246_c_ = newSize.right();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }, Util.func_215072_e()));
        }
        CompletableFuture.allOf(tasks.toArray(new CompletableFuture[0])).join();
    }

    @Inject(method={"getLoadedSprites(Lnet/minecraft/resources/IResourceManager;Lnet/minecraft/client/renderer/texture/Stitcher;I)Ljava/util/List;"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void getLoadedSprites(IResourceManager resourceManager, Stitcher stitcher, int i, CallbackInfoReturnable<List<TextureAtlasSprite>> ci) {
        List textures = (List)ci.getReturnValue();
        if (textures != null) {
            for (int index = 0; index < textures.size(); ++index) {
                TextureAtlasSprite newTexture;
                TextureAtlasSprite texture = (TextureAtlasSprite)textures.get(index);
                Pair<TextureType<Object>, Object> textureData = this.fusionTextureMetadata.get(texture.func_195668_m());
                if (textureData == null) continue;
                try (SpriteCreationContextImpl context = new SpriteCreationContextImpl(texture);){
                    newTexture = textureData.left().createSprite(context, textureData.right());
                }
                catch (Exception e) {
                    throw new RuntimeException("Encountered an exception whilst initialising texture '" + texture.func_195668_m() + "' for texture type '" + TextureTypeRegistryImpl.getIdentifier(textureData.left()) + "'!", e);
                }
                if (newTexture == null) {
                    throw new RuntimeException("Received null texture from texture type '" + TextureTypeRegistryImpl.getIdentifier(textureData.left()) + "' for texture '" + texture.func_195668_m() + "'!");
                }
                ((TextureAtlasSpriteExtension)newTexture).setFusionTextureType(textureData.left());
                textures.set(index, newTexture);
            }
        }
        this.fusionTextureMetadata.clear();
    }
}

