/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.modifiers.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import com.supermartijn642.fusion.model.types.base.CustomRenderTypeBakedModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class BlockModelModifierBakedModel
implements IBakedModel,
CustomRenderTypeBakedModel {
    private static final ModelProperty<IModelData[]> DATA_PROPERTY = new ModelProperty();
    private final IBakedModel original;
    private final List<IBakedModel> models;
    private final boolean hasNonSimpleModels;
    private final List<IBakedModel> nonSimpleModels;
    private final List<BakedQuad> quads;
    private final List<BakedQuad>[] culledQuads = new List[6];
    private final Set<RenderType> customBlockRenderTypes;
    private final boolean hasLayeredModels;

    public BlockModelModifierBakedModel(IBakedModel original, List<IBakedModel> models) {
        this.original = original;
        this.models = new ArrayList<IBakedModel>(models.size() + 1);
        this.models.add(original);
        this.models.addAll(models);
        ArrayList<IBakedModel> nonSimpleModels = new ArrayList<IBakedModel>();
        ArrayList quads = new ArrayList();
        List[] culledQuads = (List[])IntStream.range(0, 6).mapToObj(i -> new ArrayList()).toArray(List[]::new);
        HashSet<RenderType> customBlockRenderTypes = new HashSet<RenderType>();
        boolean hasLayeredModels = false;
        Random random = new Random();
        for (IBakedModel model : this.models) {
            if (!model.getClass().equals(SimpleBakedModel.class)) {
                nonSimpleModels.add(model);
                if (model instanceof CustomRenderTypeBakedModel) {
                    customBlockRenderTypes.addAll(((CustomRenderTypeBakedModel)model).getBlockRenderTypes());
                }
                if (!model.isLayered()) continue;
                hasLayeredModels = true;
                continue;
            }
            quads.addAll(model.func_200117_a(null, null, random));
            for (Direction side : Direction.values()) {
                culledQuads[side.ordinal()].addAll(model.func_200117_a(null, side, random));
            }
        }
        this.hasNonSimpleModels = !nonSimpleModels.isEmpty();
        this.nonSimpleModels = nonSimpleModels.isEmpty() ? null : ImmutableList.copyOf(nonSimpleModels);
        this.quads = ImmutableList.copyOf(quads);
        for (Direction side : Direction.values()) {
            this.culledQuads[side.ordinal()] = ImmutableList.copyOf((Collection)culledQuads[side.ordinal()]);
        }
        this.customBlockRenderTypes = ImmutableSet.copyOf(customBlockRenderTypes);
        this.hasLayeredModels = hasLayeredModels;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random random, @Nonnull IModelData data) {
        if (!this.hasNonSimpleModels) {
            return side == null ? this.quads : this.culledQuads[side.ordinal()];
        }
        IModelData[] arr = (IModelData[])data.getData(DATA_PROPERTY);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(side == null ? this.quads : this.culledQuads[side.ordinal()]);
        for (int i = 0; i < this.nonSimpleModels.size(); ++i) {
            quads.addAll(this.nonSimpleModels.get(i).getQuads(state, side, random, (IModelData)(arr == null || arr[i] == null ? EmptyModelData.INSTANCE : arr[i])));
        }
        return quads;
    }

    @Nonnull
    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random random) {
        if (!this.hasNonSimpleModels) {
            return side == null ? this.quads : this.culledQuads[side.ordinal()];
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(side == null ? this.quads : this.culledQuads[side.ordinal()]);
        for (IBakedModel model : this.nonSimpleModels) {
            quads.addAll(model.func_200117_a(state, side, random));
        }
        return quads;
    }

    @Override
    public Collection<RenderType> getBlockRenderTypes() {
        return this.customBlockRenderTypes;
    }

    public boolean isLayered() {
        return this.hasLayeredModels;
    }

    public List<Pair<IBakedModel, RenderType>> getLayerModels(ItemStack stack, boolean fabulous) {
        ArrayList<Pair<IBakedModel, RenderType>> layers = new ArrayList<Pair<IBakedModel, RenderType>>(this.models.size());
        for (IBakedModel model : this.models) {
            layers.addAll(model.getLayerModels(stack, fabulous));
        }
        return layers;
    }

    public IModelData getModelData(IBlockDisplayReader level, BlockPos pos, BlockState state, IModelData data) {
        if (!this.hasNonSimpleModels) {
            return data;
        }
        IModelData[] arr = new IModelData[this.nonSimpleModels.size()];
        for (int i = 0; i < this.nonSimpleModels.size(); ++i) {
            arr[i] = this.nonSimpleModels.get(i).getModelData(level, pos, state, data);
        }
        return new ModelDataMap.Builder().withInitial(DATA_PROPERTY, (Object)arr).build();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.original.func_177552_f();
    }

    public boolean func_177555_b() {
        return this.original.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.original.func_177556_c();
    }

    public boolean func_230044_c_() {
        return this.original.func_230044_c_();
    }

    public boolean func_188618_c() {
        return this.original.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.original.func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        return this.original.func_188617_f();
    }

    public boolean isAmbientOcclusion(BlockState state) {
        return this.original.isAmbientOcclusion(state);
    }

    public boolean doesHandlePerspectives() {
        return this.original.doesHandlePerspectives();
    }

    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType transformType, MatrixStack poseStack) {
        return this.original.handlePerspective(transformType, poseStack);
    }

    public TextureAtlasSprite getParticleTexture(@Nonnull IModelData data) {
        return this.original.getParticleTexture(data);
    }
}

