/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.modifiers.block;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.model.modifiers.block.BlockModelModifierBakedModel;
import com.supermartijn642.fusion.model.modifiers.block.PaneCullingBakedModel;
import com.supermartijn642.fusion.model.types.base.CustomRenderTypeBakedModel;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.state.Property;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class BlockModelModifierReloadListener {
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    private static final String LOCATION = "fusion/model_modifiers/blocks";
    public static final BlockModelModifierReloadListener INSTANCE = new BlockModelModifierReloadListener();
    private final Map<ModelResourceLocation, Properties> models = new HashMap<ModelResourceLocation, Properties>();

    private BlockModelModifierReloadListener() {
    }

    public void registerOverlays(ModelBakery bakery) {
        HashSet<ResourceLocation> models = new HashSet<ResourceLocation>();
        for (Properties properties : this.models.values()) {
            models.addAll(properties.appendModels);
        }
        for (ResourceLocation model : models) {
            IUnbakedModel unbakedModel = bakery.func_209597_a(model);
            bakery.field_217849_F.put(model, unbakedModel);
            bakery.field_217851_H.put(model, unbakedModel);
        }
    }

    public void applyOverlays(ModelBakery bakery) {
        Map bakedModels = bakery.func_217846_a();
        for (Map.Entry<ModelResourceLocation, Properties> entry : this.models.entrySet()) {
            ModelResourceLocation target = entry.getKey();
            IBakedModel targetModel = (IBakedModel)bakedModels.get(target);
            Properties properties = entry.getValue();
            List<ResourceLocation> overlays = properties.appendModels;
            List<IBakedModel> overlayModels = overlays.stream().map(bakedModels::get).collect(Collectors.toList());
            CustomRenderTypeBakedModel model = new BlockModelModifierBakedModel(targetModel, overlayModels);
            if (properties.paneCullingFix) {
                model = new PaneCullingBakedModel((IBakedModel)model);
            }
            bakedModels.put(target, model);
        }
    }

    public void reload(IResourceManager resourceManager) {
        ResourceLocation location;
        this.models.clear();
        HashMap<ResourceLocation, JsonElement> resources = new HashMap<ResourceLocation, JsonElement>();
        for (ResourceLocation resourceLocation : resourceManager.func_199003_a(LOCATION, s -> s.endsWith(".json"))) {
            location = new ResourceLocation(resourceLocation.func_110624_b(), resourceLocation.func_110623_a().substring(LOCATION.length() + 1, resourceLocation.func_110623_a().length() - ".json".length()));
            try {
                IResource resource = resourceManager.func_199002_a(resourceLocation);
                BufferedReader reader = new BufferedReader(new InputStreamReader(resource.func_199027_b()));
                Throwable throwable = null;
                try {
                    JsonElement element = (JsonElement)JSONUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonElement.class);
                    resources.put(location, element);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (JsonParseException e) {
                FusionClient.LOGGER.error("Failed to parse json from block model overlay '{}'!", (Object)resourceLocation, (Object)e);
            }
            catch (Exception e) {
                FusionClient.LOGGER.error("Encountered an exception whilst reading block model overlay at '{}'!", (Object)resourceLocation, (Object)e);
            }
        }
        for (Map.Entry entry : resources.entrySet()) {
            location = (ResourceLocation)entry.getKey();
            if (!((JsonElement)entry.getValue()).isJsonObject()) {
                throw new IllegalArgumentException("Block model overlay '" + location + "' must contain a json object!");
            }
            JsonObject json = ((JsonElement)entry.getValue()).getAsJsonObject();
            try {
                this.parseResource(json);
            }
            catch (JsonParseException e) {
                FusionClient.LOGGER.error("Failed to parse block model overlay '{}': {}", (Object)location, (Object)e.getMessage());
            }
        }
    }

    private void parseResource(JsonObject json) {
        if (!json.has("targets") || !json.get("targets").isJsonArray()) {
            throw new JsonParseException("Model overlay must have array property 'targets'!");
        }
        JsonArray targetsJson = json.getAsJsonArray("targets");
        HashSet targets = new HashSet();
        for (JsonElement element : targetsJson) {
            if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                if (!IdentifierUtil.isValidIdentifier(element.getAsString())) {
                    throw new JsonParseException("Target must be a valid identifier, not '" + element.getAsString() + "'!!");
                }
                ResourceLocation identifier = new ResourceLocation(element.getAsString());
                Block block = (Block)Registry.field_212618_g.func_82594_a(identifier);
                if (block == null || block == Blocks.field_150350_a) {
                    throw new JsonParseException("Could not find a block for model overlay target '" + identifier + "'!");
                }
                block.func_176194_O().func_177619_a().stream().map(BlockModelShapes::func_209554_c).forEach(targets::add);
                continue;
            }
            if (element.isJsonObject()) {
                this.parseTarget(element.getAsJsonObject()).map(BlockModelShapes::func_209554_c).forEach(targets::add);
                continue;
            }
            throw new JsonParseException("Model overlay 'targets' array must only contain objects and strings!");
        }
        if (targets.isEmpty()) {
            return;
        }
        if (!json.has("append") && !json.has("pane_culling_fix")) {
            throw new JsonParseException("Must have either 'append' or 'pane_culling_fix' property!");
        }
        LinkedHashSet<ResourceLocation> models = new LinkedHashSet<ResourceLocation>();
        if (json.has("append")) {
            if (!json.get("append").isJsonArray()) {
                throw new JsonParseException("Property 'append' must be an array!");
            }
            JsonArray appendJson = json.getAsJsonArray("append");
            for (JsonElement element : appendJson) {
                if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                    throw new JsonParseException("Array property 'append' must only contain strings!");
                }
                if (!IdentifierUtil.isValidIdentifier(element.getAsString())) {
                    throw new JsonParseException("Model must be a valid identifier, not '" + element.getAsString() + "'!!");
                }
                models.add(new ResourceLocation(element.getAsString()));
            }
        }
        boolean paneCullingFix = false;
        if (json.has("pane_culling_fix")) {
            if (!json.get("pane_culling_fix").isJsonPrimitive() || !json.getAsJsonPrimitive("pane_culling_fix").isBoolean()) {
                throw new JsonParseException("Property 'pane_culling_fix' must be a boolean!");
            }
            paneCullingFix = json.get("pane_culling_fix").getAsBoolean();
        }
        if (models.isEmpty() && !paneCullingFix) {
            return;
        }
        for (ModelResourceLocation target : targets) {
            Properties properties = this.models.computeIfAbsent(target, t -> new Properties());
            properties.appendModels.addAll(models);
            properties.paneCullingFix = paneCullingFix;
        }
    }

    private Stream<BlockState> parseTarget(JsonObject json) {
        if (!(json.has("block") && json.get("block").isJsonPrimitive() && json.getAsJsonPrimitive("block").isString())) {
            throw new JsonParseException("Target must have string property 'block'!");
        }
        if (!IdentifierUtil.isValidIdentifier(json.get("block").getAsString())) {
            throw new JsonParseException("Target property 'block' must be a valid identifier, not '" + json.get("block").getAsString() + "'!!");
        }
        ResourceLocation identifier = new ResourceLocation(json.get("block").getAsString());
        Block block = (Block)Registry.field_212618_g.func_82594_a(identifier);
        if (block == null || block == Blocks.field_150350_a) {
            throw new JsonParseException("Could not find a block for model overlay target '" + identifier + "'!");
        }
        HashMap<Property, ImmutableSet> properties = new HashMap<Property, ImmutableSet>();
        if (!json.has("properties") || !json.get("properties").isJsonObject()) {
            throw new JsonParseException("Match block predicate must have object property 'properties'!");
        }
        if (json.getAsJsonObject("properties").size() == 0) {
            throw new JsonParseException("At least one property must be specified for match state predicate!");
        }
        for (Map.Entry entry : json.getAsJsonObject("properties").entrySet()) {
            Property property = block.func_176194_O().func_185920_a((String)entry.getKey());
            if (property == null) {
                throw new JsonParseException("Block '" + identifier + "' does not have a property named '" + (String)entry.getKey() + "'!");
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (((JsonElement)entry.getValue()).isJsonPrimitive() && ((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                Optional value = property.func_185929_b(((JsonElement)entry.getValue()).getAsString());
                if (!value.isPresent()) {
                    throw new JsonParseException("Unknown value '" + ((JsonElement)entry.getValue()).getAsString() + "' for property '" + property.func_177701_a() + "' in block '" + identifier + "'!");
                }
                builder.add(value.get());
            } else if (((JsonElement)entry.getValue()).isJsonArray()) {
                if (((JsonElement)entry.getValue()).getAsJsonArray().size() == 0) {
                    throw new JsonParseException("Valid values for property '" + property.func_177701_a() + "' cannot be empty!");
                }
                for (JsonElement element : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                    if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                        throw new JsonParseException("Property '" + (String)entry.getKey() + "' must be a string or an array of strings!");
                    }
                    Optional value = property.func_185929_b(element.getAsString());
                    if (!value.isPresent()) {
                        throw new JsonParseException("Unknown value '" + element.getAsString() + "' for property '" + property.func_177701_a() + "' in block '" + identifier + "'!");
                    }
                    builder.add(value.get());
                }
            } else {
                throw new JsonParseException("Property '" + (String)entry.getKey() + "' must be a string or an array of strings!");
            }
            properties.put(property, builder.build());
        }
        Stream<Object> states = Stream.of(block.func_176194_O().func_177621_b());
        for (Property property : block.func_176194_O().func_177623_d()) {
            if (properties.containsKey(property)) {
                Set values = (Set)properties.get(property);
                states = states.flatMap(state -> values.stream().map(value -> BlockModelModifierReloadListener.stateWithValue(state, property, value)));
                continue;
            }
            states = states.flatMap(state -> property.func_241491_c_().map(value -> BlockModelModifierReloadListener.stateWithValue(state, property, value.func_241493_b_())));
        }
        return states;
    }

    private static <T extends Comparable<T>> BlockState stateWithValue(BlockState state, Property<?> property, Object value) {
        return (BlockState)state.func_206870_a(property, (Comparable)value);
    }

    private static class Properties {
        final List<ResourceLocation> appendModels = new ArrayList<ResourceLocation>();
        boolean paneCullingFix;

        private Properties() {
        }
    }
}

