/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.resources.FusionPackMetadata;
import net.minecraft.resources.data.IMetadataSectionSerializer;

public class FusionPackMetadataSection
implements IMetadataSectionSerializer<FusionPackMetadata> {
    public static final FusionPackMetadataSection INSTANCE = new FusionPackMetadataSection();

    public String func_110483_a() {
        return "fusion";
    }

    public FusionPackMetadata fromJson(JsonObject json) {
        String minimumVersion = "1.0.0";
        if (json.has("minimum_version")) {
            if (!json.get("minimum_version").isJsonPrimitive() || !json.getAsJsonPrimitive("minimum_version").isString()) {
                throw new JsonParseException("Property 'minimum_version' must be a string!");
            }
            minimumVersion = json.get("minimum_version").getAsString();
            if (!minimumVersion.matches("\\d+\\.\\d+\\.\\d+([a-z].*|[+-].+)?")) {
                throw new JsonParseException("Property 'minimum_version' must be a valid Fusion version, not '" + minimumVersion + "'!");
            }
        }
        String overridesFolder = null;
        if (json.has("overrides_folder")) {
            JsonElement element = json.get("overrides_folder");
            if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                throw new RuntimeException("Property 'overrides_folder' must be a string!");
            }
            overridesFolder = element.getAsString().trim();
            if (!overridesFolder.matches("[a-z0-9/._-]+")) {
                throw new RuntimeException("Property 'overrides_folder' must be a valid path!");
            }
            if (!overridesFolder.endsWith("/")) {
                overridesFolder = overridesFolder + "/";
            }
            if (overridesFolder.startsWith("assets/")) {
                throw new RuntimeException("'overrides_folder' cannot be inside 'assets'!");
            }
            if (overridesFolder.startsWith("data/")) {
                throw new RuntimeException("'overrides_folder' cannot be inside 'data'!");
            }
        }
        return new FusionPackMetadata(minimumVersion, overridesFolder);
    }
}

