/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.resources;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.extensions.PackExtension;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IBidiRenderer;
import net.minecraft.client.gui.screen.PackLoadingManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class MinimumVersionWarningScreen
extends Screen {
    private static final ResourceLocation FUSION_LOGO = new ResourceLocation("fusion", "textures/resourcepacks/fusion_icon.png");
    private final PackLoadingManager.AbstractPack pack;
    private final Consumer<Boolean> confirmation;
    private final ITextComponent title;
    private final int titleWidth;
    private final IReorderingProcessor packName;
    private final IBidiRenderer packDescription;
    private final IBidiRenderer headerMessage;
    private final IBidiRenderer confirmationMessage;
    private final int headerMessageWidth;
    private final int confirmationMessageWidth;
    private final ITextComponent currentVersionLabel;
    private final ITextComponent requiredVersionLabel;
    private final ITextComponent currentVersion;
    private final ITextComponent requiredVersion;
    private final int versionLabelTextWidth;
    private final int versionTextWidth;
    private final Button confirmButton;
    private final Button cancelButton;

    public MinimumVersionWarningScreen(PackLoadingManager.AbstractPack pack, Consumer<Boolean> confirmation) {
        super((ITextComponent)new TranslationTextComponent("fusion.resource_packs.warning_screen.title"));
        this.pack = pack;
        this.confirmation = confirmation;
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        this.title = new TranslationTextComponent("fusion.resource_packs.warning_screen.title").func_240699_a_(TextFormatting.UNDERLINE);
        this.titleWidth = font.func_238414_a_((ITextProperties)this.title);
        int width = font.func_238414_a_((ITextProperties)pack.func_230462_b_());
        if (width > 157) {
            ITextProperties croppedTitle = ITextProperties.func_240655_a_((ITextProperties[])new ITextProperties[]{font.func_238417_a_((ITextProperties)pack.func_230462_b_(), 157 - font.func_78256_a("...")), ITextProperties.func_240652_a_((String)"...")});
            this.packName = LanguageMap.func_74808_a().func_241870_a(croppedTitle);
        } else {
            this.packName = pack.func_230462_b_().func_241878_f();
        }
        this.packDescription = IBidiRenderer.func_243259_a((FontRenderer)font, (ITextProperties)pack.func_243390_f(), (int)157, (int)2);
        this.headerMessage = IBidiRenderer.func_243258_a((FontRenderer)font, (ITextProperties)new TranslationTextComponent("fusion.resource_packs.warning_screen.message"), (int)220);
        this.headerMessageWidth = font.func_238425_b_((ITextProperties)new TranslationTextComponent("fusion.resource_packs.warning_screen.message"), 220).stream().mapToInt(arg_0 -> ((FontRenderer)font).func_243245_a(arg_0)).max().orElse(0);
        this.confirmationMessage = IBidiRenderer.func_243258_a((FontRenderer)font, (ITextProperties)new TranslationTextComponent("fusion.resource_packs.warning_screen.confirmation"), (int)220);
        this.confirmationMessageWidth = font.func_238425_b_((ITextProperties)new TranslationTextComponent("fusion.resource_packs.warning_screen.confirmation"), 220).stream().mapToInt(arg_0 -> ((FontRenderer)font).func_243245_a(arg_0)).max().orElse(0);
        this.currentVersionLabel = new TranslationTextComponent("fusion.resource_packs.warning_screen.current_version");
        this.requiredVersionLabel = new TranslationTextComponent("fusion.resource_packs.warning_screen.required_version");
        this.versionLabelTextWidth = Math.max(font.func_238414_a_((ITextProperties)this.currentVersionLabel), font.func_238414_a_((ITextProperties)this.requiredVersionLabel));
        this.currentVersion = new StringTextComponent(FusionClient.getFusionVersion()).func_240699_a_(TextFormatting.GOLD);
        this.requiredVersion = new StringTextComponent(((PackExtension)pack.field_238878_b_).getFusionMetadata().getMinimumVersion()).func_240699_a_(TextFormatting.GOLD);
        this.versionTextWidth = Math.max(font.func_238414_a_((ITextProperties)this.currentVersion), font.func_238414_a_((ITextProperties)this.requiredVersion));
        this.confirmButton = new Button(0, 0, 80, 20, (ITextComponent)new TranslationTextComponent("fusion.resource_packs.warning_screen.confirm"), b -> confirmation.accept(true));
        this.cancelButton = new Button(0, 0, 80, 20, (ITextComponent)new TranslationTextComponent("fusion.resource_packs.warning_screen.cancel"), b -> confirmation.accept(false));
    }

    public String func_231167_h_() {
        return new TranslationTextComponent("fusion.resource_packs.warning_screen.message").func_230529_a_((ITextComponent)new TranslationTextComponent("fusion.resource_packs.warning_screen.confirmation")).getString();
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.confirmButton.field_230690_l_ = this.field_230708_k_ / 2 - this.confirmButton.func_230998_h_() - 2;
        this.confirmButton.field_230691_m_ = this.field_230709_l_ / 2 + 110 - this.confirmButton.func_238483_d_();
        this.cancelButton.field_230690_l_ = this.field_230708_k_ / 2 + 2;
        this.cancelButton.field_230691_m_ = this.field_230709_l_ / 2 + 110 - this.cancelButton.func_238483_d_();
        this.func_230480_a_((Widget)this.confirmButton);
        this.func_230480_a_((Widget)this.cancelButton);
    }

    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230446_a_(poseStack);
        super.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        poseStack.func_227860_a_();
        poseStack.func_227861_a_((double)((float)this.field_230708_k_ / 2.0f), (double)((float)this.field_230709_l_ / 2.0f - 110.0f), 0.0);
        int titleLeft = -(this.titleWidth + 17) / 2;
        RenderSystem.enableBlend();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(FUSION_LOGO);
        Screen.func_238463_a_((MatrixStack)poseStack, (int)titleLeft, (int)0, (float)0.0f, (float)0.0f, (int)12, (int)12, (int)12, (int)12);
        RenderSystem.disableBlend();
        Screen.func_238475_b_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.title, (int)(titleLeft + 17), (int)2, (int)-1);
        poseStack.func_227865_b_();
        poseStack.func_227860_a_();
        int middleHeight = 98 + this.headerMessage.func_241862_a() * 10 + this.confirmationMessage.func_241862_a() * 10;
        poseStack.func_227861_a_((double)((float)this.field_230708_k_ / 2.0f), (double)((float)(this.field_230709_l_ - middleHeight) / 2.0f), 0.0);
        Screen.func_238467_a_((MatrixStack)poseStack, (int)-98, (int)0, (int)98, (int)36, (int)ColorHelper.PackedColor.func_233006_a_((int)70, (int)255, (int)255, (int)255));
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.pack.func_241868_a());
        Screen.func_238463_a_((MatrixStack)poseStack, (int)-96, (int)2, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
        this.field_230712_o_.func_238407_a_(poseStack, this.packName, -62.0f, 3.0f, 0xFFFFFF);
        this.packDescription.func_241865_b(poseStack, -62, 14, 10, -8355712);
        this.func_238465_a_(poseStack, -115, 115, 44, ColorHelper.PackedColor.func_233006_a_((int)255, (int)255, (int)255, (int)255));
        int textLeft = -Math.max(this.headerMessageWidth, this.confirmationMessageWidth) / 2;
        this.headerMessage.func_241865_b(poseStack, textLeft, 54, 10, -1);
        int textHeight = this.headerMessage.func_241862_a() * 10;
        this.confirmationMessage.func_241865_b(poseStack, textLeft, 58 + textHeight, 10, -1);
        this.func_238465_a_(poseStack, -115, 115, 66 + (textHeight += this.confirmationMessage.func_241862_a() * 10), ColorHelper.PackedColor.func_233006_a_((int)255, (int)255, (int)255, (int)255));
        textLeft = -(this.versionLabelTextWidth + 5 + this.versionTextWidth) / 2;
        Screen.func_238475_b_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.currentVersionLabel, (int)textLeft, (int)(76 + textHeight), (int)ColorHelper.PackedColor.func_233006_a_((int)255, (int)180, (int)180, (int)180));
        Screen.func_238475_b_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.requiredVersionLabel, (int)textLeft, (int)(88 + textHeight), (int)ColorHelper.PackedColor.func_233006_a_((int)255, (int)180, (int)180, (int)180));
        Screen.func_238475_b_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.currentVersion, (int)(textLeft + this.versionLabelTextWidth + 5), (int)(76 + textHeight), (int)0xFFFFFF);
        Screen.func_238475_b_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.requiredVersion, (int)(textLeft + this.versionLabelTextWidth + 5), (int)(88 + textHeight), (int)0xFFFFFF);
        poseStack.func_227865_b_();
    }

    public boolean func_231178_ax__() {
        return false;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.confirmation.accept(false);
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }
}

