/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.base;

import com.google.common.base.Suppliers;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.model.MutableQuad;
import com.supermartijn642.fusion.model.types.base.BaseModelQuad;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.ModelRenderProperties;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.RenderTypeHelper;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class BaseItemModel
implements ItemModel {
    private final List<ItemTintSource> tints;
    private final ModelRenderProperties properties;
    private final List<Pair<RenderType, List<BakedQuad>>> mesh;
    private final Supplier<Vector3f[]> extents;

    public BaseItemModel(List<ItemTintSource> tints, List<BaseModelQuad> quads, ModelRenderProperties properties, RenderType neoforgeRenderType) {
        this.tints = tints;
        this.properties = properties;
        this.extents = Suppliers.memoize(() -> BlockModelWrapper.computeExtents(quads.stream().map(BaseModelQuad::bakedQuad).toList()));
        HashMap<RenderType, List> mesh = new HashMap<RenderType, List>();
        MutableQuad mutableQuad = new MutableQuad();
        for (BaseModelQuad quad : quads) {
            mutableQuad.fillFromBakedQuad(quad.bakedQuad());
            mutableQuad.emissive(quad.emissive());
            RenderType renderType = FusionClient.getRenderTypeMaterial(quad.renderType());
            if (renderType == FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER && neoforgeRenderType != null) {
                renderType = neoforgeRenderType;
            }
            if (renderType != FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER) {
                renderType = RenderTypeHelper.getEntityRenderType((RenderType)renderType);
            }
            List itemQuads = mesh.computeIfAbsent(renderType, k -> new ArrayList());
            itemQuads.add(mutableQuad.toBakedQuad());
        }
        this.mesh = mesh.entrySet().stream().map(entry -> Pair.of((RenderType)entry.getKey(), (List)entry.getValue())).toList();
    }

    public void update(ItemStackRenderState renderState, ItemStack stack, ItemModelResolver modelResolver, ItemDisplayContext displayContext, @Nullable ClientLevel level, @Nullable LivingEntity entity, int i) {
        ItemStackRenderState.FoilType foilType = stack.hasFoil() ? (BlockModelWrapper.hasSpecialAnimatedTexture((ItemStack)stack) ? ItemStackRenderState.FoilType.SPECIAL : ItemStackRenderState.FoilType.STANDARD) : null;
        int tints = this.tints.size();
        int[] tintValues = new int[tints];
        for (int j = 0; j < tints; ++j) {
            tintValues[j] = this.tints.get(j).calculate(stack, level, entity);
        }
        for (Pair<RenderType, List<BakedQuad>> pair : this.mesh) {
            ItemStackRenderState.LayerRenderState layer = renderState.newLayer();
            if (foilType != null) {
                layer.setFoilType(foilType);
            }
            System.arraycopy(tintValues, 0, layer.prepareTintLayers(tints), 0, tintValues.length);
            layer.setExtents(this.extents);
            this.properties.applyToLayer(layer, displayContext);
            layer.prepareQuadList().addAll((Collection)pair.right());
            RenderType renderType = pair.left();
            if (renderType == FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER) {
                renderType = ItemBlockRenderTypes.getRenderType((ItemStack)stack);
            }
            layer.setRenderType(renderType);
        }
    }
}

