/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.base;

import com.google.common.collect.ImmutableList;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.model.BlockModelBakingContext;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.api.model.SpriteIdentifier;
import com.supermartijn642.fusion.api.model.data.BaseModelData;
import com.supermartijn642.fusion.model.types.base.BaseModelElement;
import com.supermartijn642.fusion.model.types.base.BaseModelQuad;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockElementRotation;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.client.resources.model.UnbakedGeometry;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Matrix4fc;
import org.joml.Vector3fc;

public class BaseModelDataImpl
implements BaseModelData {
    protected final BlockModel model;
    protected final List<ResourceLocation> parents;
    protected final List<BaseModelElement> elements;

    public BaseModelDataImpl(BlockModel model, List<ResourceLocation> parents, List<BaseModelElement> elements) {
        this.model = model;
        this.parents = ImmutableList.copyOf(parents);
        this.elements = ImmutableList.copyOf(elements);
    }

    @Override
    public BlockModel getVanillaModel() {
        return this.model;
    }

    @Override
    public List<ResourceLocation> getParents() {
        return this.parents;
    }

    public List<? extends BaseModelElement> getElements() {
        return this.elements;
    }

    public void validateParents(BlockModelBakingContext context) {
        ArrayList<ResourceLocation> encounteredModels = new ArrayList<ResourceLocation>();
        for (ResourceLocation parent : this.parents) {
            this.validateParents(context, parent, encounteredModels);
        }
    }

    private void validateParents(BlockModelBakingContext context, ResourceLocation modelLocation, List<ResourceLocation> encounteredModels) {
        if (encounteredModels.contains(modelLocation)) {
            throw new IllegalStateException("Unable to bake model '" + String.valueOf(context.getModelIdentifier()) + "' due to circular dependency " + encounteredModels.stream().map(o -> "'" + String.valueOf(o) + "'").collect(Collectors.joining("->")) + "->'" + String.valueOf(modelLocation) + "'!");
        }
        encounteredModels.add(modelLocation);
        ModelInstance<?> model = context.getModel(modelLocation);
        if (model != null) {
            for (ResourceLocation dependency : model.getParentModels()) {
                this.validateParents(context, dependency, encounteredModels);
            }
        }
        encounteredModels.remove(encounteredModels.size() - 1);
    }

    public <T> T findProperty(BlockModelBakingContext context, Function<UnbakedModel, T> property, T defaultValue) {
        T value = this.findProperty(context, ModelInstance.of(DefaultModelTypes.BASE, this), property);
        return value == null ? defaultValue : value;
    }

    private <T> T findProperty(BlockModelBakingContext context, ModelInstance<?> model, Function<UnbakedModel, T> property) {
        T value;
        UnbakedModel vanillaModel = model.getAsVanillaModel();
        if (vanillaModel != null && (value = property.apply(vanillaModel)) != null) {
            return value;
        }
        for (ResourceLocation location : model.getParentModels()) {
            T childValue;
            ModelInstance<?> dependency = context.getModel(location);
            if (dependency == null || (childValue = this.findProperty(context, dependency, property)) == null) continue;
            return childValue;
        }
        return null;
    }

    public ItemTransform findItemTransform(BlockModelBakingContext context, ItemDisplayContext transformType) {
        return this.findProperty(context, (UnbakedModel model) -> {
            ItemTransforms transforms = model.transforms();
            if (transforms == null || transforms.getTransform(transformType) == ItemTransform.NO_TRANSFORM) {
                return null;
            }
            return transforms.getTransform(transformType);
        }, ItemTransform.NO_TRANSFORM);
    }

    public SpriteIdentifier findParticleSprite(BlockModelBakingContext context) {
        ModelInstance<BaseModelDataImpl> model = ModelInstance.of(DefaultModelTypes.BASE, this);
        ArrayList<String> encounteredKeys = new ArrayList<String>();
        encounteredKeys.add("particle");
        String currentKey = "particle";
        String finalCurrentKey;
        TextureSlots.SlotContents contents;
        while ((contents = this.findProperty(context, model, arg_0 -> BaseModelDataImpl.lambda$findParticleSprite$2(finalCurrentKey = currentKey, arg_0))) != null) {
            if (contents instanceof TextureSlots.Value) {
                return SpriteIdentifier.of(((TextureSlots.Value)contents).material());
            }
            currentKey = ((TextureSlots.Reference)contents).target();
            if (encounteredKeys.contains(currentKey)) {
                FusionClient.LOGGER.warn("Unable to resolve texture due to circular references {}->'{}' in '{}'!", new Object[]{encounteredKeys.stream().map(o -> "'" + o + "'").collect(Collectors.joining("->")), currentKey, context.getModelIdentifier()});
                return SpriteIdentifier.missing();
            }
            encounteredKeys.add(currentKey);
        }
        return SpriteIdentifier.missing();
    }

    public List<BaseModelQuad> bakeQuads(BlockModelBakingContext context) {
        ArrayList<BaseModelQuad> quads = new ArrayList<BaseModelQuad>();
        this.bakeQuads(context, ModelInstance.of(DefaultModelTypes.BASE, this), context.getModelIdentifier(), new LinkedList(), quads::add);
        return quads;
    }

    private void bakeQuads(BlockModelBakingContext context, ModelInstance<?> model, ResourceLocation modelLocation, Deque<ModelInstance<?>> modelStack, Consumer<BaseModelQuad> output) {
        UnbakedGeometry geometry;
        List<BaseModelElement> elements;
        modelStack.addLast(model);
        if (!(model.getModelType() != DefaultModelTypes.BASE && model.getModelType() != DefaultModelTypes.CONNECTING || (elements = ((BaseModelDataImpl)model.getModelData()).elements) == null || elements.isEmpty())) {
            for (BaseModelElement element : elements) {
                for (Direction direction : element.original.faces().keySet()) {
                    BlockElementFace face = (BlockElementFace)element.original.faces().get(direction);
                    TextureAtlasSprite sprite = context.getTexture(this.resolveMaterial(context, modelStack, face.texture()));
                    BakedQuad quad2 = FaceBakery.bakeQuad((Vector3fc)element.original.from(), (Vector3fc)element.original.to(), (BlockElementFace)face, (TextureAtlasSprite)sprite, (Direction)direction, (ModelState)context.getTransformation(), (BlockElementRotation)element.original.rotation(), (boolean)element.original.shade(), (int)element.original.lightEmission());
                    Direction cullDirection = face.cullForDirection() != null ? Direction.rotate((Matrix4fc)context.getTransformation().transformation().getMatrix(), (Direction)face.cullForDirection()) : null;
                    output.accept(new BaseModelQuad(quad2, cullDirection));
                }
            }
            modelStack.pop();
            return;
        }
        UnbakedModel vanillaModel = model.getAsVanillaModel();
        if (vanillaModel != null && (geometry = vanillaModel.geometry()) != null) {
            QuadCollection quads = geometry.bake(new TextureSlots(context.getTopLevelTextureReferences()), context.getModelBaker(), context.getTransformation(), () -> ((ResourceLocation)modelLocation).toString());
            quads.getQuads(null).forEach(quad -> output.accept(new BaseModelQuad((BakedQuad)quad, null)));
            for (Direction cullDirection : Direction.values()) {
                quads.getQuads(cullDirection).forEach(quad -> output.accept(new BaseModelQuad((BakedQuad)quad, cullDirection)));
            }
            modelStack.pop();
            return;
        }
        for (ResourceLocation location : model.getParentModels()) {
            ModelInstance<?> dependency = context.getModel(location);
            if (dependency == null) continue;
            this.bakeQuads(context, dependency, location, modelStack, output);
        }
        modelStack.removeLast();
    }

    protected SpriteIdentifier resolveMaterial(BlockModelBakingContext context, Deque<ModelInstance<?>> modelStack, String key) {
        if (key.charAt(0) == '#') {
            key = key.substring(1);
        }
        ArrayList<String> encounteredKeys = new ArrayList<String>();
        encounteredKeys.add(key);
        String currentKey = key;
        while (true) {
            ModelInstance<?> model2;
            UnbakedModel vanillaModel;
            TextureSlots.SlotContents contents = null;
            Iterator<ModelInstance<?>> iterator = modelStack.iterator();
            while (iterator.hasNext() && ((vanillaModel = (model2 = iterator.next()).getAsVanillaModel()) == null || (contents = (TextureSlots.SlotContents)vanillaModel.textureSlots().values().get(currentKey)) == null)) {
            }
            if (contents == null) {
                String finalCurrentKey = currentKey;
                contents = this.findProperty(context, modelStack.getLast(), model -> (TextureSlots.SlotContents)model.textureSlots().values().get(finalCurrentKey));
            }
            if (contents == null) {
                return SpriteIdentifier.missing();
            }
            if (contents instanceof TextureSlots.Value) {
                return SpriteIdentifier.of(((TextureSlots.Value)contents).material());
            }
            currentKey = ((TextureSlots.Reference)contents).target();
            if (encounteredKeys.contains(currentKey)) {
                FusionClient.LOGGER.warn("Unable to resolve texture due to circular references {}->'{}' in '{}'!", new Object[]{encounteredKeys.stream().map(o -> "'" + o + "'").collect(Collectors.joining("->")), currentKey, context.getModelIdentifier()});
                return SpriteIdentifier.missing();
            }
            encounteredKeys.add(currentKey);
        }
    }

    protected List<BlockElement> generateItemModel(BlockModelBakingContext context, Deque<ModelInstance<?>> modelStack) {
        ArrayList<BlockElement> elements = new ArrayList<BlockElement>();
        for (int layer = 0; layer < ItemModelGenerator.LAYERS.size(); ++layer) {
            String layerName = (String)ItemModelGenerator.LAYERS.get(layer);
            SpriteIdentifier sprite = this.resolveMaterial(context, modelStack, layerName);
            if (SpriteIdentifier.missing().equals(sprite)) break;
            SpriteContents spriteContents = context.getTexture(sprite).contents();
            elements.addAll(ItemModelGenerator.processFrames((int)layer, (String)layerName, (SpriteContents)spriteContents));
        }
        return elements;
    }

    private static /* synthetic */ TextureSlots.SlotContents lambda$findParticleSprite$2(String finalCurrentKey, UnbakedModel m) {
        return (TextureSlots.SlotContents)m.textureSlots().values().get(finalCurrentKey);
    }
}

