/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.predicate.ConnectionDirection;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.texture.DefaultTextureTypes;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.texture.data.ConnectingTextureLayout;
import com.supermartijn642.fusion.model.types.connecting.ConnectingModelQuad;
import com.supermartijn642.fusion.model.types.connecting.OrientedMutableQuad;
import com.supermartijn642.fusion.model.types.connecting.SurroundingBlockCache;
import com.supermartijn642.fusion.texture.types.connecting.ConnectingTextureSprite;
import com.supermartijn642.fusion.texture.types.connecting.TextureConnections;
import com.supermartijn642.fusion.texture.types.connecting.layouts.ConnectingTextureLayoutHandler;
import com.supermartijn642.fusion.texture.types.continuous.ContinuousTextureSprite;
import com.supermartijn642.fusion.texture.types.continuous.ContinuousTextureType;
import com.supermartijn642.fusion.texture.types.random.RandomTextureSprite;
import com.supermartijn642.fusion.texture.types.random.RandomTextureType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ConnectingBakedModel
implements BlockStateModel {
    private static final int VERTEX_SIZE;
    private static final int VERTEX_UV_OFFSET;
    private static final int VERTEX_POSITION_OFFSET;
    private static final int[][] DEFAULT_TEXTURE_ROTATIONS_UP;
    private static final int[][] DEFAULT_TEXTURE_ROTATIONS_RIGHT;
    private static final Direction[] CULL_DIRECTIONS;
    private final List<BlockModelPart> completeBlockMesh;
    private final Map<RenderType, List<TaggedBakedQuad>[]> blockMesh;
    private final List<RenderType> blockRenderTypes;
    private final List<QuadPredicates> predicates;
    private final List<TextureAtlasSprite> sprites;
    private final boolean hasSpecialQuads;
    private final boolean hasAmbientOcclusion;
    private final TextureAtlasSprite particleIcon;

    private static float[] getUV(BakedQuad quad, int vertexIndex) {
        int offset = vertexIndex * VERTEX_SIZE + VERTEX_UV_OFFSET;
        return new float[]{Float.intBitsToFloat(quad.vertices()[offset]), Float.intBitsToFloat(quad.vertices()[offset + 1])};
    }

    private static float[] getPosition(BakedQuad quad, int vertexIndex) {
        int offset = vertexIndex * VERTEX_SIZE + VERTEX_POSITION_OFFSET;
        return new float[]{Float.intBitsToFloat(quad.vertices()[offset]), Float.intBitsToFloat(quad.vertices()[offset + 1]), Float.intBitsToFloat(quad.vertices()[offset + 2])};
    }

    public ConnectingBakedModel(List<ConnectingModelQuad> quads, final boolean hasAmbientOcclusion, final TextureAtlasSprite particleIcon, RenderType neoforgeRenderType) {
        this.hasAmbientOcclusion = hasAmbientOcclusion;
        this.particleIcon = particleIcon;
        HashMap<RenderType, List[]> blockMesh = new HashMap<RenderType, List[]>();
        HashSet<RenderType> blockRenderTypes = new HashSet<RenderType>();
        HashMap<QuadPredicates, Integer> predicates = new HashMap<QuadPredicates, Integer>();
        HashMap<TextureAtlasSprite, Integer> sprites = new HashMap<TextureAtlasSprite, Integer>();
        boolean hasSpecialQuads = false;
        OrientedMutableQuad mutableQuad = new OrientedMutableQuad();
        for (ConnectingModelQuad quad : quads) {
            TextureType<?> textureType = quad.textureType();
            int spriteIndex = -1;
            int predicateIndex = -1;
            int auxiliaryQuadCount = 0;
            if (quad.hasConnectingTexture()) {
                Direction direction = quad.bakedQuad().direction();
                TextureOrientation orientation = ConnectingBakedModel.findOrientation(quad.bakedQuad());
                ConnectionPredicate predicate = quad.connectionPredicate();
                auxiliaryQuadCount = ConnectingTextureLayoutHandler.get(quad.getLayout()).getAuxiliaryQuadCount();
                predicateIndex = predicates.computeIfAbsent(new QuadPredicates(direction, orientation, predicate), o -> predicates.size());
                spriteIndex = sprites.computeIfAbsent(quad.bakedQuad().sprite(), o -> sprites.size());
            }
            if (quad.textureType() == DefaultTextureTypes.RANDOM || quad.textureType() == DefaultTextureTypes.CONTINUOUS) {
                spriteIndex = sprites.computeIfAbsent(quad.bakedQuad().sprite(), o -> sprites.size());
                hasSpecialQuads = true;
            }
            for (int quadIndex = 0; quadIndex < auxiliaryQuadCount + 1; ++quadIndex) {
                mutableQuad.fillFromBakedQuad(quad.bakedQuad());
                mutableQuad.ambientOcclusion(hasAmbientOcclusion);
                mutableQuad.emissive(quad.emissive());
                TaggedBakedQuad finishedQuad = new TaggedBakedQuad(mutableQuad.toBakedQuad(), textureType, spriteIndex, predicateIndex, quadIndex);
                RenderType renderType = FusionClient.getRenderTypeMaterial(quad.renderType());
                if (renderType == FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER && neoforgeRenderType != null) {
                    renderType = neoforgeRenderType;
                }
                blockRenderTypes.add(renderType);
                int cullIndex = ConnectingBakedModel.cullIndex(quad.cullDirection());
                List[] mesh = blockMesh.computeIfAbsent(renderType, r -> new List[7]);
                if (mesh[cullIndex] == null) {
                    mesh[cullIndex] = new ArrayList();
                }
                mesh[cullIndex].add(finishedQuad);
            }
        }
        this.blockMesh = Map.copyOf(blockMesh);
        this.blockRenderTypes = List.copyOf(blockRenderTypes);
        this.predicates = predicates.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).toList();
        this.sprites = sprites.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).toList();
        this.hasSpecialQuads = hasSpecialQuads;
        ArrayList<1> parts = new ArrayList<1>();
        for (Map.Entry entry : blockMesh.entrySet()) {
            final RenderType renderType = (RenderType)entry.getKey();
            final List[] mesh = (List[])Arrays.stream((List[])entry.getValue()).map(l -> l == null ? List.of() : l.stream().map(q -> q.bakedQuad).toList()).toArray(List[]::new);
            parts.add(new BlockModelPart(){

                public List<BakedQuad> getQuads(@Nullable Direction cullDirection) {
                    return mesh[ConnectingBakedModel.cullIndex(cullDirection)];
                }

                public boolean useAmbientOcclusion() {
                    return hasAmbientOcclusion;
                }

                public TextureAtlasSprite particleIcon() {
                    return particleIcon;
                }

                public RenderType getRenderType(BlockState state) {
                    return renderType == FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER ? ItemBlockRenderTypes.getChunkRenderType((BlockState)state) : renderType;
                }
            });
        }
        this.completeBlockMesh = List.copyOf(parts);
    }

    private static TextureOrientation findOrientation(BakedQuad quad) {
        double angle1to3;
        float[][] uvs = new float[][]{ConnectingBakedModel.getUV(quad, 0), ConnectingBakedModel.getUV(quad, 1), ConnectingBakedModel.getUV(quad, 2), ConnectingBakedModel.getUV(quad, 3)};
        double angle1to2 = Math.atan2(uvs[1][1] - uvs[0][1], uvs[1][0] - uvs[0][0]);
        boolean textureFlipped = (angle1to2 - (angle1to3 = Math.atan2(uvs[2][1] - uvs[0][1], uvs[2][0] - uvs[0][0])) + Math.PI * 4) % (Math.PI * 2) < Math.PI;
        int topLeftMostIndex = 0;
        for (int i = 1; i < 4; ++i) {
            float[] current = uvs[i];
            float[] best = uvs[topLeftMostIndex];
            if (!(current[0] + current[1] < best[0] + best[1])) continue;
            topLeftMostIndex = i;
        }
        int textureRotation = textureFlipped ? topLeftMostIndex : (4 - topLeftMostIndex) % 4;
        float[][] positions3d = new float[][]{ConnectingBakedModel.getPosition(quad, 0), ConnectingBakedModel.getPosition(quad, 1), ConnectingBakedModel.getPosition(quad, 2), ConnectingBakedModel.getPosition(quad, 3)};
        float[][] pos = new float[4][2];
        Direction direction = quad.direction();
        for (int i = 0; i < 4; ++i) {
            if (direction == Direction.DOWN) {
                pos[i][0] = positions3d[i][0];
                pos[i][1] = -positions3d[i][2];
                continue;
            }
            if (direction == Direction.UP) {
                pos[i][0] = positions3d[i][0];
                pos[i][1] = positions3d[i][2];
                continue;
            }
            if (direction == Direction.NORTH) {
                pos[i][0] = -positions3d[i][0];
                pos[i][1] = -positions3d[i][1];
                continue;
            }
            if (direction == Direction.SOUTH) {
                pos[i][0] = positions3d[i][0];
                pos[i][1] = -positions3d[i][1];
                continue;
            }
            if (direction == Direction.WEST) {
                pos[i][0] = positions3d[i][2];
                pos[i][1] = -positions3d[i][1];
                continue;
            }
            if (direction != Direction.EAST) continue;
            pos[i][0] = -positions3d[i][2];
            pos[i][1] = -positions3d[i][1];
        }
        angle1to2 = Math.atan2(pos[1][1] - pos[0][1], pos[1][0] - pos[0][0]);
        boolean quadFlipped = (angle1to2 - (angle1to3 = Math.atan2(pos[2][1] - pos[0][1], pos[2][0] - pos[0][0])) + Math.PI * 4) % (Math.PI * 2) < Math.PI;
        topLeftMostIndex = 0;
        for (int i = 1; i < 4; ++i) {
            float[] current = pos[i];
            float[] best = pos[topLeftMostIndex];
            if (!(current[0] + current[1] < best[0] + best[1])) continue;
            topLeftMostIndex = i;
        }
        int quadRotation = textureFlipped ? topLeftMostIndex : 4 - topLeftMostIndex;
        boolean flipped = textureFlipped ^ quadFlipped;
        int rotation = quadFlipped ? (4 - textureRotation + quadRotation) % 4 : (textureRotation + quadRotation) % 4;
        return TextureOrientation.of(flipped, rotation);
    }

    public void collectParts(BlockAndTintGetter blockView, BlockPos pos, BlockState state, RandomSource random, List<BlockModelPart> parts) {
        boolean processConnectingTextures;
        boolean bl = processConnectingTextures = blockView != null && pos != null && !this.predicates.isEmpty();
        if (!processConnectingTextures && !this.hasSpecialQuads) {
            parts.addAll(this.completeBlockMesh);
            return;
        }
        TextureConnections[] connectionsCache = null;
        SurroundingBlockCache blockCache = null;
        if (processConnectingTextures) {
            connectionsCache = new TextureConnections[this.predicates.size()];
            blockCache = new SurroundingBlockCache(blockView, pos, state);
            if (state != null) {
                blockCache.setSelf(state);
            }
        }
        OrientedMutableQuad mutableQuad = new OrientedMutableQuad();
        for (final RenderType renderType : this.blockRenderTypes) {
            List<TaggedBakedQuad>[] mesh = this.blockMesh.get(renderType);
            final List[] processedMesh = new List[mesh.length];
            for (Direction cullDirection : CULL_DIRECTIONS) {
                List<TaggedBakedQuad> quads = this.blockMesh.get(renderType)[ConnectingBakedModel.cullIndex(cullDirection)];
                if (quads == null) {
                    processedMesh[ConnectingBakedModel.cullIndex((Direction)cullDirection)] = List.of();
                    continue;
                }
                ArrayList<BakedQuad> bakedQuads = new ArrayList<BakedQuad>(quads.size());
                for (TaggedBakedQuad quad : quads) {
                    if (pos != null && (quad.textureType == DefaultTextureTypes.RANDOM || quad.textureType == DefaultTextureTypes.CONTINUOUS)) {
                        TextureAtlasSprite sprite = this.sprites.get(quad.spriteIndex);
                        mutableQuad.fillFromBakedQuad(quad.bakedQuad);
                        mutableQuad.resetPermutation();
                        if (quad.textureType == DefaultTextureTypes.RANDOM) {
                            RandomTextureType.processQuad(mutableQuad, pos, quad.bakedQuad.direction(), random, (RandomTextureSprite)sprite);
                        } else {
                            ContinuousTextureType.processQuad(mutableQuad, pos, quad.bakedQuad.direction(), (ContinuousTextureSprite)sprite);
                        }
                        bakedQuads.add(mutableQuad.toBakedQuad());
                        continue;
                    }
                    if (blockCache != null && quad.textureType == DefaultTextureTypes.CONNECTING) {
                        int quadIndex = quad.quadIndex;
                        int predicateIndex = quad.predicateIndex;
                        int spriteIndex = quad.spriteIndex;
                        QuadPredicates predicate = this.predicates.get(predicateIndex);
                        TextureConnections connections = connectionsCache[predicateIndex];
                        if (connections == null) {
                            connections = connectionsCache[predicateIndex] = ConnectingBakedModel.computeConnections(predicate, blockCache);
                        }
                        TextureAtlasSprite sprite = this.sprites.get(spriteIndex);
                        ConnectingTextureLayout layout = ((ConnectingTextureSprite)sprite).data().getLayout();
                        mutableQuad.fillFromBakedQuad(quad.bakedQuad);
                        mutableQuad.set(predicate.orientation.vertexIndexPermutation);
                        boolean keepQuad = ConnectingTextureLayoutHandler.get(layout).processBlockQuad(quadIndex, mutableQuad, (ConnectingTextureSprite)sprite, connections);
                        if (!keepQuad) continue;
                        bakedQuads.add(mutableQuad.toBakedQuad());
                        continue;
                    }
                    bakedQuads.add(quad.bakedQuad);
                }
                processedMesh[ConnectingBakedModel.cullIndex((Direction)cullDirection)] = bakedQuads;
            }
            parts.add(new BlockModelPart(){

                public List<BakedQuad> getQuads(@Nullable Direction cullDirection) {
                    return processedMesh[ConnectingBakedModel.cullIndex(cullDirection)];
                }

                public boolean useAmbientOcclusion() {
                    return ConnectingBakedModel.this.hasAmbientOcclusion;
                }

                public TextureAtlasSprite particleIcon() {
                    return ConnectingBakedModel.this.particleIcon;
                }

                public RenderType getRenderType(BlockState state) {
                    return renderType == FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER ? ItemBlockRenderTypes.getChunkRenderType((BlockState)state) : renderType;
                }
            });
        }
    }

    public void collectParts(RandomSource random, List<BlockModelPart> parts) {
        this.collectParts(null, null, null, random, parts);
    }

    private static TextureConnections computeConnections(QuadPredicates predicates, SurroundingBlockCache blocks) {
        ConnectionPredicate predicate = predicates.predicate;
        Direction face = predicates.direction;
        TextureOrientation orientation = predicates.orientation;
        int[] up = orientation.transformWorldVector(DEFAULT_TEXTURE_ROTATIONS_UP[face.ordinal()], face);
        int[] right = orientation.transformWorldVector(DEFAULT_TEXTURE_ROTATIONS_RIGHT[face.ordinal()], face);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        boolean connectTop = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[0], up[0], up[1], up[2], mutablePos);
        boolean connectTopRight = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[1], up[0] + right[0], up[1] + right[1], up[2] + right[2], mutablePos);
        boolean connectRight = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[2], right[0], right[1], right[2], mutablePos);
        boolean connectBottomRight = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[3], -up[0] + right[0], -up[1] + right[1], -up[2] + right[2], mutablePos);
        boolean connectBottom = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[4], -up[0], -up[1], -up[2], mutablePos);
        boolean connectBottomLeft = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[5], -up[0] - right[0], -up[1] - right[1], -up[2] - right[2], mutablePos);
        boolean connectLeft = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[6], -right[0], -right[1], -right[2], mutablePos);
        boolean connectTopLeft = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[7], up[0] - right[0], up[1] - right[1], up[2] - right[2], mutablePos);
        return new TextureConnections(connectTop, connectTopRight, connectRight, connectBottomRight, connectBottom, connectBottomLeft, connectLeft, connectTopLeft);
    }

    private static boolean shouldConnect(ConnectionPredicate predicate, SurroundingBlockCache blocks, Direction face, ConnectionDirection direction, int neighborX, int neighborY, int neighborZ, BlockPos.MutableBlockPos mutablePos) {
        BlockAndTintGetter level = blocks.getLevel();
        BlockPos position = blocks.getRealPos();
        BlockState self = blocks.getCenter();
        BlockState neighborState = blocks.getState(neighborX, neighborY, neighborZ);
        mutablePos.set(position.getX() + neighborX, position.getY() + neighborY, position.getZ() + neighborZ);
        BlockState selfAppearance = self.getAppearance(level, position, face, neighborState, (BlockPos)mutablePos);
        BlockState otherStateAppearance = neighborState.getAppearance(level, (BlockPos)mutablePos, face, self, position);
        BlockState stateInFront = blocks.getState(neighborX + face.getStepX(), neighborY + face.getStepY(), neighborZ + face.getStepZ());
        return predicate.shouldConnect((BlockGetter)level, position, face, selfAppearance, otherStateAppearance, stateInFront, direction);
    }

    public TextureAtlasSprite particleIcon() {
        return this.particleIcon;
    }

    private static int cullIndex(Direction cullDirection) {
        return cullDirection == null ? 0 : cullDirection.ordinal() + 1;
    }

    static {
        DEFAULT_TEXTURE_ROTATIONS_UP = new int[6][];
        DEFAULT_TEXTURE_ROTATIONS_RIGHT = new int[6][];
        CULL_DIRECTIONS = new Direction[]{null, Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
        VERTEX_SIZE = DefaultVertexFormat.BLOCK.getVertexSize() / 4;
        VERTEX_UV_OFFSET = DefaultVertexFormat.BLOCK.getOffset(VertexFormatElement.UV) / 4;
        VERTEX_POSITION_OFFSET = DefaultVertexFormat.BLOCK.getOffset(VertexFormatElement.POSITION) / 4;
        for (Direction direction : Direction.values()) {
            int upX = 0;
            int upY = 0;
            int upZ = 0;
            int rightX = 0;
            int rightY = 0;
            int rightZ = 0;
            if (direction == Direction.DOWN) {
                upZ = 1;
                rightX = 1;
            } else if (direction == Direction.UP) {
                upZ = -1;
                rightX = 1;
            } else if (direction == Direction.NORTH) {
                upY = 1;
                rightX = -1;
            } else if (direction == Direction.SOUTH) {
                upY = 1;
                rightX = 1;
            } else if (direction == Direction.WEST) {
                upY = 1;
                rightZ = 1;
            } else if (direction == Direction.EAST) {
                upY = 1;
                rightZ = -1;
            }
            ConnectingBakedModel.DEFAULT_TEXTURE_ROTATIONS_UP[direction.ordinal()] = new int[]{upX, upY, upZ};
            ConnectingBakedModel.DEFAULT_TEXTURE_ROTATIONS_RIGHT[direction.ordinal()] = new int[]{rightX, rightY, rightZ};
        }
    }

    static enum TextureOrientation {
        NORMAL_0(false, 0),
        NORMAL_90(false, 1),
        NORMAL_180(false, 2),
        NORMAL_270(false, 3),
        FLIPPED_0(true, 0),
        FLIPPED_90(false, 1),
        FLIPPED_180(true, 2),
        FLIPPED_270(true, 3);

        public final boolean flipped;
        public final int rotations;
        public final ConnectionDirection[] worldToTexture;
        public final int[] vertexIndexPermutation;

        public static TextureOrientation of(boolean flipped, int rotations) {
            return TextureOrientation.values()[flipped ? 4 + rotations : rotations];
        }

        private TextureOrientation(boolean flipped, int rotations) {
            this.flipped = flipped;
            this.rotations = rotations;
            this.worldToTexture = ConnectionDirection.values();
            this.vertexIndexPermutation = new int[]{0, 3, 2, 1};
            if (flipped) {
                this.worldToTexture[ConnectionDirection.TOP.ordinal()] = ConnectionDirection.LEFT;
                this.worldToTexture[ConnectionDirection.TOP_RIGHT.ordinal()] = ConnectionDirection.BOTTOM_LEFT;
                this.worldToTexture[ConnectionDirection.RIGHT.ordinal()] = ConnectionDirection.BOTTOM;
                this.worldToTexture[ConnectionDirection.LEFT.ordinal()] = ConnectionDirection.TOP;
                this.worldToTexture[ConnectionDirection.BOTTOM_LEFT.ordinal()] = ConnectionDirection.TOP_RIGHT;
                this.worldToTexture[ConnectionDirection.BOTTOM.ordinal()] = ConnectionDirection.RIGHT;
                this.vertexIndexPermutation[1] = 1;
                this.vertexIndexPermutation[3] = 3;
            }
            if (rotations != 0) {
                ConnectionDirection[] old = Arrays.copyOf(this.worldToTexture, this.worldToTexture.length);
                for (int i = 0; i < 8; ++i) {
                    this.worldToTexture[i] = old[(i - rotations * 2 + 8) % 8];
                }
                int[] old2 = Arrays.copyOf(this.vertexIndexPermutation, this.vertexIndexPermutation.length);
                for (int i = 0; i < 4; ++i) {
                    this.vertexIndexPermutation[i] = old2[(i + rotations + 4) % 4];
                }
            }
        }

        public int[] transformWorldVector(int[] vector, Direction face) {
            boolean positive;
            if (!this.flipped && this.rotations == 0) {
                return vector;
            }
            int[] newVector = Arrays.copyOf(vector, vector.length);
            Direction.Axis axis = face.getAxis();
            boolean bl = positive = face.getAxisDirection() == Direction.AxisDirection.POSITIVE;
            if (this.flipped) {
                if (face.getAxis() == Direction.Axis.X) {
                    newVector[1] = positive ? vector[2] : -vector[2];
                    int n = newVector[2] = positive ? vector[1] : -vector[1];
                }
                if (face.getAxis() == Direction.Axis.Y) {
                    newVector[0] = positive ? vector[2] : -vector[2];
                    int n = newVector[2] = positive ? vector[0] : -vector[0];
                }
                if (face.getAxis() == Direction.Axis.Z) {
                    newVector[0] = positive ? vector[1] : -vector[1];
                    int n = newVector[1] = positive ? vector[0] : -vector[0];
                }
            }
            if (this.rotations > 0) {
                if (this.rotations == 2) {
                    if (axis != Direction.Axis.X) {
                        newVector[0] = -newVector[0];
                    }
                    if (axis != Direction.Axis.Y) {
                        newVector[1] = -newVector[1];
                    }
                    if (axis != Direction.Axis.Z) {
                        newVector[2] = -newVector[2];
                    }
                } else {
                    int oldX = newVector[0];
                    int oldY = newVector[1];
                    if (axis != Direction.Axis.X) {
                        newVector[0] = (positive ^ this.rotations == 3 ? 1 : -1) * (axis == Direction.Axis.Y ? -newVector[2] : newVector[1]);
                    }
                    if (axis != Direction.Axis.Y) {
                        newVector[1] = (positive ^ this.rotations == 3 ? 1 : -1) * (axis == Direction.Axis.Z ? -oldX : newVector[2]);
                    }
                    if (axis != Direction.Axis.Z) {
                        newVector[2] = (positive ^ this.rotations == 3 ? 1 : -1) * (axis == Direction.Axis.X ? -oldY : oldX);
                    }
                }
            }
            return newVector;
        }
    }

    private static class QuadPredicates {
        public final Direction direction;
        public final TextureOrientation orientation;
        public final ConnectionPredicate predicate;

        private QuadPredicates(Direction direction, TextureOrientation orientation, ConnectionPredicate predicate) {
            this.direction = direction;
            this.orientation = orientation;
            this.predicate = predicate;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof QuadPredicates)) {
                return false;
            }
            QuadPredicates that = (QuadPredicates)o;
            return this.direction == that.direction && this.orientation == that.orientation && this.predicate.equals(that.predicate);
        }

        public int hashCode() {
            int result = this.direction.hashCode();
            result = 31 * result + this.orientation.hashCode();
            result = 31 * result + this.predicate.hashCode();
            return result;
        }
    }

    private static class TaggedBakedQuad {
        final BakedQuad bakedQuad;
        final TextureType<?> textureType;
        final int spriteIndex;
        final int predicateIndex;
        final int quadIndex;

        private TaggedBakedQuad(BakedQuad bakedQuad, TextureType<?> textureType, int spriteIndex, int predicateIndex, int quadIndex) {
            this.bakedQuad = bakedQuad;
            this.textureType = textureType;
            this.spriteIndex = spriteIndex;
            this.predicateIndex = predicateIndex;
            this.quadIndex = quadIndex;
        }
    }
}

