/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.resources;

import com.supermartijn642.fusion.resources.FusionPackMetadata;
import com.supermartijn642.fusion.resources.MinimumVersionWarningScreen;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.packs.PackSelectionModel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;

public class ResourcePackListTipRenderer {
    private static final ResourceLocation FUSION_LOGO = ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"textures/resourcepacks/fusion_icon_blurred.png");

    public static void renderBackground(FusionPackMetadata metadata, boolean isVanillaCompatible, GuiGraphics graphics, int x, int y, int width, int height) {
        if (isVanillaCompatible && !metadata.isMinVersionSatisfied()) {
            graphics.fill(x - 1, y - 1, x + width - 3, y + height + 1, ARGB.color((int)255, (int)114, (int)83, (int)0));
        }
    }

    public static void renderIcon(FusionPackMetadata metadata, boolean isVanillaCompatible, GuiGraphics graphics, int x, int y, int width, int height) {
        graphics.blit(RenderType::guiTextured, FUSION_LOGO, x, y, 0.0f, 0.0f, 12, 12, 12, 12);
    }

    public static Component getWarningMessage(FusionPackMetadata metadata, boolean isVanillaCompatible) {
        if (isVanillaCompatible && !metadata.isMinVersionSatisfied()) {
            return Component.translatable((String)"fusion.resource_packs.requires_newer_version").withStyle(ChatFormatting.GRAY);
        }
        return null;
    }

    public static boolean showWarningScreen(FusionPackMetadata metadata, boolean isVanillaCompatible, PackSelectionModel.EntryBase entry, Consumer<Boolean> confirmation) {
        if (!isVanillaCompatible || metadata.isMinVersionSatisfied()) {
            return false;
        }
        Minecraft.getInstance().setScreen((Screen)new MinimumVersionWarningScreen(entry, confirmation));
        return true;
    }
}

