/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Arrays;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;

public class MutableQuad {
    private static final int VERTEX_SIZE;
    private static final int LIGHTMAP_OFFSET;
    private static final int UV_OFFSET;
    private static final int POSITION_OFFSET;
    private final int[] vertices;
    private int tintIndex;
    private Direction lightFace;
    private TextureAtlasSprite sprite;
    private boolean shade;
    private boolean emissive = false;

    protected MutableQuad(int[] vertexData) {
        this.vertices = vertexData;
    }

    public MutableQuad() {
        this(new int[VERTEX_SIZE * 4]);
    }

    public void fillFromBakedQuad(BakedQuad quad) {
        System.arraycopy(quad.m_111303_(), 0, this.vertices, 0, this.vertices.length);
        this.tintIndex = quad.m_111305_();
        this.lightFace = quad.m_111306_();
        this.sprite = quad.m_173410_();
        this.shade = quad.m_111307_();
        this.emissive = false;
    }

    public void emissive(boolean emissive) {
        this.emissive = emissive;
    }

    public void lightmap(int vertexIndex, int lightmap) {
        int offset = vertexIndex * VERTEX_SIZE + LIGHTMAP_OFFSET;
        this.vertices[offset] = lightmap;
    }

    public int lightmap(int vertexIndex) {
        int offset = vertexIndex * VERTEX_SIZE + LIGHTMAP_OFFSET;
        return this.vertices[offset];
    }

    public void uv(int vertexIndex, float u, float v) {
        int offset = vertexIndex * VERTEX_SIZE + UV_OFFSET;
        this.vertices[offset] = Float.floatToRawIntBits(u);
        this.vertices[offset + 1] = Float.floatToRawIntBits(v);
    }

    public float u(int vertexIndex) {
        int offset = vertexIndex * VERTEX_SIZE + UV_OFFSET;
        return Float.intBitsToFloat(this.vertices[offset]);
    }

    public float v(int vertexIndex) {
        int offset = vertexIndex * VERTEX_SIZE + UV_OFFSET + 1;
        return Float.intBitsToFloat(this.vertices[offset]);
    }

    public void pos(int vertexIndex, float x, float y, float z) {
        int offset = vertexIndex * VERTEX_SIZE + POSITION_OFFSET;
        this.vertices[offset] = Float.floatToRawIntBits(x);
        this.vertices[offset + 1] = Float.floatToRawIntBits(y);
        this.vertices[offset + 2] = Float.floatToRawIntBits(z);
    }

    public float x(int vertexIndex) {
        int offset = vertexIndex * VERTEX_SIZE + POSITION_OFFSET;
        return Float.intBitsToFloat(this.vertices[offset]);
    }

    public float y(int vertexIndex) {
        int offset = vertexIndex * VERTEX_SIZE + POSITION_OFFSET + 1;
        return Float.intBitsToFloat(this.vertices[offset]);
    }

    public float z(int vertexIndex) {
        int offset = vertexIndex * VERTEX_SIZE + POSITION_OFFSET + 2;
        return Float.intBitsToFloat(this.vertices[offset]);
    }

    public BakedQuad toBakedQuad() {
        if (this.emissive) {
            for (int i = 0; i < 4; ++i) {
                this.lightmap(i, 0xF000F0);
            }
        }
        return new BakedQuad(Arrays.copyOf(this.vertices, this.vertices.length), this.tintIndex, this.lightFace, this.sprite, !this.emissive && this.shade);
    }

    static {
        VertexFormat format = DefaultVertexFormat.f_85811_;
        VERTEX_SIZE = format.m_86020_() / 4;
        LIGHTMAP_OFFSET = format.getOffset(format.m_86023_().indexOf((Object)DefaultVertexFormat.f_85808_)) / 4;
        UV_OFFSET = format.getOffset(format.m_86023_().indexOf((Object)DefaultVertexFormat.f_166849_)) / 4;
        POSITION_OFFSET = format.getOffset(format.m_86023_().indexOf((Object)DefaultVertexFormat.f_85804_)) / 4;
    }
}

