/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.resources;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.extensions.PackExtension;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.packs.PackSelectionModel;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;

public class MinimumVersionWarningScreen
extends Screen {
    private static final ResourceLocation FUSION_LOGO = new ResourceLocation("fusion", "textures/resourcepacks/fusion_icon.png");
    private final PackSelectionModel.EntryBase pack;
    private final Consumer<Boolean> confirmation;
    private final Component title;
    private final int titleWidth;
    private final FormattedCharSequence packName;
    private final MultiLineLabel packDescription;
    private final MultiLineLabel headerMessage;
    private final MultiLineLabel confirmationMessage;
    private final int headerMessageWidth;
    private final int confirmationMessageWidth;
    private final Component currentVersionLabel;
    private final Component requiredVersionLabel;
    private final Component currentVersion;
    private final Component requiredVersion;
    private final int versionLabelTextWidth;
    private final int versionTextWidth;
    private final Button confirmButton;
    private final Button cancelButton;

    public MinimumVersionWarningScreen(PackSelectionModel.EntryBase pack, Consumer<Boolean> confirmation) {
        super((Component)new TranslatableComponent("fusion.resource_packs.warning_screen.title"));
        this.pack = pack;
        this.confirmation = confirmation;
        Font font = Minecraft.m_91087_().f_91062_;
        this.title = new TranslatableComponent("fusion.resource_packs.warning_screen.title").m_130940_(ChatFormatting.UNDERLINE);
        this.titleWidth = font.m_92852_((FormattedText)this.title);
        int width = font.m_92852_((FormattedText)pack.m_7356_());
        if (width > 157) {
            FormattedText croppedTitle = FormattedText.m_130773_((FormattedText[])new FormattedText[]{font.m_92854_((FormattedText)pack.m_7356_(), 157 - font.m_92895_("...")), FormattedText.m_130775_((String)"...")});
            this.packName = Language.m_128107_().m_5536_(croppedTitle);
        } else {
            this.packName = pack.m_7356_().m_7532_();
        }
        this.packDescription = MultiLineLabel.m_94345_((Font)font, (FormattedText)pack.m_99929_(), (int)157, (int)2);
        this.headerMessage = MultiLineLabel.m_94341_((Font)font, (FormattedText)new TranslatableComponent("fusion.resource_packs.warning_screen.message"), (int)220);
        this.headerMessageWidth = font.m_92923_((FormattedText)new TranslatableComponent("fusion.resource_packs.warning_screen.message"), 220).stream().mapToInt(arg_0 -> ((Font)font).m_92724_(arg_0)).max().orElse(0);
        this.confirmationMessage = MultiLineLabel.m_94341_((Font)font, (FormattedText)new TranslatableComponent("fusion.resource_packs.warning_screen.confirmation"), (int)220);
        this.confirmationMessageWidth = font.m_92923_((FormattedText)new TranslatableComponent("fusion.resource_packs.warning_screen.confirmation"), 220).stream().mapToInt(arg_0 -> ((Font)font).m_92724_(arg_0)).max().orElse(0);
        this.currentVersionLabel = new TranslatableComponent("fusion.resource_packs.warning_screen.current_version");
        this.requiredVersionLabel = new TranslatableComponent("fusion.resource_packs.warning_screen.required_version");
        this.versionLabelTextWidth = Math.max(font.m_92852_((FormattedText)this.currentVersionLabel), font.m_92852_((FormattedText)this.requiredVersionLabel));
        this.currentVersion = new TextComponent(FusionClient.getFusionVersion()).m_130940_(ChatFormatting.GOLD);
        this.requiredVersion = new TextComponent(((PackExtension)pack.f_99933_).getFusionMetadata().getMinimumVersion()).m_130940_(ChatFormatting.GOLD);
        this.versionTextWidth = Math.max(font.m_92852_((FormattedText)this.currentVersion), font.m_92852_((FormattedText)this.requiredVersion));
        this.confirmButton = new Button(0, 0, 80, 20, (Component)new TranslatableComponent("fusion.resource_packs.warning_screen.confirm"), b -> confirmation.accept(true));
        this.cancelButton = new Button(0, 0, 80, 20, (Component)new TranslatableComponent("fusion.resource_packs.warning_screen.cancel"), b -> confirmation.accept(false));
    }

    public Component m_142562_() {
        return new TranslatableComponent("fusion.resource_packs.warning_screen.message").m_7220_((Component)new TranslatableComponent("fusion.resource_packs.warning_screen.confirmation"));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.confirmButton.f_93620_ = this.f_96543_ / 2 - this.confirmButton.m_5711_() - 2;
        this.confirmButton.f_93621_ = this.f_96544_ / 2 + 110 - this.confirmButton.m_93694_();
        this.cancelButton.f_93620_ = this.f_96543_ / 2 + 2;
        this.cancelButton.f_93621_ = this.f_96544_ / 2 + 110 - this.cancelButton.m_93694_();
        this.m_142416_((GuiEventListener)this.confirmButton);
        this.m_142416_((GuiEventListener)this.cancelButton);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        poseStack.m_85836_();
        poseStack.m_85837_((double)((float)this.f_96543_ / 2.0f), (double)((float)this.f_96544_ / 2.0f - 110.0f), 0.0);
        int titleLeft = -(this.titleWidth + 17) / 2;
        RenderSystem.m_69478_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)FUSION_LOGO);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)titleLeft, (int)0, (float)0.0f, (float)0.0f, (int)12, (int)12, (int)12, (int)12);
        RenderSystem.m_69461_();
        GuiComponent.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.title, (int)(titleLeft + 17), (int)2, (int)-1);
        poseStack.m_85849_();
        poseStack.m_85836_();
        int middleHeight = 98 + this.headerMessage.m_5770_() * 10 + this.confirmationMessage.m_5770_() * 10;
        poseStack.m_85837_((double)((float)this.f_96543_ / 2.0f), (double)((float)(this.f_96544_ - middleHeight) / 2.0f), 0.0);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)-98, (int)0, (int)98, (int)36, (int)FastColor.ARGB32.m_13660_((int)70, (int)255, (int)255, (int)255));
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.pack.m_6876_());
        GuiComponent.m_93133_((PoseStack)poseStack, (int)-96, (int)2, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
        GuiComponent.m_168756_((PoseStack)poseStack, (Font)this.f_96547_, (FormattedCharSequence)this.packName, (int)-62, (int)3, (int)0xFFFFFF);
        this.packDescription.m_6516_(poseStack, -62, 14, 10, -8355712);
        this.m_93154_(poseStack, -115, 115, 44, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
        int textLeft = -Math.max(this.headerMessageWidth, this.confirmationMessageWidth) / 2;
        this.headerMessage.m_6516_(poseStack, textLeft, 54, 10, -1);
        int textHeight = this.headerMessage.m_5770_() * 10;
        this.confirmationMessage.m_6516_(poseStack, textLeft, 58 + textHeight, 10, -1);
        this.m_93154_(poseStack, -115, 115, 66 + (textHeight += this.confirmationMessage.m_5770_() * 10), FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
        textLeft = -(this.versionLabelTextWidth + 5 + this.versionTextWidth) / 2;
        GuiComponent.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.currentVersionLabel, (int)textLeft, (int)(76 + textHeight), (int)FastColor.ARGB32.m_13660_((int)255, (int)180, (int)180, (int)180));
        GuiComponent.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.requiredVersionLabel, (int)textLeft, (int)(88 + textHeight), (int)FastColor.ARGB32.m_13660_((int)255, (int)180, (int)180, (int)180));
        GuiComponent.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.currentVersion, (int)(textLeft + this.versionLabelTextWidth + 5), (int)(76 + textHeight), (int)0xFFFFFF);
        GuiComponent.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.requiredVersion, (int)(textLeft + this.versionLabelTextWidth + 5), (int)(88 + textHeight), (int)0xFFFFFF);
        poseStack.m_85849_();
    }

    public boolean m_6913_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.confirmation.accept(false);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }
}

